/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.webflow.diagram.WebflowDiagramPresentationConstants;
import com.intellij.spring.webflow.diagram.beans.WebflowDiagramEdge;
import com.intellij.spring.webflow.diagram.beans.WebflowDiagramNode;
import com.intellij.spring.webflow.diagram.beans.WebflowEdgeType;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.diagram.editor.CreateTransitionDialog;
import com.intellij.spring.webflow.diagram.managers.WebflowDiagramColorManager;
import com.intellij.spring.webflow.diagram.managers.WebflowNodeContentManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.converters.ParentStateReference;
import com.intellij.spring.webflow.model.xml.ActionState;
import com.intellij.spring.webflow.model.xml.AttributesOwner;
import com.intellij.spring.webflow.model.xml.DecisionState;
import com.intellij.spring.webflow.model.xml.EndState;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.GlobalTransitions;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.IdentifiedWithParent;
import com.intellij.spring.webflow.model.xml.If;
import com.intellij.spring.webflow.model.xml.StartState;
import com.intellij.spring.webflow.model.xml.SubflowState;
import com.intellij.spring.webflow.model.xml.Transition;
import com.intellij.spring.webflow.model.xml.TransitionOwner;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.spring.webflow.model.xml.ViewTransition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.events.DomEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowDiagramDataModel
extends DiagramDataModel<WebflowElementWrapper> {
    public static final DiagramCategory EVENTS = new DiagramCategory("Events", AllIcons.Actions.Lightning, true, true, true);
    public static final DiagramCategory SUB_FLOWS = new DiagramCategory("Sub Flows", AllIcons.Nodes.Jsf.Component, true, true, true);
    private final Collection<DiagramNode<WebflowElementWrapper>> myNodes = new HashSet<DiagramNode<WebflowElementWrapper>>();
    private final Collection<DiagramEdge<WebflowElementWrapper>> myEdges = new HashSet<DiagramEdge<WebflowElementWrapper>>();
    private final WebflowElementWrapper<?> myRootElementWrapper;
    private final DiagramPresentationModel myPresentationModel;

    public WebflowDiagramDataModel(Project project, DiagramProvider<WebflowElementWrapper> provider, WebflowElementWrapper<?> rootElementWrapper, DiagramPresentationModel presentationModel) {
        super(project, provider);
        this.myRootElementWrapper = rootElementWrapper;
        this.myPresentationModel = presentationModel;
        this.setShowDependencies(true);
        DomManager.getDomManager((Project)project).addDomEventListener(new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                WebflowDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/webflow/diagram/WebflowDiagramDataModel$1", "eventOccured"));
            }
        }, (Disposable)this);
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, (ProjectWideFacetListener)new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                WebflowDiagramDataModel.this.incModificationCount();
            }

            public void facetRemoved(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                WebflowDiagramDataModel.this.incModificationCount();
            }

            public void facetAdded(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                WebflowDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/webflow/diagram/WebflowDiagramDataModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        connection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                WebflowDiagramDataModel.this.incModificationCount();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS);
        connection.subscribe(ProjectTopics.MODULES);
    }

    public boolean isDependencyDiagramSupported() {
        return true;
    }

    public boolean isPsiListener() {
        return true;
    }

    public boolean hasFile(PsiFile file) {
        for (WebflowModel model : this.getFlowModels()) {
            if (!model.getFlowFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    public void removeNode(DiagramNode<WebflowElementWrapper> node) {
        this.myNodes.remove(node);
        SmartList toRemove = new SmartList();
        for (DiagramEdge<WebflowElementWrapper> edge : this.myEdges) {
            if (!edge.getSource().equals(node) && !edge.getTarget().equals(node)) continue;
            toRemove.add(edge);
        }
        this.myEdges.removeAll((Collection<?>)toRemove);
    }

    @NotNull
    public Collection<DiagramNode<WebflowElementWrapper>> getNodes() {
        Collection<DiagramNode<WebflowElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<WebflowElementWrapper>> getEdges() {
        Collection<DiagramEdge<WebflowElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<WebflowElementWrapper> node) {
        if (node == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(2);
        }
        String string = node.getTooltip();
        if (string == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DiagramNode<WebflowElementWrapper> addElement(@Nullable WebflowElementWrapper element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        WebflowDiagramNode node = new WebflowDiagramNode(element, (DiagramProvider<WebflowElementWrapper>)this.getProvider());
        if (!this.myNodes.contains((Object)node)) {
            this.myNodes.add((DiagramNode<WebflowElementWrapper>)node);
            return node;
        }
        return null;
    }

    public DiagramEdge<WebflowElementWrapper> createEdge(@NotNull DiagramNode<WebflowElementWrapper> from, @NotNull DiagramNode<WebflowElementWrapper> to) {
        if (from == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(4);
        }
        if (to == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(5);
        }
        if (this.getBuilder().isPopupMode()) {
            return null;
        }
        DomElement fromDom = ((WebflowDomElementWrapper)from.getIdentifyingElement()).getElement();
        DomElement toDom = ((WebflowDomElementWrapper)to.getIdentifyingElement()).getElement();
        if (fromDom instanceof TransitionOwner && !(fromDom instanceof GlobalTransitions) && toDom instanceof Identified) {
            return this.createTransitionEdge((TransitionOwner)fromDom, (Identified)toDom);
        }
        return super.createEdge(from, to);
    }

    private DiagramEdge<WebflowElementWrapper> createTransitionEdge(@NotNull TransitionOwner from, Identified to) {
        if (from == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(6);
        }
        Callable<DiagramEdge> callable = () -> {
            if (from == null) {
                WebflowDiagramDataModel.$$$reportNull$$$0(15);
            }
            Flow flow = (Flow)from.getParentOfType(Flow.class, true);
            assert (flow != null);
            ArrayList targets = new ArrayList(DomUtil.getChildrenOfType((DomElement)flow, Identified.class));
            for (Flow parentFlow : flow.getAllRelatedFlows()) {
                targets.addAll(DomUtil.getChildrenOfType((DomElement)parentFlow, Identified.class));
            }
            ArrayList<AttributesOwner> sources = new ArrayList<AttributesOwner>();
            sources.addAll(flow.getActionStates());
            sources.addAll(flow.getSubflowStates());
            sources.addAll(flow.getViewStates());
            CreateTransitionDialog dialog = new CreateTransitionDialog(this.getProject(), sources, from, targets, to);
            dialog.setTitle("Create New Transition");
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return null;
            }
            TransitionOwner selectedFrom = dialog.getSelectedSource();
            Identified selectedTo = dialog.getSelectedTarget();
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{selectedFrom.getXmlElement(), selectedTo.getXmlElement()})) {
                return null;
            }
            Transition transition = selectedFrom.addTransition();
            String onValue = dialog.getOn();
            if (StringUtil.isNotEmpty((String)onValue)) {
                transition.getOn().setStringValue(onValue);
            }
            transition.getTo().setValue((Object)selectedTo);
            return this.addEdge(this.findNodeByDomElement(selectedFrom), this.findNodeByDomElement(selectedTo), transition, WebflowEdgeType.TO, null);
        };
        return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)"Spring Web Flow Edge", null, (PsiElement[])this.getAffectedFiles());
    }

    @NotNull
    public List<WebflowModel> getFlowModels() {
        List<WebflowModel> list = this.myRootElementWrapper.getFlowModels();
        if (list == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public PsiFile[] getAffectedFiles() {
        HashSet<XmlFile> modelFiles = new HashSet<XmlFile>();
        for (WebflowModel webflowModel : this.getFlowModels()) {
            modelFiles.add(webflowModel.getFlowFile());
        }
        PsiFile[] psiFileArray = (PsiFile[])ArrayUtil.toObjectArray(modelFiles, XmlFile.class);
        if (psiFileArray == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(8);
        }
        return psiFileArray;
    }

    @Nullable
    private WebflowDiagramEdge addEdge(@Nullable DiagramNode<WebflowElementWrapper> source, @Nullable DiagramNode<WebflowElementWrapper> target, @Nullable DomElement definingElement, @NotNull WebflowEdgeType edgeType, @Nullable String customInfo) {
        WebflowDiagramEdge edge;
        if (edgeType == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(9);
        }
        if (source != null && target != null && !this.myEdges.contains((Object)(edge = new WebflowDiagramEdge(source, target, definingElement, edgeType, customInfo)))) {
            this.myEdges.add((DiagramEdge<WebflowElementWrapper>)edge);
            return edge;
        }
        return null;
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.updateDataModel();
    }

    private void updateDataModel() {
        if (this.getBuilder().isPopupMode()) {
            this.setShowDependencies(false);
            this.myPresentationModel.getPresentation().setCategoryEnabled(WebflowNodeContentManager.DETAILS, false);
            this.myPresentationModel.getPresentation().setCategoryEnabled(EVENTS, false);
        }
        List<WebflowModel> flowModels = this.getFlowModels();
        Set skipFlows = ContainerUtil.map2Set(flowModels, WebflowModel::getFlow);
        HashSet<Flow> processedFlows = new HashSet<Flow>();
        for (WebflowModel model : flowModels) {
            Flow flow = model.getFlow();
            this.addFlowNodes(flow, processedFlows);
            if (!this.isShowDependencies()) continue;
            List<Flow> flows = flow.getAllRelatedFlows();
            flows.removeAll(skipFlows);
            for (Flow parentFlow : flows) {
                this.addFlowNodes(parentFlow, processedFlows);
            }
        }
        this.createEdges();
    }

    /*
     * WARNING - void declaration
     */
    private void addFlowNodes(@NotNull Flow flow, Set<Flow> processedFlows) {
        DiagramNode<WebflowElementWrapper> globalTransitionsNode;
        GlobalTransitions transitions;
        DiagramNode<WebflowElementWrapper> startNode;
        void var4_15;
        if (flow == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(10);
        }
        if (!processedFlows.add(flow)) {
            return;
        }
        for (ActionState actionState : flow.getActionStates()) {
            this.addNodeWithEventNodes(actionState, actionState.getOnEntry(), actionState.getOnExit());
        }
        for (ViewState viewState : flow.getViewStates()) {
            this.addNodeWithEventNodes(viewState, viewState.getOnEntry(), viewState.getOnExit(), viewState.getOnRender());
        }
        for (DecisionState decisionState : flow.getDecisionStates()) {
            this.addNodeWithEventNodes(decisionState, decisionState.getOnEntry(), decisionState.getOnExit());
        }
        for (EndState endState : flow.getEndStates()) {
            this.addNodeWithEventNodes(endState, endState.getOnEntry());
        }
        boolean showSubFlows = this.myPresentationModel.getPresentation().isCategoryEnabled(SUB_FLOWS);
        for (SubflowState subflowState : flow.getSubflowStates()) {
            Flow subFlow;
            this.addNodeWithEventNodes(subflowState, subflowState.getOnEntry(), subflowState.getOnExit());
            if (!showSubFlows || (subFlow = (Flow)subflowState.getSubflow().getValue()) == null) continue;
            this.addFlowNodes(subFlow, processedFlows);
            if (!this.isShowDependencies()) continue;
            List<Flow> subFlowAllParentFlows = subFlow.getAllParentFlows();
            for (Flow parentFlow : subFlowAllParentFlows) {
                this.addFlowNodes(parentFlow, processedFlows);
            }
        }
        if (DomUtil.hasXml((DomElement)flow.getStartState())) {
            Identified identified = (Identified)flow.getStartState().getIdref().getValue();
        } else {
            Identified identified = flow.determineStartState();
        }
        if (var4_15 != null && (startNode = this.findNodeByDomElement((DomElement)var4_15)) != null) {
            WebflowDomElementWrapper element = (WebflowDomElementWrapper)startNode.getIdentifyingElement();
            element.putUserData(WebflowDomElementWrapper.IS_START_STATE, Boolean.TRUE);
        }
        if (!(transitions = flow.getGlobalTransitions()).getTransitions().isEmpty() && (globalTransitionsNode = this.addElement(new WebflowDomElementWrapper(transitions))) != null) {
            globalTransitionsNode.putUserData(WebflowDiagramColorManager.CUSTOM_NODE_HEADER_COLOR, (Object)WebflowDiagramPresentationConstants.NODE_GLOBAL_TRANSITIONS_COLOR);
        }
        if (this.isShowEvents()) {
            this.addNodeWithEventNodes(null, flow.getOnStart(), flow.getOnEnd());
        }
    }

    private boolean isShowEvents() {
        return this.myPresentationModel.getPresentation().isCategoryEnabled(EVENTS);
    }

    private void addNodeWithEventNodes(@Nullable DomElement source, DomElement ... eventElements) {
        DiagramNode<WebflowElementWrapper> sourceNode;
        if (eventElements == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(11);
        }
        DiagramNode<WebflowElementWrapper> diagramNode = sourceNode = source != null ? this.addElement(new WebflowDomElementWrapper(source)) : null;
        if (!this.isShowEvents()) {
            return;
        }
        for (DomElement domElement : eventElements) {
            DiagramNode<WebflowElementWrapper> eventNode;
            if (!DomUtil.hasXml((DomElement)domElement) || (eventNode = this.addElement(new WebflowDomElementWrapper(domElement))) == null) continue;
            eventNode.putUserData(WebflowDiagramColorManager.CUSTOM_NODE_HEADER_COLOR, (Object)WebflowDiagramPresentationConstants.NODE_EVENT_COLOR);
            if (sourceNode == null) continue;
            this.addEdge(sourceNode, eventNode, null, WebflowEdgeType.EVENT, null);
        }
    }

    private void createEdges() {
        for (DiagramNode<WebflowElementWrapper> diagramNode : this.myNodes) {
            PsiReference[] psiReferenceArray;
            IdentifiedWithParent identifiedWithParent;
            SubflowState subflowState;
            Flow subflow;
            Object onValue;
            Object element = ((WebflowElementWrapper)diagramNode.getIdentifyingElement()).getElement();
            if (element instanceof StartState) {
                StartState startState = (StartState)element;
                Identified startIdentified = (Identified)startState.getIdref().getValue();
                if (startIdentified != null) {
                    this.addEdge(diagramNode, this.findNodeByDomElement(startIdentified), null, WebflowEdgeType.TO, "Start");
                }
            } else if (element instanceof GlobalTransitions) {
                GlobalTransitions globalTransitions = (GlobalTransitions)element;
                for (ViewTransition viewTransition : globalTransitions.getTransitions()) {
                    Identified toIdentified = (Identified)viewTransition.getTo().getValue();
                    if (toIdentified == null) continue;
                    PsiClass onException = (PsiClass)viewTransition.getOnException().getValue();
                    if (onException != null) {
                        this.addEdge(diagramNode, this.findNodeByDomElement(toIdentified), viewTransition, WebflowEdgeType.ON_EXCEPTION, onException.getName());
                        continue;
                    }
                    onValue = viewTransition.getOn().getStringValue();
                    this.addEdge(diagramNode, this.findNodeByDomElement(toIdentified), viewTransition, WebflowEdgeType.GLOBAL_TO, (String)onValue);
                }
            } else if (element instanceof TransitionOwner) {
                TransitionOwner transitionOwner = (TransitionOwner)element;
                List<? extends Transition> transitions = transitionOwner.getTransitions();
                for (Transition transition3 : transitions) {
                    Identified toIdentified = (Identified)transition3.getTo().getValue();
                    if (toIdentified == null) continue;
                    PsiClass onException = (PsiClass)transition3.getOnException().getValue();
                    if (onException != null) {
                        this.addEdge(diagramNode, this.findNodeByDomElement(toIdentified), transition3, WebflowEdgeType.ON_EXCEPTION, onException.getName());
                        continue;
                    }
                    String onValue2 = transition3.getOn().getStringValue();
                    this.addEdge(diagramNode, this.findNodeByDomElement(toIdentified), transition3, WebflowEdgeType.TO, onValue2);
                }
            } else if (element instanceof DecisionState) {
                DecisionState decisionState = (DecisionState)element;
                List<If> ifs = decisionState.getIfs();
                for (If anIf : ifs) {
                    Identified elseIdentified;
                    String test = anIf.getTest().getStringValue();
                    Identified thenIdentified = (Identified)anIf.getThen().getValue();
                    if (thenIdentified != null) {
                        this.addEdge(diagramNode, this.findNodeByDomElement(thenIdentified), anIf, WebflowEdgeType.THEN, test);
                    }
                    if ((elseIdentified = (Identified)anIf.getElse().getValue()) == null) continue;
                    this.addEdge(diagramNode, this.findNodeByDomElement(elseIdentified), (DomElement)anIf.getElse(), WebflowEdgeType.ELSE, null);
                }
            }
            if (element instanceof SubflowState && (subflow = (Flow)(subflowState = (SubflowState)element).getSubflow().getValue()) != null) {
                Identified identified = subflow.determineStartState();
                if (identified != null) {
                    this.addEdge(diagramNode, this.findNodeByDomElement(identified), null, WebflowEdgeType.SUBFLOW, "<<Subflow Start>>");
                }
                for (Transition transition4 : subflowState.getTransitions()) {
                    onValue = transition4.getOn().getValue();
                    if (!(onValue instanceof Identified)) continue;
                    this.addEdge(this.findNodeByDomElement((DomElement)onValue), diagramNode, null, WebflowEdgeType.SUBFLOW, transition4.getOn().getStringValue());
                }
            }
            if (!this.isShowDependencies() || !(element instanceof IdentifiedWithParent) || !DomUtil.hasXml((identifiedWithParent = (IdentifiedWithParent)element).getParentAction())) continue;
            XmlAttributeValue xmlAttributeValue = identifiedWithParent.getParentAction().getXmlAttributeValue();
            assert (xmlAttributeValue != null);
            for (PsiReference reference : psiReferenceArray = xmlAttributeValue.getReferences()) {
                ParentStateReference parentStateReference;
                Identified identified;
                if (!(reference instanceof ParentStateReference) || (identified = (parentStateReference = (ParentStateReference)reference).getIdentified()) == null) continue;
                this.addEdge(diagramNode, this.findNodeByDomElement(identified), (DomElement)identifiedWithParent.getParentAction(), WebflowEdgeType.PARENT, "<<extends>>");
            }
        }
    }

    @Nullable
    private DiagramNode<WebflowElementWrapper> findNodeByDomElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(12);
        }
        return (DiagramNode)ContainerUtil.find(this.myNodes, node -> {
            if (domElement == null) {
                WebflowDiagramDataModel.$$$reportNull$$$0(14);
            }
            return ((WebflowElementWrapper)node.getIdentifyingElement()).getElement().equals(domElement);
        });
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        WebflowDiagramDataModel webflowDiagramDataModel = this;
        if (webflowDiagramDataModel == null) {
            WebflowDiagramDataModel.$$$reportNull$$$0(13);
        }
        return webflowDiagramDataModel;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/diagram/WebflowDiagramDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventElements";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/diagram/WebflowDiagramDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowModels";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTransitionEdge";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFlowNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addNodeWithEventNodes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNodeByDomElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findNodeByDomElement$1";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTransitionEdge$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

