/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.editor;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.webflow.diagram.WebflowDiagramDataModel;
import com.intellij.spring.webflow.diagram.beans.WebflowDiagramEdge;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteElementAction
extends DiagramActionWithPreparation<Pair<DomElement, String>> {
    public DeleteElementAction() {
        super("Delete Element", "Delete Selected Element", null);
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            DeleteElementAction.$$$reportNull$$$0(0);
        }
        return !b.isPopupMode() && DeleteElementAction.getSelectedDomElement(e) != null;
    }

    public PsiFile[] getAffectedFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            DeleteElementAction.$$$reportNull$$$0(1);
        }
        WebflowDiagramDataModel model = (WebflowDiagramDataModel)DiagramAction.getDataModel((AnActionEvent)e);
        assert (model != null);
        return model.getAffectedFiles();
    }

    @Nullable
    public Pair<DomElement, String> prepare(@NotNull AnActionEvent e) {
        if (e == null) {
            DeleteElementAction.$$$reportNull$$$0(2);
        }
        DomElement element = DeleteElementAction.getSelectedDomElement(e);
        assert (element != null);
        ElementPresentation presentation = element.getPresentation();
        String elementName = presentation.getElementName();
        String typeName = presentation.getTypeName();
        String elementDescription = typeName + (elementName != null ? " '" + elementName + "'" : "");
        int result = Messages.showOkCancelDialog((String)("Do you really want to delete " + elementDescription + " ?"), (String)("Delete " + typeName), (Icon)Messages.getWarningIcon());
        return result == 0 ? Pair.create((Object)element, (Object)elementDescription) : null;
    }

    public void execute(DiagramBuilder builder, Pair<DomElement, String> info, AnActionEvent e) {
        if (info == null) {
            return;
        }
        DomElement element = (DomElement)info.first;
        String elementDescription = (String)info.second;
        DiagramAction.performCommand((DiagramBuilder)builder, () -> {
            element.undefine();
            builder.getDataModel().refreshDataModel();
        }, (String)("Delete " + elementDescription), null, (PsiElement[])new PsiElement[]{DomUtil.getFile((DomElement)element)});
    }

    public String getActionName() {
        return this.getTemplatePresentation().getText();
    }

    @Nullable
    private static DomElement getSelectedDomElement(@NotNull AnActionEvent e) {
        DomElement nodeElement;
        if (e == null) {
            DeleteElementAction.$$$reportNull$$$0(3);
        }
        if ((nodeElement = DeleteElementAction.getSelectedNodeDomElement(e)) != null) {
            return nodeElement;
        }
        return DeleteElementAction.getSelectedEdgeDomElement(e);
    }

    @Nullable
    private static DomElement getSelectedNodeDomElement(@NotNull AnActionEvent e) {
        List nodes;
        if (e == null) {
            DeleteElementAction.$$$reportNull$$$0(4);
        }
        if ((nodes = DeleteElementAction.getSelectedNodesExceptNotes((AnActionEvent)e)).size() != 1) {
            return null;
        }
        WebflowDomElementWrapper wrapper = (WebflowDomElementWrapper)((DiagramNode)nodes.get(0)).getIdentifyingElement();
        return wrapper.getElement();
    }

    @Nullable
    private static DomElement getSelectedEdgeDomElement(@NotNull AnActionEvent e) {
        List edges;
        if (e == null) {
            DeleteElementAction.$$$reportNull$$$0(5);
        }
        if ((edges = DiagramUtils.getSelectedEdges((DiagramBuilder)DeleteElementAction.getBuilder((AnActionEvent)e))).size() != 1) {
            return null;
        }
        DiagramEdge edge = (DiagramEdge)edges.get(0);
        if (edge instanceof WebflowDiagramEdge) {
            return ((WebflowDiagramEdge)edge).getDefiningElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/spring/webflow/diagram/editor/DeleteElementAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedDomElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedNodeDomElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedEdgeDomElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

