/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.managers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.spring.webflow.diagram.beans.WebflowDiagramEdge;
import com.intellij.spring.webflow.diagram.beans.WebflowEdgeType;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class WebflowUmlNodeHighlighter
implements UmlNodeHighlighter<WebflowElementWrapper> {
    public List<DiagramNode<WebflowElementWrapper>> onNodeSelected(List<DiagramNode<WebflowElementWrapper>> selectedNodes, DiagramDataModel<WebflowElementWrapper> model) {
        if (selectedNodes.size() != 1) {
            return Collections.emptyList();
        }
        SmartList highlightNodes = new SmartList();
        WebflowUmlNodeHighlighter.collectNodes((List<DiagramNode<WebflowElementWrapper>>)highlightNodes, new HashSet<DiagramEdge<WebflowElementWrapper>>(), model, (DiagramNode<WebflowElementWrapper>)((DiagramNode)ContainerUtil.getFirstItem(selectedNodes)));
        return highlightNodes;
    }

    private static void collectNodes(List<DiagramNode<WebflowElementWrapper>> highlightNodes, Collection<DiagramEdge<WebflowElementWrapper>> visitedEdges, DiagramDataModel<WebflowElementWrapper> model, DiagramNode<WebflowElementWrapper> node) {
        List<DiagramEdge<WebflowElementWrapper>> outgoingEdges = WebflowUmlNodeHighlighter.getOutgoingEdges(model, node);
        if (outgoingEdges.isEmpty()) {
            highlightNodes.add(node);
            return;
        }
        for (DiagramEdge<WebflowElementWrapper> edge : outgoingEdges) {
            if (visitedEdges.contains(edge)) continue;
            highlightNodes.add(node);
            visitedEdges.add(edge);
            WebflowUmlNodeHighlighter.collectNodes(highlightNodes, visitedEdges, model, (DiagramNode<WebflowElementWrapper>)edge.getTarget());
        }
    }

    private static List<DiagramEdge<WebflowElementWrapper>> getOutgoingEdges(DiagramDataModel<WebflowElementWrapper> model, DiagramNode<WebflowElementWrapper> node) {
        return ContainerUtil.findAll((Collection)model.getEdges(), edge -> {
            WebflowDiagramEdge webflowDiagramEdge = (WebflowDiagramEdge)((Object)edge);
            WebflowEdgeType type = webflowDiagramEdge.getEdgeType();
            return type != WebflowEdgeType.PARENT && edge.getSource().equals(node);
        });
    }

    public void selectionChanged(DiagramBuilder builder) {
    }
}

