/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el.inject;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.ElContextProviderEx;
import com.intellij.spring.webflow.el.ELVariablesCollectorUtils;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class WebflowELExpressionContextProvider
extends ElContextProviderEx {
    private final PsiElement myHost;

    public WebflowELExpressionContextProvider(PsiElement host) {
        this.myHost = host;
    }

    @Nullable
    public Iterator<? extends PsiVariable> getTopLevelElVariables(@Nullable String nameHint) {
        return ELVariablesCollectorUtils.getVariables(this.myHost, ELVariablesCollectorUtils.CollectType.INCLUDE_APPLICATION_VARIABLES, ELVariablesCollectorUtils.CollectScope.LOCAL, nameHint).iterator();
    }

    public boolean acceptsGetMethodForLastReference(PsiMethod getter) {
        return true;
    }

    public boolean acceptsSetMethodForLastReference(PsiMethod setter) {
        return false;
    }

    public boolean acceptsNonPropertyMethodForLastReference(PsiMethod method) {
        return !WebflowELExpressionContextProvider.isObjectClassMethod(method);
    }

    private static boolean isObjectClassMethod(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName());
    }
}

