/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.impl.FlowDefinition;
import com.intellij.spring.webflow.model.impl.FlowDefinitionCollector;
import com.intellij.spring.webflow.model.impl.WebflowModelImpl;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WebflowDomModelFactory
extends DomModelFactory<Flow, WebflowModel, PsiElement> {
    WebflowDomModelFactory(Project project) {
        super(Flow.class, project, "webflow");
    }

    @Nullable
    protected List<WebflowModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            WebflowDomModelFactory.$$$reportNull$$$0(0);
        }
        List<FlowDefinition> definitions = FlowDefinitionCollector.forModule(module);
        ArrayList<WebflowModel> models = new ArrayList<WebflowModel>(definitions.size());
        for (FlowDefinition definition : definitions) {
            WebflowModel webflowModel = this.createSingleModel(definition);
            ContainerUtil.addIfNotNull(models, (Object)webflowModel);
        }
        return models;
    }

    protected WebflowModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<Flow> mergedModel, WebflowModel firstModel, Module module) {
        if (configFiles == null) {
            WebflowDomModelFactory.$$$reportNull$$$0(1);
        }
        if (mergedModel == null) {
            WebflowDomModelFactory.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    private WebflowModel createSingleModel(FlowDefinition flowDefinition) {
        PsiFile file = PsiManager.getInstance((Project)this.getProject()).findFile(flowDefinition.getFlowXml());
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XmlFile flowXml = (XmlFile)file;
        DomFileElement flowDomFileElement = this.getDomRoot(flowXml);
        if (flowDomFileElement == null) {
            return null;
        }
        return new WebflowModelImpl((DomFileElement<Flow>)flowDomFileElement, Collections.singleton(flowXml), flowDefinition.getDefinition(), flowDefinition.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/webflow/model/impl/WebflowDomModelFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAllModels";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCombinedModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

