/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.actions;

import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.actions.WeblogicCreateDatasourceDialog;
import com.intellij.javaee.weblogic.agent.WebLogicAgentExtension;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicUtil;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.javaee.weblogic.module.WeblogicEjbFacetUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class WeblogicMissingDatasourcesDialog
extends DialogWrapper {
    private final List<? extends EnterpriseBean> myMissingDatasourceEjbs;
    private final WebLogicAgentExtension myAgentExtension;
    private final List<? extends EjbFacet> myEjbFacetsAffected;
    private JButton myConfigureButton;
    private JList myMissingDSList;
    private JList myConfiguredDSList;
    private DefaultListModel myMissingDSDataModel;
    private DefaultListModel myConfiguredDSDataModel;
    private final Project myProject;
    private JPanel myPanel;

    public WeblogicMissingDatasourcesDialog(Project project, List<? extends EnterpriseBean> missingDatasourceEjbs, WebLogicAgentExtension agentExtension, List<? extends EjbFacet> ejbFacets) {
        super(project, false);
        this.myProject = project;
        this.myMissingDatasourceEjbs = missingDatasourceEjbs;
        this.myAgentExtension = agentExtension;
        this.myEjbFacetsAffected = ejbFacets;
        this.$$$setupUI$$$();
        this.init();
        this.setOKButtonText(WeblogicBundle.message("button.continue", new Object[0]));
        this.setTitle(WeblogicBundle.message("dialog.title.configure.missing.datasources", new Object[0]));
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void init() {
        this.myMissingDSDataModel = new DefaultListModel();
        HashSet<Object> dataSourceNames = new HashSet<Object>();
        for (int i = 0; i < this.myMissingDatasourceEjbs.size(); ++i) {
            EntityBean entityBean = (EntityBean)this.myMissingDatasourceEjbs.get(i);
            EjbFacet ejbFacet = this.myEjbFacetsAffected.get(i);
            WeblogicRdbmsBean rdbmsBean = WeblogicUtil.findRdbmsBean(WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet), (String)entityBean.getEjbName().getValue());
            if (rdbmsBean == null) continue;
            dataSourceNames.add(rdbmsBean.getRightDataSourceName().getValue());
        }
        for (String string : dataSourceNames) {
            this.myMissingDSDataModel.addElement(string);
        }
        DefaultListCellRenderer iconizedCellRenderer = new DefaultListCellRenderer();
        iconizedCellRenderer.setIcon(DatabaseIcons.Dbms);
        this.myMissingDSList.setCellRenderer(iconizedCellRenderer);
        this.myMissingDSList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WeblogicMissingDatasourcesDialog.this.missingDataSourceSelectionChanged();
            }
        });
        this.myMissingDSList.setModel(this.myMissingDSDataModel);
        this.myConfigureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = WeblogicMissingDatasourcesDialog.this.myMissingDSList.getSelectedIndex();
                if (selectedIndex == -1) {
                    return;
                }
                String dsName = (String)WeblogicMissingDatasourcesDialog.this.myMissingDSList.getSelectedValue();
                WeblogicMissingDatasourcesDialog.this.createDataSource(dsName);
            }
        });
        this.myConfiguredDSDataModel = new DefaultListModel();
        this.refreshConfiguredDatasourceList();
        this.myConfiguredDSList.setCellRenderer(iconizedCellRenderer);
        this.myConfiguredDSList.setModel(this.myConfiguredDSDataModel);
        this.myMissingDSList.setSelectedIndex(0);
        super.init();
    }

    private void refreshConfiguredDatasourceList() {
        this.myConfiguredDSDataModel.clear();
        if (this.myAgentExtension != null) {
            String[] dataSourceNames;
            for (String dataSourceName : dataSourceNames = this.myAgentExtension.getConfiguredDataSourceNames()) {
                this.myConfiguredDSDataModel.addElement(dataSourceName);
            }
        }
    }

    private void missingDataSourceSelectionChanged() {
        int selectedIndex = this.myMissingDSList.getSelectedIndex();
        this.myConfigureButton.setEnabled(selectedIndex != -1);
    }

    private void createDataSource(String dsName) {
        WeblogicCreateDatasourceDialog dialog = this.createDataSourceDialog(this.myProject, dsName);
        if (!dialog.showAndGet()) {
            return;
        }
        this.myMissingDSDataModel.removeElement(dsName);
        this.refreshConfiguredDatasourceList();
        this.missingDataSourceSelectionChanged();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.javaee.weblogic.actions.WeblogicMissingDatasourcesDialog";
    }

    protected abstract WeblogicCreateDatasourceDialog createDataSourceDialog(Project var1, String var2);

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("label.missing.datasource.description"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConfigureButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("button.configure"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("border.missing.datasources.group"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myMissingDSList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("com/intellij/javaee/weblogic/WeblogicBundle").getString("border.configured.datasources.list"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList2 = new JBList();
        this.myConfiguredDSList = jBList2;
        jBScrollPane2.setViewportView((Component)jBList2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

