/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.editors;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.xml.ejb.EjbRelation;
import com.intellij.javaee.model.xml.ejb.EjbRelationshipRole;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicUtil;
import com.intellij.javaee.weblogic.model.persistence.TableMap;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsJar;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsRelation;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRelationshipRole;
import com.intellij.javaee.weblogic.module.WeblogicEjbFacetUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.Nullable;

public class RdbmsHelper {
    private final EjbRelation myRelation;
    private final EjbRelationshipRole myRole;
    private final WeblogicRdbmsRelation myRdbmsRelation;
    private final WeblogicRelationshipRole myRdbmsRole;

    public RdbmsHelper(WeblogicRdbmsRelation rdbmsRelation, WeblogicRelationshipRole rdbmsRole, EjbRelation relation, EjbRelationshipRole role) {
        this.myRdbmsRelation = rdbmsRelation;
        this.myRdbmsRole = rdbmsRole;
        this.myRelation = relation;
        this.myRole = role;
    }

    public WeblogicRdbmsRelation getRdbmsRelation() {
        return this.myRdbmsRelation;
    }

    @Nullable
    public DasTable findTable(WeblogicRdbmsBean rdbmsBeanObject, String s) {
        String dataSourceName = (String)rdbmsBeanObject.getRightDataSourceName().getValue();
        DbDataSource dataSource = (DbDataSource)DbUtil.getDataSources((Project)this.getProject()).filter(DasUtil.byName((String)dataSourceName)).first();
        if (dataSource == null) {
            return null;
        }
        if (!Comparing.equal((String)s, (String)"")) {
            return (DasTable)DasUtil.getTables((DasDataSource)dataSource).filter(DasUtil.byName((String)s)).first();
        }
        List<TableMap> tableMaps = rdbmsBeanObject.getTableMaps();
        if (tableMaps.isEmpty()) {
            return null;
        }
        if (tableMaps.size() == 1) {
            return (DasTable)DasUtil.getTables((DasDataSource)dataSource).filter(DasUtil.byName((String)((String)tableMaps.get(0).getTableName().getValue()))).first();
        }
        return null;
    }

    @Nullable
    public WeblogicRdbmsBean getRdbmsBeanObject(EjbRelationshipRole role) {
        if (role == null) {
            return null;
        }
        GenericDomValue reference = role.getRelationshipRoleSource().getEntityBean();
        if (reference.getValue() == null) {
            return null;
        }
        return WeblogicUtil.findRdbmsBean(RdbmsHelper.getRdbmsRootDescriptor((JavaeeModelElement)this.myRelation), reference.getStringValue());
    }

    public List<String> getSuitableNames(JComboBox pkTableName, EjbRelationshipRole role, boolean isPrimary) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.myRdbmsRelation == null) {
            return result;
        }
        WeblogicRdbmsBean rdbmsBeanObject = this.getRdbmsBeanObject(role);
        if (rdbmsBeanObject != null) {
            String joinTableName = (String)this.myRdbmsRelation.getTableName().getValue();
            DasTable table = this.findTable(rdbmsBeanObject, !isPrimary && joinTableName != null ? joinTableName : (String)pkTableName.getEditor().getItem());
            if (table != null) {
                for (DasColumn field : DasUtil.getColumns((DasObject)table)) {
                    if (DasUtil.isPrimary((DasColumn)field) != isPrimary) continue;
                    result.add(field.getName());
                }
            }
        }
        return result;
    }

    @Nullable
    private static WeblogicRdbmsJar getRdbmsRootDescriptor(JavaeeModelElement object) {
        EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)object);
        if (ejbFacet == null) {
            return null;
        }
        return WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet);
    }

    public Project getProject() {
        return this.getModule().getProject();
    }

    private Module getModule() {
        return this.myRelation.getModule();
    }

    public EjbRelationshipRole getTargetRole() {
        EjbRelation relation = (EjbRelation)this.myRole.getParent();
        EjbRelationshipRole role1 = relation.getEjbRelationshipRole1();
        return role1.equals(this.myRole) ? relation.getEjbRelationshipRole2() : role1;
    }

    public EjbRelationshipRole getRole() {
        return this.myRole;
    }

    public WeblogicRelationshipRole getRdbmsRelationRole() {
        return this.myRdbmsRole;
    }

    public static List<String> getAllAvailableTableNames(EjbRelation relation) {
        ArrayList<String> result = new ArrayList<String>();
        WeblogicRdbmsJar rdbmsRootDescriptor = RdbmsHelper.getRdbmsRootDescriptor((JavaeeModelElement)relation);
        Project project = relation.getManager().getProject();
        RdbmsHelper.processRole(rdbmsRootDescriptor, relation.getEjbRelationshipRole1(), project, result);
        RdbmsHelper.processRole(rdbmsRootDescriptor, relation.getEjbRelationshipRole2(), project, result);
        return result;
    }

    private static void processRole(WeblogicRdbmsJar rdbmsRootDescriptor, EjbRelationshipRole ejbRelationRole, Project project, ArrayList<String> result) {
        DbDataSource dataSource;
        String dataSourceName;
        String ejbName = ejbRelationRole.getRelationshipRoleSource().getEntityBean().getStringValue();
        if (ejbName == null) {
            return;
        }
        WeblogicRdbmsBean rdbmsBean = WeblogicUtil.findRdbmsBean(rdbmsRootDescriptor, ejbName);
        if (rdbmsBean != null && (dataSourceName = (String)rdbmsBean.getRightDataSourceName().getValue()) != null && (dataSource = (DbDataSource)DbUtil.getDataSources((Project)project).filter(DasUtil.byName((String)dataSourceName)).first()) != null) {
            for (DasTable table : DasUtil.getTables((DasDataSource)dataSource)) {
                String name = table.getName();
                if (result.contains(name)) continue;
                result.add(name);
            }
        }
    }
}

