/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.ws.WSBundle;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.engines.wsengine.WSEngineManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebServicesPluginSettings", storages={@Storage(value="other.xml")})
public class WebServicesPluginSettings
extends FileTypeFactory
implements PersistentStateComponent<Element>,
FileTemplateGroupDescriptorFactory {
    @NonNls
    public static final String CXF_TEMPLATE_NAME = "cxf.webservice.java";
    @NonNls
    public static final String CXF_INTERFACE_TEMPLATE_NAME = "cxf.webservice.interface.java";
    @NonNls
    public static final String INTERFACE_Q_NAME = "INTERFACE_Q_NAME";
    @NonNls
    public static final String REST_CXF_TEMPLATE_NAME = "rest.cxf.webservice.java";
    @NonNls
    public static final String REST_CXF_INTERFACE_TEMPLATE_NAME = "rest.cxf.webservice.interface.java";
    private final LinkedList<String> lastPackagePrefixes = new LinkedList();
    private final LinkedList<String> lastWsdlUrls = new LinkedList();
    private final LinkedList<String> lastJaxbUrls = new LinkedList();
    private int myMemorySizeToLaunchVM = 128;
    private final LinkedList<String> lastXmlBeansUrls = new LinkedList();
    private boolean makeGeneratedFilesReadOnly = true;
    private String myJwsdpPath;
    private String myCXFPath;
    private String myAxis2Path;
    private String myJBossWSPath;
    private String myWebSphereWSPath;
    private String myXmlBeansPath;
    private String myLastPlatform;
    private String myLastBinding;
    @NonNls
    private String myWebServicesUrlPathPrefix = "/services";
    private String myAskToInstallSoapUI = Boolean.toString(true);
    private final WSEngineManager myEngineManager = new WSEngineManager();
    @NonNls
    private static final String GEN_CLIENT_STUB_URL_KEY = "StubUrl";
    @NonNls
    private static final String GEN_JAXB_STUB_URL_KEY = "JAXBUrl";
    @NonNls
    private static final String GEN_XMLBEANS_STUB_URL_KEY = "XmlBeansUrl";
    @NonNls
    private static final String WEB_SERVICES_URL_PATH_PREFIX_KEY = "WebServicesUrlPathPrefix";
    @NonNls
    private static final String GENERATED_FILES_READ_WRITE_KEY = "WritableGeneratedFiles";
    @NonNls
    private static final String JWSDP_PATH_KEY = "PathToJWSDP";
    @NonNls
    private static final String XFIRE_PATH_KEY = "PathToXFire";
    @NonNls
    private static final String XMLBEANS_PATH_KEY = "PathToXmlBeans";
    @NonNls
    private static final String AXIS2_PATH_KEY = "PathToAxis2";
    @NonNls
    private static final String JBOSSWS_PATH_KEY = "PathToJBossWS";
    @NonNls
    private static final String MEMORY_SIZE_TO_LAUNCH_VM_KEY = "MemorySizeToLaunchVM";
    @NonNls
    private static final String WEBSPHERE_WS_PATH_KEY = "PathToWebSphere";
    @NonNls
    private static final String SERVER_NAME_KEY = "ServerName";
    @NonNls
    private static final String LAST_PLATFORM_KEY = "SelectedPlatform";
    @NonNls
    private static final String LAST_BINDING_KEY = "SelectedBinding";
    @NonNls
    private static final String SERVER_PORT_KEY = "ServerPort";
    @NonNls
    private static final String GEN_CLIENT_STUB_PREFIX_KEY = "StubPackage";
    @NonNls
    private static final String ASK_TO_INSTALL_SOAPUI = "ASK_TO_INSTALL_SOAPUI";
    @NonNls
    public static final String HTTP_SCHEMAS_XMLSOAP_ORG_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    @NonNls
    public static final String HTTP_WWW_W3_ORG_2003_03_WSDL = "http://www.w3.org/2003/03/wsdl";
    @NonNls
    public static final String WSDD_FILE_EXTENSION = "wsdd";
    @NonNls
    public static final String XJB_FILE_EXTENSION = "xjb";
    @NonNls
    public static final String WSDL_FILE_EXTENSION = "wsdl";
    @NonNls
    public static final String XSD_FILE_EXTENSION = "xsd";
    @NonNls
    private static final String DEFAULT_HOST_NAME = "localhost";
    @NonNls
    private static final String DEFAULT_HOST_PORT = "8080";
    @NonNls
    public static final String XFIRE_SERVICES_XML = "services.xml";
    @NonNls
    public static final String SUN_JAXWS_XML = "sun-jaxws.xml";
    @NonNls
    public static final String JAXRPC_XML = "jax-rpc.xml";
    @NonNls
    public static final String JAXRPC_RI_RUNTIME_XML = "jaxrpc-ri-runtime.xml";
    static final int MAX_HISTORY_ITEMS = 25;
    private static WebServicesPluginSettings myInstance;
    @NonNls
    public static final String CXF_SERVLET_XML = "cxf-servlet.xml";
    @NonNls
    public static final String JAXWS_WEBSERVICE_TEMPLATE_NAME = "jaxws.webservice.java";
    @NonNls
    public static final String POJO_WEBSERVICE_TEMPLATE_NAME = "pojo.webservice.java";
    @NonNls
    public static final String J2EE1_4_WEBSERVICE_TEMPLATE_NAME = "j2ee1_4.webservice.java";
    @NonNls
    public static final String J2EE1_4_WEBSERVICE_INTERFACE_TEMPLATE_NAME = "j2ee1_4.webservice.interface.java";
    private String hostName = "localhost";
    private String hostPort = "8080";

    public WebServicesPluginSettings(UltimateVerifier verifier) {
        PluginVerifier.verifyUltimatePlugin(verifier);
    }

    public List<String> getLastPackagePrefixes() {
        return this.lastPackagePrefixes;
    }

    public List<String> getLastWsdlUrls() {
        return this.lastWsdlUrls;
    }

    public List<String> getLastJAXBUrls() {
        return this.lastJaxbUrls;
    }

    public List<String> getLastXmlBeansUrls() {
        return this.lastXmlBeansUrls;
    }

    public void addLastWsdlUrl(String url) {
        WebServicesPluginSettings.doAdd(this.lastWsdlUrls, url);
    }

    public void addLastJAXBUrl(String url) {
        WebServicesPluginSettings.doAdd(this.lastJaxbUrls, url);
    }

    public void addLastXmlBeansUrl(String url) {
        WebServicesPluginSettings.doAdd(this.lastXmlBeansUrls, url);
    }

    public boolean isAllowedToAskAboutSoapUI() {
        return Boolean.parseBoolean(this.myAskToInstallSoapUI);
    }

    public void setAllowedToAskInstallSoapUI(boolean allowed) {
        this.myAskToInstallSoapUI = Boolean.toString(allowed);
    }

    private static void doAdd(LinkedList<String> lastWsdlUrls, String url) {
        lastWsdlUrls.remove(url);
        if (lastWsdlUrls.size() == 0 || !lastWsdlUrls.get(0).equals(url)) {
            lastWsdlUrls.add(0, url);
        }
        while (lastWsdlUrls.size() > 25) {
            lastWsdlUrls.removeLast();
        }
    }

    public void addLastPackagePrefix(String packagePrefix) {
        if (this.lastPackagePrefixes.size() == 0 || !this.lastPackagePrefixes.get(0).equals(packagePrefix)) {
            this.lastPackagePrefixes.add(0, packagePrefix);
        }
    }

    private static void readUrls(Element element, String genJaxbStubUrlKey, LinkedList<String> lastJaxbUrls) {
        List children = element.getChildren(genJaxbStubUrlKey);
        for (Object aChildren : children) {
            Element o = (Element)aChildren;
            lastJaxbUrls.add(o.getText());
            if (lastJaxbUrls.size() != 25) continue;
            break;
        }
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        WebServicesPluginSettings.saveUrls(this.lastPackagePrefixes, GEN_CLIENT_STUB_PREFIX_KEY, element);
        WebServicesPluginSettings.saveUrls(this.lastWsdlUrls, GEN_CLIENT_STUB_URL_KEY, element);
        WebServicesPluginSettings.saveUrls(this.lastJaxbUrls, GEN_JAXB_STUB_URL_KEY, element);
        WebServicesPluginSettings.saveUrls(this.lastXmlBeansUrls, GEN_XMLBEANS_STUB_URL_KEY, element);
        if (!this.makeGeneratedFilesReadOnly) {
            element.setAttribute(GENERATED_FILES_READ_WRITE_KEY, Boolean.TRUE.toString());
        }
        if (!DEFAULT_HOST_NAME.equals(this.hostName)) {
            element.setAttribute(SERVER_NAME_KEY, this.hostName);
        }
        if (this.myLastPlatform != null) {
            element.setAttribute(LAST_PLATFORM_KEY, this.myLastPlatform);
        }
        if (this.myLastBinding != null) {
            element.setAttribute(LAST_BINDING_KEY, this.myLastBinding);
        }
        if (this.myWebServicesUrlPathPrefix != null && !this.myWebServicesUrlPathPrefix.equals("/services")) {
            element.setAttribute(WEB_SERVICES_URL_PATH_PREFIX_KEY, this.myWebServicesUrlPathPrefix);
        }
        if (!DEFAULT_HOST_PORT.equals(this.hostPort)) {
            element.setAttribute(SERVER_PORT_KEY, this.hostPort);
        }
        if (this.myJwsdpPath != null) {
            element.setAttribute(JWSDP_PATH_KEY, this.myJwsdpPath);
        }
        if (this.myCXFPath != null) {
            element.setAttribute(XFIRE_PATH_KEY, this.myCXFPath);
        }
        if (this.myAxis2Path != null) {
            element.setAttribute(AXIS2_PATH_KEY, this.myAxis2Path);
        }
        if (this.myJBossWSPath != null) {
            element.setAttribute(JBOSSWS_PATH_KEY, this.myJBossWSPath);
        }
        if (this.myMemorySizeToLaunchVM != 128) {
            element.setAttribute(MEMORY_SIZE_TO_LAUNCH_VM_KEY, String.valueOf(this.myMemorySizeToLaunchVM));
        }
        if (this.myWebSphereWSPath != null) {
            element.setAttribute(WEBSPHERE_WS_PATH_KEY, this.myWebSphereWSPath);
        }
        if (this.myXmlBeansPath != null) {
            element.setAttribute(XMLBEANS_PATH_KEY, this.myXmlBeansPath);
        }
        if (this.myAskToInstallSoapUI != null && !this.myAskToInstallSoapUI.equals("true")) {
            element.setAttribute(ASK_TO_INSTALL_SOAPUI, this.myAskToInstallSoapUI);
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            WebServicesPluginSettings.$$$reportNull$$$0(0);
        }
        WebServicesPluginSettings.readUrls(element, GEN_JAXB_STUB_URL_KEY, this.lastJaxbUrls);
        WebServicesPluginSettings.readUrls(element, GEN_XMLBEANS_STUB_URL_KEY, this.lastXmlBeansUrls);
        WebServicesPluginSettings.readUrls(element, GEN_CLIENT_STUB_URL_KEY, this.lastWsdlUrls);
        WebServicesPluginSettings.readUrls(element, GEN_CLIENT_STUB_PREFIX_KEY, this.lastPackagePrefixes);
        String value = element.getAttributeValue(GENERATED_FILES_READ_WRITE_KEY);
        if (Boolean.TRUE.toString().equals(value)) {
            this.makeGeneratedFilesReadOnly = false;
        }
        if ((value = element.getAttributeValue(SERVER_NAME_KEY)) != null) {
            this.hostName = value;
        }
        if ((value = element.getAttributeValue(LAST_PLATFORM_KEY)) != null) {
            WSEngine engine = this.getEngineManager().getWSEngineByName(value);
            String string = this.myLastPlatform = engine != null ? engine.getName() : null;
        }
        if ((value = element.getAttributeValue(LAST_BINDING_KEY)) != null) {
            this.myLastBinding = value;
        }
        if ((value = element.getAttributeValue(WEB_SERVICES_URL_PATH_PREFIX_KEY)) != null) {
            this.myWebServicesUrlPathPrefix = value;
        }
        if ((value = element.getAttributeValue(SERVER_PORT_KEY)) != null) {
            this.hostPort = value;
        }
        if ((value = element.getAttributeValue(JWSDP_PATH_KEY)) != null) {
            this.myJwsdpPath = value;
        }
        if ((value = element.getAttributeValue(XFIRE_PATH_KEY)) != null) {
            this.myCXFPath = value;
        }
        if ((value = element.getAttributeValue(AXIS2_PATH_KEY)) != null) {
            this.myAxis2Path = value;
        }
        if ((value = element.getAttributeValue(JBOSSWS_PATH_KEY)) != null) {
            this.myJBossWSPath = value;
        }
        if ((value = element.getAttributeValue(MEMORY_SIZE_TO_LAUNCH_VM_KEY)) != null) {
            int size;
            try {
                size = Math.max(Integer.parseInt(value), 128);
            }
            catch (NumberFormatException ex) {
                size = 128;
            }
            this.myMemorySizeToLaunchVM = size;
        }
        if ((value = element.getAttributeValue(WEBSPHERE_WS_PATH_KEY)) != null) {
            this.myWebSphereWSPath = value;
        }
        if ((value = element.getAttributeValue(XMLBEANS_PATH_KEY)) != null) {
            this.myXmlBeansPath = value;
        }
        if ((value = element.getAttributeValue(ASK_TO_INSTALL_SOAPUI)) != null && (value.equals(Boolean.toString(true)) || value.equals(Boolean.toString(false)))) {
            this.myAskToInstallSoapUI = value;
        }
    }

    private static void saveUrls(List<String> lastWsdlUrls, String genClientStubUrlKey, Element element) {
        for (String lastUrl : lastWsdlUrls) {
            Element child = new Element(genClientStubUrlKey);
            element.addContent(child);
            child.setText(lastUrl);
        }
    }

    public static WebServicesPluginSettings getInstance() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        WebServicesPluginSettings instance = (WebServicesPluginSettings)((Object)ServiceManager.getService(WebServicesPluginSettings.class));
        if (instance == null && myInstance != null && application.isUnitTestMode()) {
            instance = myInstance;
        }
        return instance;
    }

    public static void setInstance(WebServicesPluginSettings _instance) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        myInstance = _instance;
    }

    public boolean toMakeSelectedFilesReadOnly() {
        return this.makeGeneratedFilesReadOnly;
    }

    public void setToMakeSelectedFilesReadOnly(boolean value) {
        this.makeGeneratedFilesReadOnly = value;
    }

    public String getXmlBeansPath() {
        return this.myXmlBeansPath;
    }

    public String getAxis2Path() {
        return this.myAxis2Path;
    }

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor root = new FileTemplateGroupDescriptor(WSBundle.message("webservices.file.templates.group.name", new Object[0]), AllIcons.Javaee.WebService);
        Icon javaIcon = StdFileTypes.JAVA.getIcon();
        root.addTemplate(new FileTemplateDescriptor(JAXWS_WEBSERVICE_TEMPLATE_NAME, javaIcon));
        root.addTemplate(new FileTemplateDescriptor(POJO_WEBSERVICE_TEMPLATE_NAME, javaIcon));
        root.addTemplate(new FileTemplateDescriptor(J2EE1_4_WEBSERVICE_TEMPLATE_NAME, javaIcon));
        root.addTemplate(new FileTemplateDescriptor(J2EE1_4_WEBSERVICE_INTERFACE_TEMPLATE_NAME, javaIcon));
        root.addTemplate(new FileTemplateDescriptor(CXF_INTERFACE_TEMPLATE_NAME, javaIcon));
        root.addTemplate(new FileTemplateDescriptor(CXF_TEMPLATE_NAME, javaIcon));
        root.addTemplate(new FileTemplateDescriptor(REST_CXF_TEMPLATE_NAME, javaIcon));
        root.addTemplate(new FileTemplateDescriptor(REST_CXF_INTERFACE_TEMPLATE_NAME, javaIcon));
        return root;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            WebServicesPluginSettings.$$$reportNull$$$0(1);
        }
        FileType fileType = consumer.getStandardFileTypeByName("XML");
        assert (fileType != null);
        consumer.consume(fileType, "wsdd;;xjb");
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public String getJwsdpPath() {
        return this.myJwsdpPath;
    }

    public String getCXFPath() {
        return this.myCXFPath;
    }

    public String getLastPlatform() {
        return this.myLastPlatform;
    }

    public void setLastPlatform(String lastPlatform) {
        this.myLastPlatform = lastPlatform;
    }

    public String getLastBinding() {
        return this.myLastBinding;
    }

    public void setLastBinding(String lastBinding) {
        this.myLastBinding = lastBinding;
    }

    public WSEngineManager getEngineManager() {
        return this.myEngineManager;
    }

    public String getJBossWSPath() {
        return this.myJBossWSPath;
    }

    public String getWebSphereWSPath() {
        return this.myWebSphereWSPath;
    }

    public String getWebServicesUrlPathPrefix() {
        return this.myWebServicesUrlPathPrefix;
    }

    public int getMemorySizeToLaunchVM() {
        return this.myMemorySizeToLaunchVM;
    }

    void setJwsdpPath(String jwsdpPath) {
        this.myJwsdpPath = jwsdpPath;
    }

    void setCXFPath(String CXFPath) {
        this.myCXFPath = CXFPath;
    }

    void setAxis2Path(String axis2Path) {
        this.myAxis2Path = axis2Path;
    }

    void setJBossWSPath(String JBossWSPath) {
        this.myJBossWSPath = JBossWSPath;
    }

    void setWebSphereWSPath(String webSphereWSPath) {
        this.myWebSphereWSPath = webSphereWSPath;
    }

    void setXmlBeansPath(String xmlBeansPath) {
        this.myXmlBeansPath = xmlBeansPath;
    }

    void setWebServicesUrlPathPrefix(String webServicesUrlPathPrefix) {
        this.myWebServicesUrlPathPrefix = webServicesUrlPathPrefix;
    }

    void setMemorySizeToLaunchVM(int memorySizeToLaunchVM) {
        this.myMemorySizeToLaunchVM = memorySizeToLaunchVM;
    }

    void setHostName(String hostName) {
        this.hostName = hostName;
    }

    void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/WebServicesPluginSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

