/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.actions.BaseWebServiceIntentionAction;
import com.intellij.ws.actions.DeployWebServiceDialog;
import com.intellij.ws.actions.EnableWebServicesSupportUtils;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.XmlRecursiveElementVisitor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposeAsWebServiceIntention
extends BaseWebServiceIntentionAction {
    @NotNull
    public String getText() {
        String string = WSBundle.message("expose.class.as.web.service.dialog.title", new Object[0]);
        if (string == null) {
            ExposeAsWebServiceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void invoke(Project project, PsiElement element) {
        ExposeAsWebServiceIntention.runAction(project, (PsiClass)element.getParent(), null);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ExposeAsWebServiceIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ExposeAsWebServiceIntention.$$$reportNull$$$0(2);
        }
        return ExposeAsWebServiceIntention.isWebServiceClass(element) && !FileBasedWSIndex.hasEntriesFor((PsiClass)element.getParent());
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void runAction(Project project, PsiClass classFromDataContext, @Nullable DeployWebServiceDialog previousDialog) {
        DeployWebServiceDialog dialog = new DeployWebServiceDialog(project, classFromDataContext, previousDialog);
        if (dialog.showAndGet()) {
            LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("expose.class.as.web.service.lvcs.label", new Object[0]));
            WSEngine currentEngine = dialog.getCurrentEngine();
            Consumer onException = e -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Error");
            Runnable restartAction = () -> ExposeAsWebServiceIntention.runAction(project, null, dialog);
            Runnable onSuccessAfterServiceDeployment = () -> ExposeAsWebServiceIntention.continueDeployment(currentEngine, (Consumer<? super Exception>)onException, dialog, project);
            Runnable deploymentAction = () -> currentEngine.deployWebService(dialog, dialog.getSelectedModule(), onSuccessAfterServiceDeployment, (Consumer<? super Exception>)onException, restartAction);
            currentEngine.undeployWebService(dialog.getWsName(), dialog.getSelectedModule(), deploymentAction, (Consumer<? super Exception>)onException, restartAction);
        }
    }

    private static void continueDeployment(WSEngine currentEngine, Consumer<? super Exception> onException, DeployWebServiceDialog dialog, Project project) {
        String servletName;
        Module selectedModule = dialog.getSelectedModule();
        if (dialog.isToAddLibs()) {
            EnableWebServicesSupportUtils.setupWebServicesInfrastructureForModule(project, false, selectedModule, currentEngine, true, null);
        }
        if ((servletName = currentEngine.getDeploymentServletName()) != null) {
            final String[] servletClassResult = new String[1];
            try {
                String s = DeployUtils.loadWSWebXml(servletName);
                PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("s.xml", s);
                psiFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    @Override
                    public void visitXmlTag(XmlTag xmlTag) {
                        if (xmlTag.getName().equals("servlet-class") && servletClassResult[0] == null) {
                            servletClassResult[0] = LibUtils.getStringValue(xmlTag);
                        }
                        if (servletClassResult[0] == null) {
                            super.visitXmlTag(xmlTag);
                        }
                    }
                });
            }
            catch (IOException e) {
                onException.consume((Object)e);
            }
        }
        CommonWsUtils.doFileSystemRefresh();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/ExposeAsWebServiceIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/ExposeAsWebServiceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

