/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.axis;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ws.WebServicesPlugin;
import com.intellij.ws.actions.ShowDeployedWebSevicesDialog;
import com.intellij.ws.engines.axis.AxisUtil;
import com.intellij.ws.utils.BaseWSAction;
import com.intellij.ws.utils.LibUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MonitorSoapMessagesAction
extends BaseWSAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        Project project;
        ShowDeployedWebSevicesDialog dialog;
        if (e == null) {
            MonitorSoapMessagesAction.$$$reportNull$$$0(0);
        }
        if ((dialog = new ShowDeployedWebSevicesDialog(project = (Project)(dataContext = e.getDataContext()).getData(CommonDataKeys.PROJECT), "Monitor SOAP Messages", "MonitorSoapMessages.html", MonitorSoapMessagesAction.getPossiblePorts(project))).showAndGet()) {
            String contextName = dialog.getContextName();
            WebServicesPlugin instance = WebServicesPlugin.getInstance(project);
            instance.addLastContext(contextName);
            int port = dialog.getPort();
            if (!instance.hasSoapMessagesToolWindow(port)) {
                AxisUtil.ensureSoapMonitorDeployed(contextName, project);
            }
            instance.createOrShowSoapMessagesToolWindow(port);
        }
    }

    private static List<String> getPossiblePorts(Project myProject) {
        ArrayList<String> ports = new ArrayList<String>(1);
        ProjectRootManager.getInstance((Project)myProject).getFileIndex().iterateContent(fileOrDir -> {
            if (fileOrDir.getName().equals("web.xml")) {
                XmlTag[] tags;
                XmlTag servlet;
                XmlFile file = (XmlFile)PsiManager.getInstance((Project)myProject).findFile(fileOrDir);
                if (file == null) {
                    return true;
                }
                XmlDocument document = file.getDocument();
                if (document == null) {
                    return true;
                }
                XmlTag rootTag = document.getRootTag();
                if (rootTag != null && (servlet = LibUtils.findServletWithName(tags = rootTag.findSubTags("servlet"), "SOAPMonitorService", null)) != null) {
                    XmlTag[] subTags;
                    for (XmlTag st : subTags = servlet.findSubTags("init-param")) {
                        XmlTag value;
                        XmlTag firstSubTag = st.findFirstSubTag("param-name");
                        if (firstSubTag == null || !"SOAPMonitorPort".equals(LibUtils.getStringValue(firstSubTag)) || (value = st.findFirstSubTag("param-value")) == null) continue;
                        String stringValue = LibUtils.getStringValue(value);
                        try {
                            int i = Integer.parseInt(stringValue);
                            ports.add(stringValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            return true;
        });
        return ports;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/engines/axis/MonitorSoapMessagesAction", "actionPerformed"));
    }
}

