/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.cxf;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class CxfUtils {
    public static boolean isCxfHome(VirtualFile t) {
        VirtualFile child = t.findChild("lib");
        if (child != null && child.isDirectory()) {
            for (VirtualFile f2 : child.getChildren()) {
                if (!CxfUtils.isCxfJar(f2.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCxfJar(String name) {
        return name.startsWith("cxf-2.") && name.endsWith(".jar");
    }

    public static boolean isCxf21OrAboveJar(String name) {
        return name.length() > 10 && name.startsWith("cxf-2.") && name.endsWith(".jar") && name.charAt(6) > '0';
    }

    public static String getJavaToWsdlClassName(String[] classpath) {
        for (String jar : classpath) {
            int ind;
            if (!jar.endsWith(".jar") || (ind = jar.replace('\\', '/').lastIndexOf(47)) <= -1 || !CxfUtils.isCxf21OrAboveJar(jar.substring(ind + 1))) continue;
            return "org.apache.cxf.tools.java2ws.JavaToWS";
        }
        return "org.apache.cxf.tools.java2wsdl.JavaToWSDL";
    }

    public static boolean isCxf21Home(String basePath) {
        File[] children = new File(basePath, "lib").listFiles();
        if (children != null) {
            for (File f2 : children) {
                if (!CxfUtils.isCxf21OrAboveJar(f2.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

