/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRangedReference
implements PsiReference {
    private final PsiElement myElement;
    private final TextRange myRange;

    public BaseRangedReference(@NotNull PsiElement psiElement, int index, int endIndex) {
        if (psiElement == null) {
            BaseRangedReference.$$$reportNull$$$0(0);
        }
        this.myElement = psiElement;
        this.myRange = new TextRange(index, endIndex);
    }

    protected BaseRangedReference(@NotNull PsiElement element, TextRange range) {
        if (element == null) {
            BaseRangedReference.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myRange = range;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            BaseRangedReference.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            BaseRangedReference.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myRange.substring(this.myElement.getText());
        if (string == null) {
            BaseRangedReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String string) throws IncorrectOperationException {
        if (string == null) {
            BaseRangedReference.$$$reportNull$$$0(5);
        }
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.myRange, string);
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            BaseRangedReference.$$$reportNull$$$0(6);
        }
        throw new IncorrectOperationException("old element: " + this.myElement + "; new element: " + psiElement + "; reference: " + this);
    }

    public boolean isReferenceTo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            BaseRangedReference.$$$reportNull$$$0(7);
        }
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), psiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/references/BaseRangedReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/references/BaseRangedReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

