/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.MoveCellContentJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.GridPane;

public class MoveRowContentJob
extends BatchDocumentJob {
    private final IntegerPropertyMetadata rowIndexMeta = new IntegerPropertyMetadata(new PropertyName("rowIndex", GridPane.class), true, 0, InspectorPath.UNUSED);
    private final FXOMInstance gridPaneObject;
    private final int movingRowIndex;
    private final int rowIndexDelta;

    public MoveRowContentJob(FXOMObject gridPaneObject, int movingRowIndex, int rowIndexDelta, EditorController editorController) {
        super(editorController);
        assert (gridPaneObject instanceof FXOMInstance);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        assert (movingRowIndex >= 0);
        this.gridPaneObject = (FXOMInstance)gridPaneObject;
        this.movingRowIndex = movingRowIndex;
        this.rowIndexDelta = rowIndexDelta;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        DesignHierarchyMask m = new DesignHierarchyMask(this.gridPaneObject);
        assert (m.isAcceptingSubComponent());
        int count = m.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            assert (m.getSubComponentAtIndex(i) instanceof FXOMInstance);
            FXOMInstance child = (FXOMInstance)m.getSubComponentAtIndex(i);
            if ((Integer)this.rowIndexMeta.getValue(child) != this.movingRowIndex) continue;
            MoveCellContentJob subJob = new MoveCellContentJob(child, 0, this.rowIndexDelta, this.getEditorController());
            result.add(subJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }
}

