/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.ModifyToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ToggleGroup;

public class ModifySelectionToggleGroupJob
extends BatchDocumentJob {
    private final String toggleGroupId;

    public ModifySelectionToggleGroupJob(String toggleGroupId, EditorController editorController) {
        super(editorController);
        assert (editorController.getFxomDocument() != null);
        this.toggleGroupId = toggleGroupId;
    }

    @Override
    protected List<Job> makeSubJobs() {
        Selection selection;
        FXOMInstance toggleGroupInstance;
        FXOMDocument fxomDocument;
        FXOMObject toggleGroupObject;
        ArrayList<Job> result = new ArrayList<Job>();
        boolean executable = this.toggleGroupId == null ? true : ((toggleGroupObject = (fxomDocument = this.getEditorController().getFxomDocument()).searchWithFxId(this.toggleGroupId)) == null ? true : (toggleGroupObject instanceof FXOMInstance ? (toggleGroupInstance = (FXOMInstance)toggleGroupObject).getDeclaredClass() == ToggleGroup.class : false));
        if (executable && (selection = this.getEditorController().getSelection()).getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject fxomObject : osg.getItems()) {
                ModifyToggleGroupJob subJob = new ModifyToggleGroupJob(fxomObject, this.toggleGroupId, this.getEditorController());
                if (!((Job)subJob).isExecutable()) continue;
                result.add(subJob);
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("job.set.toggle.group");
    }
}

