/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.DragController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.DocumentDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.ExternalDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyAnimationScheduler;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyDNDController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItemBorderPane;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItemDialogPane;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItemGraphic;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.editor.util.ContextMenuController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TreeItem;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;

public abstract class AbstractHierarchyPanelController
extends AbstractFxmlPanelController {
    private final HierarchyDNDController dndController = new HierarchyDNDController(this);
    private final HierarchyAnimationScheduler animationScheduler = new HierarchyAnimationScheduler();
    private final ObjectProperty<DisplayOption> displayOptionProperty = new SimpleObjectProperty((Object)DisplayOption.INFO);
    protected TreeItem<HierarchyItem> rootTreeItem;
    private boolean parentRingEnabled = true;
    private Paint parentRingColor;
    private final Map<FXOMObject, Boolean> treeItemsExpandedMapProperty = new HashMap<FXOMObject, Boolean>();
    private boolean shouldEndOnExit;
    private Label promptLabel;
    private static final double AUTO_SCROLLING_ZONE_HEIGHT = 40.0;
    private Border bottomBorder;
    private Border rightBottomLeftBorder;
    private Border rightLeftBorder;
    private Border topRightBottomLeftBorder;
    private Border topRightLeftBorder;
    private Border firstCellBottomBorder;
    private Border firstCellRightBottomLeftBorder;
    private Border firstCellRightLeftBorder;
    private Border firstCellTopRightBottomLeftBorder;
    private Border firstCellTopRightLeftBorder;
    private final Border transparentBorder;
    private final Border firstCellTransparentBorder;
    private final BorderWidths cellBorderWidths = new BorderWidths(2.0);
    private final Insets cellInsets = new Insets(-2.0, 0.0, -2.0, 0.0);
    private final Insets firstCellInsets = new Insets(0.0, 0.0, -2.0, 0.0);
    private static final Color DEFAULT_PARENT_RING_COLOR = Color.rgb((int)238, (int)168, (int)47);
    protected final ListChangeListener<TreeItem<HierarchyItem>> treeItemSelectionListener = change -> this.treeItemSelectionDidChange();

    public AbstractHierarchyPanelController(URL fxmlURL, EditorController editorController) {
        super(fxmlURL, I18N.getBundle(), editorController);
        BorderStroke bs = new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.cellInsets);
        this.transparentBorder = new Border(new BorderStroke[]{bs});
        BorderStroke firstbs = new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.firstCellInsets);
        this.firstCellTransparentBorder = new Border(new BorderStroke[]{firstbs});
    }

    private Label getPromptLabel() {
        if (this.promptLabel == null) {
            this.promptLabel = new Label();
            this.promptLabel.getStyleClass().add((Object)"hierarchy-prompt-label");
            this.promptLabel.setMouseTransparent(true);
        }
        return this.promptLabel;
    }

    public final TreeItem<HierarchyItem> getRoot() {
        return this.rootTreeItem;
    }

    public ObservableValue<DisplayOption> displayOptionProperty() {
        return this.displayOptionProperty;
    }

    public final DisplayOption getDisplayOption() {
        return (DisplayOption)((Object)this.displayOptionProperty.getValue());
    }

    public final void setDisplayOption(DisplayOption displayOption) {
        this.displayOptionProperty.setValue((Object)displayOption);
    }

    public final HierarchyDNDController getDNDController() {
        return this.dndController;
    }

    public final boolean isTimelineRunning() {
        return this.animationScheduler.isTimelineRunning();
    }

    public boolean isParentRingEnabled() {
        return this.parentRingEnabled;
    }

    public void setParentRingEnabled(boolean enabled) {
        this.parentRingEnabled = enabled;
    }

    public Paint getParentRingColor() {
        return this.parentRingColor;
    }

    public void setParentRingColor(Paint value) {
        this.parentRingColor = value;
        this.updateParentRingColor();
    }

    public void setBorder(Cell<?> cell, BorderSide side) {
        Border border;
        assert (cell != null);
        boolean isFirstCell = cell.getStyleClass() != null && cell.getStyleClass().contains((Object)"hierarchy-first-cell");
        switch (side) {
            case BOTTOM: {
                border = isFirstCell ? this.firstCellBottomBorder : this.bottomBorder;
                break;
            }
            case RIGHT_BOTTOM_LEFT: {
                border = isFirstCell ? this.firstCellRightBottomLeftBorder : this.rightBottomLeftBorder;
                break;
            }
            case RIGHT_LEFT: {
                border = isFirstCell ? this.firstCellRightLeftBorder : this.rightLeftBorder;
                break;
            }
            case TOP_RIGHT_BOTTOM_LEFT: {
                border = isFirstCell ? this.firstCellTopRightBottomLeftBorder : this.topRightBottomLeftBorder;
                break;
            }
            case TOP_RIGHT_LEFT: {
                border = isFirstCell ? this.firstCellTopRightLeftBorder : this.topRightLeftBorder;
                break;
            }
            default: {
                border = null;
                assert (false);
                break;
            }
        }
        assert (border != null);
        cell.setBorder(border);
    }

    private void setTransparentBorder(Cell<?> cell) {
        assert (cell != null);
        boolean isFirstCell = cell.getStyleClass() != null && cell.getStyleClass().contains((Object)"hierarchy-first-cell");
        Border border = isFirstCell ? this.firstCellTransparentBorder : this.transparentBorder;
        cell.setBorder(border);
    }

    public abstract Control getPanelControl();

    public abstract ObservableList<TreeItem<HierarchyItem>> getSelectedItems();

    public ScrollBar getScrollBar(Orientation orientation) {
        Control panelControl = this.getPanelControl();
        Set scrollBars = panelControl.lookupAll(".scroll-bar");
        for (Node node : scrollBars) {
            ScrollBar scrollBar;
            if (!(node instanceof ScrollBar) || (scrollBar = (ScrollBar)node).getOrientation() != orientation) continue;
            return scrollBar;
        }
        return null;
    }

    protected abstract void startEditingDisplayInfo();

    protected abstract void updatePanel();

    protected abstract void clearSelection();

    protected abstract void select(TreeItem<HierarchyItem> var1);

    protected void select(List<TreeItem<HierarchyItem>> treeItems) {
        for (TreeItem<HierarchyItem> treeItem : treeItems) {
            this.select(treeItem);
        }
    }

    public abstract void scrollTo(TreeItem<HierarchyItem> var1);

    protected boolean isVisible(TreeItem<HierarchyItem> treeItem) {
        Cell<?> cell = this.getCell(treeItem);
        return cell == null ? false : cell.isVisible();
    }

    public abstract Cell<?> getCell(TreeItem<?> var1);

    public abstract double getContentTopY();

    public abstract double getContentBottomY();

    public abstract void updateParentRing();

    public abstract void updatePlaceHolder();

    public abstract void clearBorderColor();

    public void clearBorderColor(Cell<?> cell) {
        assert (cell != null);
        this.setTransparentBorder(cell);
    }

    public void addToPanelControlSkin(Node node) {
        Skin skin = this.getPanelControl().getSkin();
        assert (skin instanceof SkinBase);
        SkinBase skinbase = (SkinBase)skin;
        skinbase.getChildren().add((Object)node);
    }

    public void removeFromPanelControlSkin(Node node) {
        Skin skin = this.getPanelControl().getSkin();
        assert (skin instanceof SkinBase);
        SkinBase skinbase = (SkinBase)skin;
        skinbase.getChildren().remove((Object)node);
    }

    protected abstract void startListeningToTreeItemSelection();

    protected abstract void stopListeningToTreeItemSelection();

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
        this.treeItemsExpandedMapProperty.clear();
        this.updatePanel();
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
        if (this.getPanelControl() != null) {
            if (this.rootTreeItem != null) {
                this.updateTreeItemsExpandedMap(this.rootTreeItem);
            }
            this.updatePanel();
            this.editorSelectionDidChange();
        }
    }

    @Override
    protected void cssRevisionDidChange() {
        this.sceneGraphRevisionDidChange();
    }

    private void updateTreeItemsExpandedMap(TreeItem<HierarchyItem> treeItem) {
        assert (treeItem != null);
        HierarchyItem item = (HierarchyItem)treeItem.getValue();
        if (!item.isEmpty()) {
            FXOMObject fxomObject = item.getFxomObject();
            assert (fxomObject != null);
            this.treeItemsExpandedMapProperty.put(fxomObject, treeItem.isExpanded());
            for (TreeItem treeItemChild : treeItem.getChildren()) {
                this.updateTreeItemsExpandedMap((TreeItem<HierarchyItem>)treeItemChild);
            }
        }
    }

    @Override
    protected void jobManagerRevisionDidChange() {
        this.sceneGraphRevisionDidChange();
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.getPanelControl() != null);
        this.initializePanel();
        this.startListeningToTreeItemSelection();
        this.updatePanel();
    }

    @Override
    protected void editorSelectionDidChange() {
        Selection selection = this.getEditorController().getSelection();
        ArrayList<FXOMObject> selectedFxomObjects = new ArrayList<FXOMObject>();
        if (this.getPanelControl() != null) {
            List<TreeItem<HierarchyItem>> selectedTreeItems;
            if (selection.getGroup() instanceof ObjectSelectionGroup) {
                ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
                selectedFxomObjects.addAll(osg.getItems());
            } else if (selection.getGroup() instanceof GridSelectionGroup) {
                GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
                selectedFxomObjects.add(gsg.getParentObject());
            }
            this.stopListeningToTreeItemSelection();
            this.clearSelection();
            if (this.getRoot() != null && !selectedFxomObjects.isEmpty() && !(selectedTreeItems = this.lookupTreeItem(selectedFxomObjects)).isEmpty()) {
                this.select(selectedTreeItems);
                TreeItem<HierarchyItem> lastTreeItem = selectedTreeItems.get(selectedTreeItems.size() - 1);
                if (!this.isVisible(lastTreeItem)) {
                    this.scrollTo(lastTreeItem);
                }
            }
            this.startListeningToTreeItemSelection();
            this.updateParentRing();
        }
    }

    private void treeItemSelectionDidChange() {
        if (this.getEditorController().canGetFxmlText()) {
            HashSet<FXOMObject> selectedFxomObjects = new HashSet<FXOMObject>();
            for (TreeItem selectedItem : this.getSelectedItems()) {
                FXOMObject fxomObject;
                if (selectedItem == null || (fxomObject = ((HierarchyItem)selectedItem.getValue()).getFxomObject()) == null) continue;
                selectedFxomObjects.add(fxomObject);
            }
            this.stopListeningToEditorSelection();
            this.getEditorController().getSelection().select(selectedFxomObjects);
            this.startListeningToEditorSelection();
            this.updateParentRing();
        } else {
            this.editorSelectionDidChange();
        }
    }

    private TreeItem<HierarchyItem> makeTreeItem(FXOMObject fxomObject) {
        HierarchyItem item = new HierarchyItem(fxomObject);
        TreeItem treeItem = new TreeItem((Object)item);
        Boolean expanded = this.treeItemsExpandedMapProperty.get(fxomObject);
        if (expanded != null) {
            treeItem.setExpanded(expanded.booleanValue());
        }
        this.updateTreeItem((TreeItem<HierarchyItem>)treeItem);
        return treeItem;
    }

    private TreeItem<HierarchyItem> makeTreeItemBorderPane(DesignHierarchyMask owner, FXOMObject fxomObject, DesignHierarchyMask.Accessory accessory) {
        HierarchyItemBorderPane item = new HierarchyItemBorderPane(owner, fxomObject, accessory);
        TreeItem treeItem = new TreeItem((Object)item);
        Boolean expanded = this.treeItemsExpandedMapProperty.get(fxomObject);
        if (expanded != null) {
            treeItem.setExpanded(expanded.booleanValue());
        }
        if (item.getMask() != null) {
            this.updateTreeItem((TreeItem<HierarchyItem>)treeItem);
        }
        return treeItem;
    }

    private TreeItem<HierarchyItem> makeTreeItemDialogPane(DesignHierarchyMask owner, FXOMObject fxomObject, DesignHierarchyMask.Accessory accessory) {
        HierarchyItemDialogPane item = new HierarchyItemDialogPane(owner, fxomObject, accessory);
        TreeItem treeItem = new TreeItem((Object)item);
        Boolean expanded = this.treeItemsExpandedMapProperty.get(fxomObject);
        if (expanded != null) {
            treeItem.setExpanded(expanded.booleanValue());
        }
        if (item.getMask() != null) {
            this.updateTreeItem((TreeItem<HierarchyItem>)treeItem);
        }
        return treeItem;
    }

    protected TreeItem<HierarchyItem> makeTreeItemGraphic(DesignHierarchyMask owner, FXOMObject fxomObject) {
        HierarchyItemGraphic item = new HierarchyItemGraphic(owner, fxomObject);
        TreeItem treeItem = new TreeItem((Object)item);
        Boolean expanded = this.treeItemsExpandedMapProperty.get(fxomObject);
        if (expanded != null) {
            treeItem.setExpanded(expanded.booleanValue());
        }
        if (item.getMask() != null) {
            this.updateTreeItem((TreeItem<HierarchyItem>)treeItem);
        }
        return treeItem;
    }

    protected void updateTreeItems() {
        assert (this.getPanelControl() != null);
        Parent parent = this.getPanelControl().getParent();
        assert (parent instanceof Pane);
        Pane pane = (Pane)parent;
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Label label = this.getPromptLabel();
        if (fxomDocument == null || fxomDocument.getFxomRoot() == null) {
            this.rootTreeItem = null;
            if (fxomDocument == null) {
                label.setText(I18N.getString("contant.label.status.fxomdocument.null"));
            } else {
                label.setText(I18N.getString("content.label.status.invitation"));
            }
            if (!pane.getChildren().contains((Object)label)) {
                pane.getChildren().add((Object)label);
            }
        } else {
            this.rootTreeItem = this.makeTreeItem(fxomDocument.getFxomRoot());
            this.rootTreeItem.setExpanded(true);
            ((Pane)parent).getChildren().remove((Object)label);
        }
    }

    protected void updateParentRingColor() {
        BorderStroke bs = new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, this.parentRingColor, (Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.cellInsets);
        this.bottomBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, this.parentRingColor, (Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.firstCellInsets);
        this.firstCellBottomBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke((Paint)Color.TRANSPARENT, this.parentRingColor, this.parentRingColor, this.parentRingColor, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.cellInsets);
        this.rightBottomLeftBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke((Paint)Color.TRANSPARENT, this.parentRingColor, this.parentRingColor, this.parentRingColor, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.firstCellInsets);
        this.firstCellRightBottomLeftBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke((Paint)Color.TRANSPARENT, this.parentRingColor, (Paint)Color.TRANSPARENT, this.parentRingColor, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.cellInsets);
        this.rightLeftBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke((Paint)Color.TRANSPARENT, this.parentRingColor, (Paint)Color.TRANSPARENT, this.parentRingColor, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.firstCellInsets);
        this.firstCellRightLeftBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke(this.parentRingColor, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.cellInsets);
        this.topRightBottomLeftBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke(this.parentRingColor, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.firstCellInsets);
        this.firstCellTopRightBottomLeftBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke(this.parentRingColor, this.parentRingColor, (Paint)Color.TRANSPARENT, this.parentRingColor, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.cellInsets);
        this.topRightLeftBorder = new Border(new BorderStroke[]{bs});
        bs = new BorderStroke(this.parentRingColor, this.parentRingColor, (Paint)Color.TRANSPARENT, this.parentRingColor, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, this.cellBorderWidths, this.firstCellInsets);
        this.firstCellTopRightLeftBorder = new Border(new BorderStroke[]{bs});
        this.updateParentRing();
        this.updatePlaceHolder();
    }

    private void updateTreeItem(TreeItem<HierarchyItem> treeItem) {
        FXOMObject value;
        DesignHierarchyMask.Accessory[] value2;
        DesignHierarchyMask mask = ((HierarchyItem)treeItem.getValue()).getMask();
        assert (mask != null);
        if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.GRAPHIC) && (value2 = mask.getAccessory(DesignHierarchyMask.Accessory.GRAPHIC)) != null) {
            treeItem.getChildren().add(this.makeTreeItemGraphic(mask, (FXOMObject)value2));
        }
        if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.TOOLTIP) && (value2 = mask.getAccessory(DesignHierarchyMask.Accessory.TOOLTIP)) != null) {
            treeItem.getChildren().add(this.makeTreeItem((FXOMObject)value2));
        }
        if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTEXT_MENU) && (value2 = mask.getAccessory(DesignHierarchyMask.Accessory.CONTEXT_MENU)) != null) {
            treeItem.getChildren().add(this.makeTreeItem((FXOMObject)value2));
        }
        if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.XAXIS) && (value2 = mask.getAccessory(DesignHierarchyMask.Accessory.XAXIS)) != null) {
            treeItem.getChildren().add(this.makeTreeItem((FXOMObject)value2));
        }
        if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.YAXIS) && (value2 = mask.getAccessory(DesignHierarchyMask.Accessory.YAXIS)) != null) {
            treeItem.getChildren().add(this.makeTreeItem((FXOMObject)value2));
        }
        if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT) && (value2 = mask.getAccessory(DesignHierarchyMask.Accessory.CONTENT)) != null) {
            treeItem.getChildren().add(this.makeTreeItem((FXOMObject)value2));
        }
        for (DesignHierarchyMask.Accessory accessory : new DesignHierarchyMask.Accessory[]{DesignHierarchyMask.Accessory.TOP, DesignHierarchyMask.Accessory.LEFT, DesignHierarchyMask.Accessory.CENTER, DesignHierarchyMask.Accessory.RIGHT, DesignHierarchyMask.Accessory.BOTTOM}) {
            if (!mask.isAcceptingAccessory(accessory)) continue;
            value = mask.getAccessory(accessory);
            treeItem.getChildren().add(this.makeTreeItemBorderPane(mask, value, accessory));
        }
        for (DesignHierarchyMask.Accessory accessory : new DesignHierarchyMask.Accessory[]{DesignHierarchyMask.Accessory.HEADER, DesignHierarchyMask.Accessory.DP_GRAPHIC, DesignHierarchyMask.Accessory.DP_CONTENT, DesignHierarchyMask.Accessory.EXPANDABLE_CONTENT}) {
            if (!mask.isAcceptingAccessory(accessory)) continue;
            value = mask.getAccessory(accessory);
            treeItem.getChildren().add(this.makeTreeItemDialogPane(mask, value, accessory));
        }
        if (mask.isAcceptingSubComponent()) {
            int count = mask.getSubComponentCount();
            for (int i = 0; i < count; ++i) {
                FXOMObject value3 = mask.getSubComponentAtIndex(i);
                treeItem.getChildren().add(this.makeTreeItem(value3));
            }
        }
    }

    private List<TreeItem<HierarchyItem>> lookupTreeItem(List<FXOMObject> fxomObjects) {
        ArrayList<TreeItem<HierarchyItem>> result = new ArrayList<TreeItem<HierarchyItem>>();
        for (FXOMObject fxomObject : fxomObjects) {
            TreeItem<HierarchyItem> treeItem = this.lookupTreeItem(fxomObject);
            if (treeItem == null) continue;
            result.add(treeItem);
        }
        return result;
    }

    public TreeItem<HierarchyItem> lookupTreeItem(FXOMObject fxomObject) {
        return this.lookupTreeItem(fxomObject, this.getRoot());
    }

    private TreeItem<HierarchyItem> lookupTreeItem(FXOMObject fxomObject, TreeItem<HierarchyItem> fromTreeItem) {
        TreeItem<HierarchyItem> result;
        assert (fxomObject != null);
        if (fromTreeItem != null) {
            assert (fromTreeItem.getValue() != null);
            if (((HierarchyItem)fromTreeItem.getValue()).getFxomObject() == fxomObject) {
                result = fromTreeItem;
            } else {
                Iterator it = fromTreeItem.getChildren().iterator();
                result = null;
                while (result == null && it.hasNext()) {
                    TreeItem childItem = (TreeItem)it.next();
                    result = this.lookupTreeItem(fxomObject, (TreeItem<HierarchyItem>)childItem);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    private <T> List<TreeItem<T>> getAllTreeItems(TreeItem<T> parentTreeItem) {
        assert (parentTreeItem != null);
        ArrayList<TreeItem<T>> treeItems = new ArrayList<TreeItem<T>>();
        for (TreeItem child : parentTreeItem.getChildren()) {
            treeItems.add(child);
            treeItems.addAll(this.getAllTreeItems(child));
        }
        return treeItems;
    }

    public <T> TreeItem<T> getLastVisibleTreeItem(TreeItem<T> parentTreeItem) {
        assert (parentTreeItem != null);
        TreeItem result = parentTreeItem;
        int size = result.getChildren().size();
        while (size != 0) {
            if (result.isExpanded()) {
                result = (TreeItem)result.getChildren().get(size - 1);
                size = result.getChildren().size();
                continue;
            }
            size = 0;
        }
        return result;
    }

    public <T> TreeItem<T> getNextVisibleTreeItem(TreeItem<T> treeItem) {
        assert (treeItem != null);
        if (treeItem == this.getRoot()) {
            return null;
        }
        if (treeItem.isExpanded() && !treeItem.getChildren().isEmpty()) {
            return (TreeItem)treeItem.getChildren().get(0);
        }
        TreeItem result = treeItem.nextSibling();
        for (TreeItem parentTreeItem = treeItem.getParent(); result == null && parentTreeItem != this.getRoot(); parentTreeItem = parentTreeItem.getParent()) {
            result = parentTreeItem.nextSibling();
        }
        return result;
    }

    public <T> TreeItem<T> getPreviousVisibleTreeItem(TreeItem<T> treeItem) {
        assert (treeItem != null);
        if (treeItem == this.getRoot()) {
            return null;
        }
        TreeItem result = treeItem.previousSibling();
        for (TreeItem parentTreeItem = treeItem.getParent(); result == null && parentTreeItem != this.getRoot(); parentTreeItem = parentTreeItem.getParent()) {
            result = parentTreeItem.previousSibling();
        }
        return result;
    }

    protected void initializePanel() {
        assert (this.getPanelControl() != null);
        this.getPanelControl().setOnDragDone(event -> this.handleOnDragDone((DragEvent)event));
        this.getPanelControl().setOnDragDropped(event -> this.handleOnDragDropped((DragEvent)event));
        this.getPanelControl().setOnDragEntered(event -> this.handleOnDragEntered((DragEvent)event));
        this.getPanelControl().setOnDragExited(event -> this.handleOnDragExited((DragEvent)event));
        this.getPanelControl().setOnDragOver(event -> this.handleOnDragOver((DragEvent)event));
        this.getPanelControl().setOnKeyPressed(event -> this.handleOnKeyPressed((KeyEvent)event));
        this.getPanelControl().setOnDragDetected(event -> this.handleOnDragDetected((MouseEvent)event));
        this.getPanelControl().setOnMousePressed(event -> this.handleOnMousePressed((MouseEvent)event));
        ContextMenuController contextMenuController = this.getEditorController().getContextMenuController();
        this.getPanelControl().setContextMenu(contextMenuController.getContextMenu());
        this.setParentRingColor((Paint)DEFAULT_PARENT_RING_COLOR);
    }

    private void handleOnDragDetected(MouseEvent event) {
        ObservableList<TreeItem<HierarchyItem>> selectedTreeItems = this.getSelectedItems();
        if (!this.getEditorController().canGetFxmlText()) {
            return;
        }
        Selection selection = this.getEditorController().getSelection();
        if (!selection.isEmpty()) {
            if (selection.getGroup() instanceof ObjectSelectionGroup) {
                ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
                for (TreeItem selectedTreeItem : selectedTreeItems) {
                    HierarchyItem item = (HierarchyItem)selectedTreeItem.getValue();
                    if (!item.isEmpty()) continue;
                    return;
                }
                Cell<?> cell = this.lookupCell(event.getTarget());
                Object item = cell.getItem();
                assert (item instanceof HierarchyItem);
                HierarchyItem hierarchyItem = (HierarchyItem)item;
                FXOMObject hitObject = hierarchyItem.getFxomObject();
                assert (hitObject != null);
                Window ownerWindow = this.getPanelRoot().getScene().getWindow();
                DocumentDragSource dragSource = new DocumentDragSource(osg.getSortedItems(), hitObject, ownerWindow);
                if (dragSource.isAcceptable()) {
                    Dragboard db = this.getPanelControl().startDragAndDrop(TransferMode.COPY_OR_MOVE);
                    db.setContent((Map)dragSource.makeClipboardContent());
                    db.setDragView(dragSource.makeDragView());
                    assert (this.getEditorController().getDragController().getDragSource() == null);
                    this.getEditorController().getDragController().begin(dragSource);
                }
            } else assert (false) : "Add implementation for " + selection.getGroup().getClass();
        }
    }

    private void handleOnDragDone(DragEvent event) {
        DragController dragController = this.getEditorController().getDragController();
        assert (!this.shouldEndOnExit);
        dragController.end();
        event.getDragboard().clear();
    }

    private void handleOnDragDropped(DragEvent event) {
        if (this.getEditorController().getFxomDocument() == null) {
            return;
        }
        DragController dragController = this.getEditorController().getDragController();
        dragController.commit();
        event.setDropCompleted(true);
        this.getPanelControl().requestFocus();
    }

    private void handleOnDragEntered(DragEvent event) {
        this.clearBorderColor();
        this.setParentRingEnabled(false);
        DragController dragController = this.getEditorController().getDragController();
        if (dragController.getDragSource() == null) {
            FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
            Window ownerWindow = this.getPanelRoot().getScene().getWindow();
            ExternalDragSource dragSource = new ExternalDragSource(event.getDragboard(), fxomDocument, ownerWindow);
            assert (dragSource.isAcceptable());
            dragController.begin(dragSource);
            this.shouldEndOnExit = true;
        }
    }

    private void handleOnDragExited(DragEvent event) {
        this.clearBorderColor();
        this.setParentRingEnabled(true);
        this.animationScheduler.stopTimeline();
        double verticalScrollBarValue = 0.0;
        ScrollBar scrollBar = this.getScrollBar(Orientation.VERTICAL);
        if (scrollBar != null) {
            verticalScrollBarValue = scrollBar.getValue();
        }
        DragController dragController = this.getEditorController().getDragController();
        dragController.setDropTarget(null);
        if (this.shouldEndOnExit) {
            dragController.end();
            this.shouldEndOnExit = false;
        }
        if (scrollBar != null) {
            scrollBar.setValue(verticalScrollBarValue);
        }
    }

    private void handleOnDragOver(DragEvent event) {
        ScrollBar verticalScrollBar = this.getScrollBar(Orientation.VERTICAL);
        if (verticalScrollBar != null && verticalScrollBar.isVisible()) {
            double eventY = event.getY();
            double topY = this.getContentTopY();
            double bottomY = this.getContentBottomY();
            if (topY <= eventY && eventY < topY + 40.0) {
                if (!this.animationScheduler.isTimelineRunning()) {
                    this.animationScheduler.playDecrementAnimation(verticalScrollBar);
                }
            } else if (bottomY >= eventY && eventY > bottomY - 40.0) {
                if (!this.animationScheduler.isTimelineRunning()) {
                    this.animationScheduler.playIncrementAnimation(verticalScrollBar);
                }
            } else if (this.animationScheduler.isTimelineRunning()) {
                this.animationScheduler.stopTimeline();
            }
        }
    }

    private void handleOnKeyPressed(KeyEvent event) {
        switch (event.getCode()) {
            case ENTER: {
                this.startEditingDisplayInfo();
                break;
            }
            case LEFT: {
                ObservableList<TreeItem<HierarchyItem>> treeItems;
                if (!event.isAltDown() || (treeItems = this.getSelectedItems()).isEmpty()) break;
                for (TreeItem treeItem : treeItems) {
                    this.collapseAllTreeItems(treeItem);
                }
                break;
            }
            case RIGHT: {
                ObservableList<TreeItem<HierarchyItem>> treeItems;
                if (!event.isAltDown() || (treeItems = this.getSelectedItems()).isEmpty()) break;
                for (TreeItem treeItem : treeItems) {
                    this.expandAllTreeItems(treeItem);
                }
                break;
            }
        }
    }

    private void handleOnMousePressed(MouseEvent event) {
        if (event.getButton() == MouseButton.SECONDARY) {
            ContextMenuController contextMenuController = this.getEditorController().getContextMenuController();
            contextMenuController.updateContextMenuItems();
        }
    }

    private <T> void expandAllTreeItems(TreeItem<T> parentTreeItem) {
        assert (parentTreeItem != null);
        parentTreeItem.setExpanded(true);
        List<TreeItem<T>> treeItems = this.getAllTreeItems(parentTreeItem);
        assert (treeItems != null);
        for (TreeItem<T> treeItem : treeItems) {
            treeItem.setExpanded(true);
        }
    }

    private <T> void collapseAllTreeItems(TreeItem<T> parentTreeItem) {
        assert (parentTreeItem != null);
        parentTreeItem.setExpanded(false);
        List<TreeItem<T>> treeItems = this.getAllTreeItems(parentTreeItem);
        assert (treeItems != null);
        for (TreeItem<T> treeItem : treeItems) {
            treeItem.setExpanded(false);
        }
    }

    private Cell<?> lookupCell(EventTarget target) {
        assert (target instanceof Node);
        Node node = (Node)target;
        while (!(node instanceof Cell)) {
            node = node.getParent();
        }
        return (Cell)node;
    }

    public static enum DisplayOption {
        INFO{

            public String toString() {
                return I18N.getString("hierarchy.displayoption.info");
            }
        }
        ,
        FXID{

            public String toString() {
                return I18N.getString("hierarchy.displayoption.fxid");
            }
        }
        ,
        NODEID{

            public String toString() {
                return I18N.getString("hierarchy.displayoption.nodeid");
            }
        };

    }

    public static enum BorderSide {
        BOTTOM,
        RIGHT_BOTTOM_LEFT,
        RIGHT_LEFT,
        TOP_RIGHT_BOTTOM_LEFT,
        TOP_RIGHT_LEFT;

    }
}

