/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.Objects;
import javafx.util.Callback;

public abstract class CallbackPropertyMetadata
extends ValuePropertyMetadata {
    private final Object defaultValue;

    public CallbackPropertyMetadata(PropertyName name, boolean readWrite, Object defaultValue, InspectorPath inspectorPath) {
        super(name, readWrite, inspectorPath);
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getValue(FXOMInstance fxomInstance) {
        Object result;
        if (this.isReadWrite()) {
            FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
            if (fxomProperty instanceof FXOMPropertyC) {
                FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
                assert (fxomPropertyC.getValues().size() == 1);
                FXOMObject valueFxomObject = fxomPropertyC.getValues().get(0);
                Object sceneGraphObject = valueFxomObject.getSceneGraphObject();
                result = this.castValue(sceneGraphObject);
            } else {
                assert (fxomProperty == null);
                result = this.defaultValue;
            }
        } else {
            result = this.castValue(this.getName().getValue(fxomInstance.getSceneGraphObject()));
        }
        return result;
    }

    public void setValue(FXOMInstance fxomInstance, Object value) {
        assert (this.isReadWrite());
        FXOMProperty fxomProperty = fxomInstance.getProperties().get(this.getName());
        if (Objects.equals(value, this.getDefaultValueObject())) {
            if (fxomProperty != null) {
                fxomProperty.removeFromParentInstance();
            }
        } else if (fxomProperty == null) {
            FXOMProperty newProperty = this.makeFxomPropertyFromValue(fxomInstance, value);
            newProperty.addToParentInstance(-1, fxomInstance);
        } else {
            this.updateFxomPropertyWithValue(fxomProperty, value);
        }
    }

    protected abstract void updateFxomInstanceWithValue(FXOMInstance var1, Object var2);

    protected abstract Class<?> getFxConstantClass();

    protected abstract Object castValue(Object var1);

    @Override
    public Class<?> getValueClass() {
        return Callback.class;
    }

    @Override
    public Object getDefaultValueObject() {
        return this.defaultValue;
    }

    @Override
    public Object getValueObject(FXOMInstance fxomInstance) {
        return this.getValue(fxomInstance);
    }

    @Override
    public void setValueObject(FXOMInstance fxomInstance, Object valueObject) {
        this.setValue(fxomInstance, this.castValue(valueObject));
    }

    protected FXOMProperty makeFxomPropertyFromValue(FXOMInstance fxomInstance, Object value) {
        assert (fxomInstance != null);
        assert (value != null);
        FXOMDocument fxomDocument = fxomInstance.getFxomDocument();
        FXOMInstance valueInstance = new FXOMInstance(fxomDocument, this.getFxConstantClass());
        this.updateFxomInstanceWithValue(valueInstance, value);
        return new FXOMPropertyC(fxomDocument, this.getName(), valueInstance);
    }

    protected void updateFxomPropertyWithValue(FXOMProperty fxomProperty, Object value) {
        assert (value != null);
        assert (fxomProperty instanceof FXOMPropertyC);
        FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomProperty;
        assert (fxomPropertyC.getValues().size() == 1);
        FXOMObject valueObject = fxomPropertyC.getValues().get(0);
        if (valueObject instanceof FXOMInstance) {
            this.updateFxomInstanceWithValue((FXOMInstance)valueObject, value);
        } else {
            FXOMDocument fxomDocument = fxomProperty.getFxomDocument();
            FXOMInstance valueInstance = new FXOMInstance(fxomDocument, this.getFxConstantClass());
            this.updateFxomInstanceWithValue(valueInstance, value);
            valueInstance.addToParentProperty(0, fxomPropertyC);
            valueObject.removeFromParentProperty();
        }
    }
}

