/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.SingleValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;

public abstract class ComplexPropertyMetadata<T>
extends SingleValuePropertyMetadata<T> {
    public ComplexPropertyMetadata(PropertyName name, Class<T> valueClass, boolean readWrite, T defaultValue, InspectorPath inspectorPath) {
        super(name, valueClass, readWrite, defaultValue, inspectorPath);
    }

    @Override
    public T makeValueFromProperty(FXOMPropertyT fxomProperty) {
        T result;
        PrefixedValue pv = new PrefixedValue(fxomProperty.getValue());
        if (pv.isExpression()) {
            String fxId = pv.getSuffix();
            FXOMObject targetObject = fxomProperty.getFxomDocument().searchWithFxId(fxId);
            result = targetObject == null ? this.getDefaultValue() : this.getValueClass().cast(targetObject.getSceneGraphObject());
        } else {
            result = this.makeValueFromString(fxomProperty.getValue());
        }
        return result;
    }

    @Override
    public T makeValueFromString(String string) {
        throw new RuntimeException("Bug");
    }

    @Override
    public boolean canMakeStringFromValue(T value) {
        return value == null;
    }

    @Override
    public String makeStringFromValue(T value) {
        assert (value == null);
        return "$null";
    }

    @Override
    public T makeValueFromFxomInstance(FXOMInstance valueFxomInstance) {
        return this.getValueClass().cast(valueFxomInstance.getSceneGraphObject());
    }
}

