/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DesignHierarchyPath {
    private final List<FXOMObject> pathItems = new ArrayList<FXOMObject>();

    public DesignHierarchyPath() {
    }

    public DesignHierarchyPath(FXOMObject fxomObject) {
        assert (fxomObject != null);
        FXOMObject o = fxomObject;
        do {
            this.pathItems.add(0, o);
        } while ((o = o.getParentObject()) != null);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DesignHierarchyPath) {
            DesignHierarchyPath path = (DesignHierarchyPath)obj;
            return this.pathItems.equals(path.pathItems);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.pathItems);
        return hash;
    }

    public int getSize() {
        return this.pathItems.size();
    }

    public boolean isEmpty() {
        return this.pathItems.isEmpty();
    }

    public FXOMObject getRoot() {
        FXOMObject result = this.pathItems.isEmpty() ? null : this.pathItems.get(0);
        return result;
    }

    public FXOMObject getLeaf() {
        FXOMObject result = this.pathItems.isEmpty() ? null : this.pathItems.get(this.pathItems.size() - 1);
        return result;
    }

    public DesignHierarchyPath getCommonPathWith(DesignHierarchyPath another) {
        DesignHierarchyPath result = new DesignHierarchyPath();
        assert (another != null);
        int count = Math.min(this.getSize(), another.getSize());
        for (int i = 0; i < count && this.pathItems.get(i) == another.pathItems.get(i); ++i) {
            result.pathItems.add(this.pathItems.get(i));
        }
        return result;
    }
}

