/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInvalidFunctionInspection
extends CssBaseInspection {
    private static final CssInspectionsUtil.CssInvalidValueRangeProvider INVALID_VALUE_RANGE_PROVIDER = new CssFunctionInvalidValueRangeProvider();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidFunctionInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssFunction(@NotNull CssFunction function) {
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (function.getParent() instanceof CssPseudoSelector) {
                    return;
                }
                String name = function.getName();
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (name.isEmpty() || nameIdentifier == null) {
                    return;
                }
                Collection descriptors = function.getDescriptors();
                if (descriptors.isEmpty()) {
                    holder.registerProblem(nameIdentifier, CssBundle.message((String)"css.inspections.invalid.function.unknown.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                Collection filteredByContextDescriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, nameIdentifier, holder);
                CssInspectionsUtil.checkDescriptorValue(filteredByContextDescriptors, (CssValueOwner)function, holder, "css.inspections.function.mismatched.parameters", INVALID_VALUE_RANGE_PROVIDER, false, false, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection$1", "visitCssFunction"));
            }
        };
        if (cssElementVisitor == null) {
            CssInvalidFunctionInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CssFunctionInvalidValueRangeProvider
    extends CssInspectionsUtil.CssInvalidValueRangeProvider {
        private CssFunctionInvalidValueRangeProvider() {
        }

        @Override
        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                CssFunctionInvalidValueRangeProvider.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CssFunctionInvalidValueRangeProvider.$$$reportNull$$$0(1);
            }
            if (valueOwner instanceof CssFunction) {
                CssFunction function = (CssFunction)valueOwner;
                TextRange functionTextRange = function.getTextRange();
                int functionStartOffset = functionTextRange.getStartOffset();
                if (lastMatchedElement != null) {
                    TextRange range;
                    PsiElement rParenthesis;
                    int endOfValue;
                    int startOfInvalidElements = lastMatchedElement.getTextRange().getEndOffset();
                    if (startOfInvalidElements == (endOfValue = Math.max(function.getTrimmedValueTextRange().getEndOffset(), startOfInvalidElements)) && (rParenthesis = function.getRParenthesis()) != null) {
                        endOfValue = rParenthesis.getTextRange().getEndOffset();
                    }
                    if (!(range = TextRange.create((int)startOfInvalidElements, (int)endOfValue)).isEmpty()) {
                        return range.shiftRight(-functionStartOffset);
                    }
                }
            }
            return super.calculateInvalidRange(valueOwner, lastMatchedElement, defaultValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection$CssFunctionInvalidValueRangeProvider";
            objectArray[2] = "calculateInvalidRange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

