/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.impl.PsiNameHelperImpl;
import com.intellij.spring.boot.initializr.SpringInitializrFormBuilder;
import com.intellij.spring.boot.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.spring.boot.initializr.SpringInitializrOptionsLoader;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

class SpringInitializrApplicationInfoStep
extends ModuleWizardStep
implements Disposable {
    private static final String NAME = "Na&me";
    private static final String GROUP = "&Group";
    private static final String ARTIFACT = "&Artifact";
    private static final String VERSION = "&Version";
    private static final String PACKAGE = "Pac&kage";
    private final SpringInitializrModuleBuilder myBuilder;
    private final WizardContext myWizardContext;
    private final JBLoadingPanel myPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
    private JBTextField myGroupField;
    private JBTextField myArtifactField;
    private JBTextField myVersionField;
    private JBTextField myNameField;
    private JBTextField myDescriptionField;
    private JBTextField myPackageNameField;

    SpringInitializrApplicationInfoStep(SpringInitializrModuleBuilder builder, WizardContext wizardContext) {
        this.myBuilder = builder;
        this.myWizardContext = wizardContext;
    }

    public boolean validate() throws ConfigurationException {
        JavaSdkVersion wizardVersion;
        if (this.myBuilder.getOptions() == null) {
            return false;
        }
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myNameField, NAME);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myGroupField, GROUP);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myArtifactField, ARTIFACT);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myVersionField, VERSION);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myPackageNameField, PACKAGE);
        SpringInitializrApplicationInfoStep.validateSanitizedField(this.myArtifactField, ARTIFACT);
        String packageNameValue = this.myPackageNameField.getText();
        if (!PsiNameHelperImpl.getInstance().isQualifiedName(packageNameValue)) {
            throw new ConfigurationException(packageNameValue + " is not a valid package name");
        }
        Sdk sdk = this.myWizardContext.isCreatingNewProject() ? this.myWizardContext.getProjectJdk() : (Sdk)ObjectUtils.chooseNotNull((Object)this.myBuilder.getModuleJdk(), (Object)this.myWizardContext.getProjectJdk());
        JavaSdkVersion javaSdkVersion = wizardVersion = sdk == null ? null : JavaSdk.getInstance().getVersion(sdk);
        if (wizardVersion != null) {
            SpringInitializrOptions.Option appVersion = (SpringInitializrOptions.Option)((Object)this.myBuilder.getOptions().javaVersion.getSelected());
            assert (appVersion != null);
            JavaSdkVersion selectedVersion = JavaSdkVersion.fromVersionString((String)appVersion.id);
            if (selectedVersion != null && !wizardVersion.isAtLeast(selectedVersion)) {
                throw new ConfigurationException("Selected Java version " + selectedVersion.getDescription() + " is not supported by SDK (maximum " + wizardVersion.getDescription() + ")");
            }
        }
        return true;
    }

    private static void validateRequiredField(JBTextField field, String name) throws ConfigurationException {
        if (field.getText().isEmpty()) {
            throw new ConfigurationException(UIUtil.removeMnemonic((String)name) + " must be set");
        }
    }

    private static void validateSanitizedField(JBTextField field, String name) throws ConfigurationException {
        String text = field.getText();
        if (!text.equals(SpringInitializrApplicationInfoStep.sanitize(text))) {
            throw new ConfigurationException(UIUtil.removeMnemonic((String)name) + " contains illegal characters");
        }
    }

    private static String sanitize(String input) {
        String fileName = FileUtil.sanitizeFileName((String)input, (boolean)false);
        return StringUtil.toLowerCase((String)fileName.replace(' ', '-'));
    }

    public void _init() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        if (options == null) {
            this.loadSpringInitializrOptions();
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupField;
    }

    private void loadSpringInitializrOptions() {
        this.myPanel.getContentPanel().removeAll();
        this.myPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String serviceUrl = this.myBuilder.getServiceUrl();
            try {
                EmptyProgressIndicator delegatingProgressIndicator = new EmptyProgressIndicator(){

                    public void setText(String text) {
                        SwingUtilities.invokeLater(() -> SpringInitializrApplicationInfoStep.this.myPanel.setLoadingText(text));
                    }
                };
                SpringInitializrOptionsLoader loader = new SpringInitializrOptionsLoader(serviceUrl);
                SpringInitializrOptions options = loader.loadOptions((ProgressIndicator)delegatingProgressIndicator);
                this.myBuilder.setOptions(options);
                SwingUtilities.invokeLater(() -> this.createSpringBootPanel(options));
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)("Initialization failed for '" + serviceUrl + "'\nPlease check URL, network and proxy settings.\n\nError message:\n" + e.getMessage()), (String)"Spring Initializr Error"));
                this.myWizardContext.getWizard().updateButtons(false, false, false);
            }
            finally {
                SwingUtilities.invokeLater(() -> {
                    this.myPanel.stopLoading();
                    this.myPanel.revalidate();
                });
            }
        });
    }

    private void createSpringBootPanel(SpringInitializrOptions options) {
        if (options == null) {
            return;
        }
        SpringInitializrFormBuilder builder = new SpringInitializrFormBuilder();
        JLabel label = new JLabel("Project Metadata");
        label.setFont(UIUtil.getLabelFont().deriveFont(1));
        builder.addVerticalSpacing();
        builder.addComponent(label);
        builder.addVerticalSpacing();
        this.myGroupField = builder.addTextField(GROUP, options.group);
        DocumentAdapter updatePackageNameAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                String packageName = StringUtil.toLowerCase((String)SpringInitializrApplicationInfoStep.this.myGroupField.getText()) + "." + SpringInitializrApplicationInfoStep.sanitize(StringUtil.toLowerCase((String)SpringInitializrApplicationInfoStep.this.myArtifactField.getText()));
                SpringInitializrApplicationInfoStep.this.myPackageNameField.setText(StringUtil.replace((String)packageName, (String)"-", (String)""));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/initializr/SpringInitializrApplicationInfoStep$2", "textChanged"));
            }
        };
        this.myGroupField.getDocument().addDocumentListener((DocumentListener)updatePackageNameAdapter);
        this.myArtifactField = builder.addTextField(ARTIFACT, options.artifact);
        this.myArtifactField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                SpringInitializrApplicationInfoStep.this.myNameField.setText(SpringInitializrApplicationInfoStep.this.myArtifactField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/initializr/SpringInitializrApplicationInfoStep$3", "textChanged"));
            }
        });
        this.myArtifactField.getDocument().addDocumentListener((DocumentListener)updatePackageNameAdapter);
        builder.addVerticalSpacing();
        builder.addComboBox("&Type", options.type);
        builder.addComboBox("&Language", options.language);
        builder.addVerticalSpacing();
        builder.addComboBox("Packa&ging", options.packaging);
        builder.addComboBox("&Java Version", options.javaVersion);
        builder.addVerticalSpacing();
        this.myVersionField = builder.addTextField(VERSION, options.version);
        this.myNameField = builder.addTextField(NAME, options.name);
        this.myDescriptionField = builder.addTextField("&Description", options.description);
        this.myPackageNameField = builder.addTextField(PACKAGE, options.packageName);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)builder.getPanel(), (boolean)true), (Object)"North");
        this.myGroupField.selectAll();
        IdeFocusManager.findInstanceByComponent((Component)this.myPanel).requestFocus((Component)this.myGroupField, true);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    public void updateDataModel() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        options.name = this.myNameField.getText();
        options.group = this.myGroupField.getText();
        options.artifact = this.myArtifactField.getText();
        options.version = this.myVersionField.getText();
        options.description = this.myDescriptionField.getText();
        options.packageName = this.myPackageNameField.getText();
    }

    public String getHelpId() {
        return "reference.spring.boot";
    }
}

