/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.initializr.SpringInitializrDownloader;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.spring.boot.initializr.VersionRange;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringInitializrOptionsLoader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.initializr.SpringInitializrOptionsLoader");
    private static final String MIME_TYPE = "application/vnd.initializr.v2.1+json";
    private static final String DEFAULT_PROPERTY = "default";
    private static final String VALUES_PROPERTY = "values";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String VERSION_RANGE_PROPERTY = "versionRange";
    private static final String LINKS_PROPERTY = "_links";
    private static final String HREF_PROPERTY = "href";
    private static final String TITLE_PROPERTY = "title";
    private static final Consumer<Pair<JsonObject, SpringInitializrOptions.Option>> DEPENDENCIES_CALLBACK = pair -> {
        JsonObject jsonObject = (JsonObject)pair.first;
        if (jsonObject.has(VERSION_RANGE_PROPERTY)) {
            String versionRangeText = jsonObject.get(VERSION_RANGE_PROPERTY).getAsString();
            ((SpringInitializrOptions.Option)((Object)((Object)pair.second))).putUserData(SpringInitializrOptions.Option.VERSION_RANGE, VersionRange.parse(versionRangeText));
        }
        if (jsonObject.has(LINKS_PROPERTY)) {
            JsonObject linksObject = jsonObject.getAsJsonObject(LINKS_PROPERTY);
            LinkedHashMap allLinks = new LinkedHashMap();
            for (Map.Entry entry : linksObject.entrySet()) {
                SmartList links = new SmartList();
                JsonElement linkObject = (JsonElement)entry.getValue();
                if (linkObject.isJsonArray()) {
                    for (JsonElement linkEntry : linkObject.getAsJsonArray()) {
                        SpringInitializrOptionsLoader.parseLink((List<Couple<String>>)links, linkEntry);
                    }
                } else {
                    SpringInitializrOptionsLoader.parseLink((List<Couple<String>>)links, linkObject);
                }
                allLinks.put(entry.getKey(), links);
            }
            ((SpringInitializrOptions.Option)((Object)((Object)pair.second))).putUserData(SpringInitializrOptions.Option.LINKS, allLinks);
        }
    };
    private final String myServiceUrl;

    private static void parseLink(List<Couple<String>> links, JsonElement linkEntry) {
        if (!linkEntry.isJsonObject()) {
            return;
        }
        JsonObject entryObject = linkEntry.getAsJsonObject();
        JsonPrimitive titleProperty = entryObject.getAsJsonPrimitive(TITLE_PROPERTY);
        links.add((Couple<String>)Couple.of((Object)entryObject.getAsJsonPrimitive(HREF_PROPERTY).getAsString(), (Object)(titleProperty != null ? titleProperty.getAsString() : null)));
    }

    SpringInitializrOptionsLoader(String serviceUrl) {
        this.myServiceUrl = serviceUrl;
    }

    @Nullable
    SpringInitializrOptions loadOptions(final ProgressIndicator indicator) throws IOException {
        indicator.setText("Connecting to " + this.myServiceUrl + "...");
        return (SpringInitializrOptions)HttpRequests.request((String)this.myServiceUrl).accept(MIME_TYPE).userAgent(SpringInitializrDownloader.userAgent()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<SpringInitializrOptions>(){

            public SpringInitializrOptions process(@NotNull HttpRequests.Request request) throws IOException {
                BufferedReader reader;
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText("Retrieving Spring Initializr options...");
                try {
                    reader = request.getReader(indicator);
                }
                catch (IOException e) {
                    LOG.error("#SpringInitializrOptionsLoader IOException loading JSON response from " + SpringInitializrOptionsLoader.this.myServiceUrl, (Throwable)e);
                    throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)false), e);
                }
                try {
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonElement jsonRootElement = new JsonParser().parse(jsonReader);
                    JsonObject rootObject = jsonRootElement.getAsJsonObject();
                    return SpringInitializrOptionsLoader.parseJson(rootObject);
                }
                catch (Throwable e) {
                    LOG.error("Error processing JSON response from " + SpringInitializrOptionsLoader.this.myServiceUrl, e);
                    throw new IOException("Error parsing JSON response", e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/spring/boot/initializr/SpringInitializrOptionsLoader$1", "process"));
            }
        });
    }

    static SpringInitializrOptions parseJson(JsonObject rootObject) {
        SpringInitializrOptions options = new SpringInitializrOptions();
        options.name = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, NAME_PROPERTY);
        options.group = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "groupId");
        options.artifact = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "artifactId");
        options.version = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "version");
        options.description = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, DESCRIPTION_PROPERTY);
        options.packageName = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "packageName");
        options.type = SpringInitializrOptionsLoader.createComboModel(rootObject, "type");
        options.packaging = SpringInitializrOptionsLoader.createComboModel(rootObject, "packaging");
        options.javaVersion = SpringInitializrOptionsLoader.createComboModel(rootObject, "javaVersion");
        options.language = SpringInitializrOptionsLoader.createComboModel(rootObject, "language");
        options.bootVersion = SpringInitializrOptionsLoader.createComboModel(rootObject, "bootVersion");
        options.dependencies = SpringInitializrOptionsLoader.parseDependencies(rootObject);
        options.typeToAction = SpringInitializrOptionsLoader.fillTypeToAction(rootObject);
        return options;
    }

    private static Map<String, String> fillTypeToAction(JsonObject rootObject) {
        HashMap<String, String> typeToAction = new HashMap<String, String>();
        JsonObject typeObject = rootObject.get("type").getAsJsonObject();
        JsonArray values = typeObject.get(VALUES_PROPERTY).getAsJsonArray();
        for (JsonElement value : values) {
            String id = value.getAsJsonObject().get(ID_PROPERTY).getAsString();
            String action = value.getAsJsonObject().get("action").getAsString();
            typeToAction.put(id, action);
        }
        return typeToAction;
    }

    private static List<SpringInitializrOptions.MultiSelectGroup> parseDependencies(JsonObject rootObject) {
        JsonArray dependencies = rootObject.get("dependencies").getAsJsonObject().get(VALUES_PROPERTY).getAsJsonArray();
        ArrayList<SpringInitializrOptions.MultiSelectGroup> groups = new ArrayList<SpringInitializrOptions.MultiSelectGroup>();
        for (JsonElement dependency : dependencies) {
            JsonObject depObject = dependency.getAsJsonObject();
            String groupName = depObject.get(NAME_PROPERTY).getAsString();
            List<SpringInitializrOptions.Option> options = SpringInitializrOptionsLoader.createOptions(depObject, DEPENDENCIES_CALLBACK);
            SpringInitializrOptions.MultiSelectGroup group = new SpringInitializrOptions.MultiSelectGroup(groupName, options);
            groups.add(group);
        }
        return groups;
    }

    private static String getDefaultPropertyValue(JsonObject object, String propertyName) {
        JsonElement property = object.get(propertyName);
        if (property == null) {
            return "";
        }
        JsonElement defaultProperty = property.getAsJsonObject().get(DEFAULT_PROPERTY);
        return defaultProperty == null ? "" : defaultProperty.getAsString();
    }

    private static CollectionComboBoxModel<SpringInitializrOptions.Option> createComboModel(JsonObject rootObject, String propertyName) {
        JsonObject property = rootObject.get(propertyName).getAsJsonObject();
        List<SpringInitializrOptions.Option> options = SpringInitializrOptionsLoader.createOptions(property, (Consumer<Pair<JsonObject, SpringInitializrOptions.Option>>)Consumer.EMPTY_CONSUMER);
        JsonElement defaultPropertyElement = property.get(DEFAULT_PROPERTY);
        String defaultId = defaultPropertyElement != null ? defaultPropertyElement.getAsString() : "";
        return new CollectionComboBoxModel(options, ContainerUtil.find(options, option -> Comparing.strEqual((String)option.id, (String)defaultId)));
    }

    @NotNull
    private static List<SpringInitializrOptions.Option> createOptions(JsonObject depObject, Consumer<Pair<JsonObject, SpringInitializrOptions.Option>> callback) {
        ArrayList<SpringInitializrOptions.Option> options = new ArrayList<SpringInitializrOptions.Option>();
        JsonArray values = depObject.get(VALUES_PROPERTY).getAsJsonArray();
        for (JsonElement value : values) {
            JsonObject valueObject = value.getAsJsonObject();
            String id = valueObject.get(ID_PROPERTY).getAsString();
            if (StringUtil.isEmptyOrSpaces((String)id)) continue;
            String name = valueObject.get(NAME_PROPERTY).getAsString();
            String description = valueObject.has(DESCRIPTION_PROPERTY) ? valueObject.get(DESCRIPTION_PROPERTY).getAsString() : "";
            SpringInitializrOptions.Option option = new SpringInitializrOptions.Option(id, StringUtil.isNotEmpty((String)name) ? name : "<" + id + ">", description);
            callback.consume((Object)Pair.create((Object)valueObject, (Object)((Object)option)));
            options.add(option);
        }
        ArrayList<SpringInitializrOptions.Option> arrayList = options;
        if (arrayList == null) {
            SpringInitializrOptionsLoader.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/initializr/SpringInitializrOptionsLoader", "createOptions"));
    }
}

