/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;

public class GroovyNegatedIfInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Negated if condition expression" == null) {
            GroovyNegatedIfInspection.$$$reportNull$$$0(0);
        }
        return "Negated if condition expression";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Negated if condition expression #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyNegatedIfInspection.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedIfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement grIfStatement) {
            if (grIfStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(grIfStatement);
            GrExpression condition = grIfStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (!BoolUtils.isNegation(condition)) {
                return;
            }
            if (grIfStatement.getElseBranch() == null || grIfStatement.getThenBranch() == null) {
                return;
            }
            this.registerError(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grIfStatement", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedIfInspection$Visitor", "visitIfStatement"));
        }
    }
}

