/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class SpockUnrollReferenceProvider
extends PsiReferenceProvider {
    private static final Pattern PATTERN = Pattern.compile("\\#([\\w_]+)");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        GrAnnotationNameValuePair nvp;
        String name;
        if (element == null) {
            SpockUnrollReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpockUnrollReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((name = (nvp = (GrAnnotationNameValuePair)element.getParent()).getName()) != null && !name.equals("value")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpockUnrollReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement argumentList = nvp.getParent();
        if (!(argumentList instanceof GrAnnotationArgumentList)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpockUnrollReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eAnnotation = argumentList.getParent();
        if (!(eAnnotation instanceof GrAnnotation)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpockUnrollReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrAnnotation annotation = (GrAnnotation)eAnnotation;
        String shortName = annotation.getShortName();
        if (!shortName.equals("Unroll") && !shortName.equals("spock.lang.Unroll")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpockUnrollReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement modifierList = annotation.getParent();
        if (!(modifierList instanceof GrModifierList)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpockUnrollReferenceProvider.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eMethod = modifierList.getParent();
        if (!(eMethod instanceof GrMethod)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpockUnrollReferenceProvider.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrMethod method = (GrMethod)eMethod;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange rangeInElement = manipulator.getRangeInElement(element);
        String text = rangeInElement.substring(element.getText());
        ArrayList<SpockVariableReference> references = new ArrayList<SpockVariableReference>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            TextRange range = new TextRange(rangeInElement.getStartOffset() + matcher.start(1), rangeInElement.getStartOffset() + matcher.end(1));
            references.add(new SpockVariableReference(element, range, references, method));
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            SpockUnrollReferenceProvider.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/ext/spock/SpockUnrollReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/ext/spock/SpockUnrollReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SpockVariableReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement myLeafElement;
        private final List<? extends SpockVariableReference> myReferences;
        private final GrMethod myMethod;

        SpockVariableReference(PsiElement element, TextRange range, List<? extends SpockVariableReference> references, GrMethod method) {
            super(element, range);
            this.myReferences = references;
            this.myMethod = method;
            this.myLeafElement = element.getFirstChild();
        }

        public PsiElement resolve() {
            String value;
            Map<String, SpockVariableDescriptor> variableMap = SpockUtils.getVariableMap(this.myMethod);
            SpockVariableDescriptor descriptor2 = variableMap.get(value = this.getValue());
            if (descriptor2 == null) {
                return null;
            }
            return descriptor2.getVariable();
        }

        @NotNull
        public Object[] getVariants() {
            Map<String, SpockVariableDescriptor> variableMap = SpockUtils.getVariableMap(this.myMethod);
            Object[] res = new Object[variableMap.size()];
            int i = 0;
            for (SpockVariableDescriptor descriptor2 : variableMap.values()) {
                res[i++] = descriptor2.getVariable();
            }
            if (res == null) {
                SpockVariableReference.$$$reportNull$$$0(0);
            }
            return res;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                SpockVariableReference.$$$reportNull$$$0(1);
            }
            if (this.getElement().getFirstChild() != this.myLeafElement) {
                return this.getElement();
            }
            String oldValue = this.getValue();
            PsiElement res = null;
            int i = this.myReferences.size();
            while (--i >= 0) {
                SpockVariableReference reference = this.myReferences.get(i);
                if (!oldValue.equals(reference.getCanonicalText())) continue;
                res = reference.superHandleRename(newElementName);
            }
            return res;
        }

        public PsiElement superHandleRename(String newName) {
            return super.handleElementRename(newName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/ext/spock/SpockUnrollReferenceProvider$SpockVariableReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/ext/spock/SpockUnrollReferenceProvider$SpockVariableReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

