/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMethodReferenceExpressionImpl;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/findUsages/GrNewMethodsReferencesSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "TextProcessor", "intellij.groovy.psi"})
public final class GrNewMethodsReferencesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        PsiMethod psiMethod = queryParameters.getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"queryParameters.method");
        PsiMethod method = psiMethod;
        if (!method.isConstructor()) {
            return;
        }
        queryParameters.getOptimizer().searchWord("new", GroovyScopeUtil.restrictScopeToGroovyFiles(queryParameters.getEffectiveSearchScope()), (short)1, true, (PsiElement)method, (RequestResultProcessor)new TextProcessor(method));
    }

    public GrNewMethodsReferencesSearcher() {
        super(true);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/findUsages/GrNewMethodsReferencesSearcher$TextProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "target", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)V", "processTextOccurrence", "", "element", "Lcom/intellij/psi/PsiElement;", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.groovy.psi"})
    private static final class TextProcessor
    extends RequestResultProcessor {
        private final PsiMethod target;

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
            PsiElement psiElement = element;
            if (!(psiElement instanceof GrMethodReferenceExpressionImpl)) {
                psiElement = null;
            }
            GrMethodReferenceExpressionImpl grMethodReferenceExpressionImpl = (GrMethodReferenceExpressionImpl)psiElement;
            if (grMethodReferenceExpressionImpl == null) {
                return true;
            }
            GrMethodReferenceExpressionImpl methodReference = grMethodReferenceExpressionImpl;
            PsiElement psiElement2 = methodReference.getReferenceNameElement();
            if (psiElement2 == null) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"methodReference.referenc\u2026ameElement ?: return true");
            PsiElement nameElement = psiElement2;
            TextRange textRange = ((GrMethodReferenceExpressionImpl)element).getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
            int absoluteOffset = textRange.getStartOffset() + offsetInElement;
            if (!nameElement.getTextRange().contains(absoluteOffset)) {
                return true;
            }
            if (!methodReference.isReferenceTo((PsiElement)this.target)) {
                return true;
            }
            return consumer.process((Object)methodReference);
        }

        public TextProcessor(@NotNull PsiMethod target) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            super(new Object[0]);
            this.target = target;
        }
    }
}

