/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.formatter.Filter;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Range;
import gherkin.formatter.model.Tag;
import java.util.List;
import java.util.regex.Pattern;

public class PatternFilter
implements Filter {
    private final List<Pattern> patterns;

    public PatternFilter(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean evaluate(List<Tag> tags, List<String> names, List<Range> ranges) {
        for (String name : names) {
            if (name == null) continue;
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(name).find()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ExamplesTableRow> filterTableBodyRows(List<ExamplesTableRow> examplesRows) {
        return examplesRows;
    }
}

