/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.spring.boot.banner.SpringBootBannerReferenceContributor;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.LayeredIcon;
import icons.SpringBootApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootIconProvider
extends IconProvider {
    public static final LayeredIcon ADDITIONAL_JSON_ICON = new LayeredIcon(new Icon[]{SpringBootApiIcons.SpringBoot, AllIcons.Javaee.InheritedAttributeOverlay});
    public static final LayeredIcon BANNER_ICON = new LayeredIcon(new Icon[]{AllIcons.FileTypes.Text, SpringBootApiIcons.SpringBoot_Overlay});

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            SpringBootIconProvider.$$$reportNull$$$0(0);
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)element.getProject()) || !SpringBootLibraryUtil.hasSpringBootLibrary(element.getProject())) {
            return null;
        }
        if (element instanceof PropertyImpl) {
            PropertyImpl property = (PropertyImpl)element;
            if (SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(property.getContainingFile())) {
                ASTNode keyNode = property.getKeyNode();
                if (keyNode == null) {
                    return null;
                }
                SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey(keyNode.getPsi());
                if (configKey != null) {
                    return configKey.getPresentation().getIcon();
                }
            }
            return null;
        }
        if (element instanceof PropertiesFile) {
            return SpringBootConfigurationFileService.getInstance().getApplicationConfigurationFileIcon(((PropertiesFile)element).getContainingFile());
        }
        if (element instanceof JsonFile) {
            JsonFile jsonFile = (JsonFile)element;
            if (SpringBootAdditionalConfigUtils.isAdditionalMetadataFile((PsiFile)jsonFile)) {
                return ADDITIONAL_JSON_ICON;
            }
        } else if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass) && SpringBootApplicationService.getInstance().isSpringApplication(psiClass)) {
                return new LayeredIcon(new Icon[]{PsiClassImplUtil.getClassIcon((int)flags, (PsiClass)psiClass), SpringBootApiIcons.SpringBoot_Overlay});
            }
        } else if (element instanceof PsiPlainTextFile && SpringBootBannerReferenceContributor.PATTERN.accepts((Object)element)) {
            return BANNER_ICON;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/SpringBootIconProvider", "getIcon"));
    }
}

