/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.profiles.SpringProfile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootProfileConfigFileAutomaticRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            SpringBootProfileConfigFileAutomaticRenamerFactory.$$$reportNull$$$0(0);
        }
        return element instanceof SpringProfile && SpringBootLibraryUtil.hasSpringBootLibrary(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public String getOptionName() {
        return "Spring Boot configuration files";
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        String oldName = ((SpringProfile)element).getName();
        String configFileSuffix = "-" + oldName;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        PsiManager psiManager = element.getManager();
        SmartList allConfigFiles = new SmartList();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            List matchingConfigFiles = ContainerUtil.filter(contributor.getConfigurationFiles(module, true), file -> StringUtil.endsWith((CharSequence)file.getNameWithoutExtension(), (CharSequence)configFileSuffix));
            for (VirtualFile configFile : matchingConfigFiles) {
                ContainerUtil.addIfNotNull((Collection)allConfigFiles, (Object)psiManager.findFile(configFile));
            }
        }
        MyAutomaticRenamer myAutomaticRenamer = new MyAutomaticRenamer((List)allConfigFiles, oldName, newName);
        if (myAutomaticRenamer == null) {
            SpringBootProfileConfigFileAutomaticRenamerFactory.$$$reportNull$$$0(1);
        }
        return myAutomaticRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/SpringBootProfileConfigFileAutomaticRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/SpringBootProfileConfigFileAutomaticRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAutomaticRenamer
    extends AutomaticRenamer {
        private final String myOldName;

        private MyAutomaticRenamer(List<PsiFile> configFiles, String oldName, String newName) {
            for (PsiFile file : configFiles) {
                this.myElements.add(file);
                this.suggestAllNames(oldName, newName);
            }
            this.myOldName = oldName;
        }

        public String getDialogTitle() {
            return "Rename Spring Boot Configuration Files";
        }

        public String getDialogDescription() {
            return "Rename Spring Boot configuration files matching Spring Profile '" + this.myOldName + "'";
        }

        public String entityName() {
            return "File";
        }

        protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
            String name = element.getName();
            assert (name != null) : element;
            return StringUtil.replace((String)name, (String)("-" + oldClassName), (String)("-" + newClassName));
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        public boolean allowChangeSuggestedName() {
            return false;
        }
    }
}

