/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProviderBase;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EnumReferenceProvider
extends SpringBootHintReferenceProviderBase {
    private final PsiClass myEnumClass;

    EnumReferenceProvider(PsiClass enumClass) {
        this.myEnumClass = enumClass;
    }

    @Override
    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        HintReferenceBase hintReferenceBase = new HintReferenceBase(element, textRange){

            @Override
            public TextAttributesKey getTextAttributesKey() {
                return DefaultLanguageHighlighterColors.STATIC_FIELD;
            }

            @Override
            @Nullable
            protected PsiElement doResolve() {
                String enumText = this.getValue();
                return (PsiElement)ContainerUtil.find((Object[])this.getEnumFields(), field -> Comparing.strEqual((String)field.getName(), (String)enumText, (boolean)false));
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = ContainerUtil.map2Array((Object[])this.getEnumFields(), LookupElement.class, field -> {
                    String enumLowerCaseName = StringUtil.defaultIfEmpty((String)field.getName(), (String)"<invalid>").toLowerCase(Locale.US);
                    LookupElementBuilder builder = JavaLookupElementBuilder.forField((PsiField)field, (String)enumLowerCaseName, null);
                    String shortDoc = this.getEnumFieldShortJavadoc((PsiField)field);
                    if (shortDoc == null) {
                        return builder;
                    }
                    return builder.withTailText(" (" + shortDoc + ")", true);
                });
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = "Cannot resolve field ''{0}'' in enum ''" + EnumReferenceProvider.this.myEnumClass.getQualifiedName() + "''";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            private String getEnumFieldShortJavadoc(PsiField field) {
                PsiElement navigationElement = field.getNavigationElement();
                if (!(navigationElement instanceof PsiDocCommentOwner)) {
                    return null;
                }
                PsiDocComment comment = ((PsiDocCommentOwner)navigationElement).getDocComment();
                if (comment == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (PsiElement element : comment.getDescriptionElements()) {
                    sb.append(StringUtil.replaceUnicodeEscapeSequences((String)element.getText()));
                }
                String plainJavadoc = sb.toString();
                if (StringUtil.isEmptyOrSpaces((String)plainJavadoc)) {
                    return null;
                }
                String strippedDoc = StringUtil.stripHtml((String)StringUtil.trim((String)plainJavadoc), (boolean)false);
                SpringBootApplicationMetaConfigKey.DescriptionText text = new SpringBootApplicationMetaConfigKey.DescriptionText(strippedDoc);
                return text.getShortText();
            }

            @NotNull
            private PsiField[] getEnumFields() {
                PsiField[] psiFieldArray = (PsiField[])ContainerUtil.findAllAsArray((Object[])EnumReferenceProvider.this.myEnumClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
                if (psiFieldArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiFieldArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEnumFields";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (hintReferenceBase == null) {
            EnumReferenceProvider.$$$reportNull$$$0(0);
        }
        return hintReferenceBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider", "createReference"));
    }
}

