/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.application.config.hints.SpringBootHintReferenceProviderBase;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StaticValuesReferenceProvider
extends SpringBootHintReferenceProviderBase {
    private final boolean myAllowOtherValues;
    private final boolean myCaseInsensitive;
    private final TextAttributesKey myTextAttributesKey;
    private final String[] values;

    StaticValuesReferenceProvider(boolean allowOtherValues, boolean caseInsensitive, TextAttributesKey textAttributesKey, String ... values) {
        this.myAllowOtherValues = allowOtherValues;
        this.myCaseInsensitive = caseInsensitive;
        this.myTextAttributesKey = textAttributesKey;
        Arrays.sort(values);
        this.values = values;
    }

    @Override
    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        HintReferenceBase hintReferenceBase = new HintReferenceBase(element, textRange){

            @Override
            public TextAttributesKey getTextAttributesKey() {
                return StaticValuesReferenceProvider.this.myTextAttributesKey;
            }

            @Override
            @Nullable
            protected PsiElement doResolve() {
                if (StaticValuesReferenceProvider.this.myAllowOtherValues) {
                    return this.myElement;
                }
                String value = StaticValuesReferenceProvider.this.myCaseInsensitive ? this.getValue().toUpperCase(Locale.US) : this.getValue();
                return Arrays.binarySearch(StaticValuesReferenceProvider.this.values, value.trim()) > -1 ? this.myElement : null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = StaticValuesReferenceProvider.this.values;
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                if (StaticValuesReferenceProvider.this.values.length > 5) {
                    String string = super.getUnresolvedMessagePattern();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = "Invalid value ''{0}'', must be one of " + StringUtil.join((String[])StaticValuesReferenceProvider.this.values, (String)"|");
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (hintReferenceBase == null) {
            StaticValuesReferenceProvider.$$$reportNull$$$0(0);
        }
        return hintReferenceBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider", "createReference"));
    }
}

