/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public final class RelaxedNames
implements Iterable<String> {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([^A-Z-])([A-Z])");
    private final Set<String> values = new LinkedHashSet<String>();

    public RelaxedNames(String name) {
        RelaxedNames.initialize(StringUtil.notNullize((String)name), this.values);
    }

    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }

    private static void initialize(String name, Set<String> values) {
        if (values.contains(name)) {
            return;
        }
        for (Variation variation : Variation.values()) {
            for (Manipulation manipulation : Manipulation.values()) {
                String result2 = name;
                result2 = manipulation.apply(result2);
                result2 = variation.apply(result2);
                values.add(result2);
                RelaxedNames.initialize(result2, values);
            }
        }
    }

    static String dashedPropertyNameToCamelCase(String configKey) {
        String propertyKey = configKey.substring(configKey.lastIndexOf(46) + 1);
        if (!StringUtil.containsChar((String)propertyKey, (char)'-')) {
            return propertyKey;
        }
        return Manipulation.SEPARATED_TO_CAMELCASE.apply(propertyKey);
    }

    public static String separatedPropertyNameToCamelCase(String propertyName) {
        return Manipulation.SEPARATED_TO_CAMELCASE.apply(propertyName);
    }

    public static String camelCaseToHyphen(String propertyName) {
        return Manipulation.CAMELCASE_TO_HYPHEN.apply(propertyName);
    }

    static enum Manipulation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        HYPHEN_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                return value.replace('-', '_');
            }
        }
        ,
        UNDERSCORE_TO_PERIOD{

            @Override
            public String apply(String value) {
                return value.replace('_', '.');
            }
        }
        ,
        PERIOD_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                return value.replace('.', '_');
            }
        }
        ,
        CAMELCASE_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                Matcher matcher = CAMEL_CASE_PATTERN.matcher(value);
                if (!matcher.find()) {
                    return value;
                }
                matcher = matcher.reset();
                StringBuffer result2 = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(result2, matcher.group(1) + '_' + StringUtil.decapitalize((String)matcher.group(2)));
                }
                matcher.appendTail(result2);
                return result2.toString();
            }
        }
        ,
        CAMELCASE_TO_HYPHEN{

            @Override
            public String apply(String value) {
                Matcher matcher = CAMEL_CASE_PATTERN.matcher(value);
                if (!matcher.find()) {
                    return value;
                }
                matcher = matcher.reset();
                StringBuffer result2 = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(result2, matcher.group(1) + '-' + StringUtil.decapitalize((String)matcher.group(2)));
                }
                matcher.appendTail(result2);
                return result2.toString();
            }
        }
        ,
        SEPARATED_TO_CAMELCASE{

            @Override
            public String apply(String value) {
                return Manipulation.separatedToCamelCase(value, false);
            }
        }
        ,
        CASE_INSENSITIVE_SEPARATED_TO_CAMELCASE{

            @Override
            public String apply(String value) {
                return Manipulation.separatedToCamelCase(value, true);
            }
        };

        @NonNls
        private static final String SEPARATORS = "_-.";

        public abstract String apply(String var1);

        private static String separatedToCamelCase(String value, boolean caseInsensitive) {
            if (value.length() == 0) {
                return value;
            }
            StringBuilder builder = new StringBuilder();
            for (String field : StringUtil.tokenize((String)value, (String)SEPARATORS)) {
                field = caseInsensitive ? field.toLowerCase(Locale.US) : field;
                builder.append(builder.length() == 0 ? field : StringUtil.capitalize((String)field));
            }
            char lastChar = value.charAt(value.length() - 1);
            if (StringUtil.containsChar((String)SEPARATORS, (char)lastChar)) {
                builder.append(lastChar);
            }
            return builder.toString();
        }
    }

    static enum Variation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        LOWERCASE{

            @Override
            public String apply(String value) {
                return value.toLowerCase(Locale.US);
            }
        }
        ,
        UPPERCASE{

            @Override
            public String apply(String value) {
                return value.toUpperCase(Locale.US);
            }
        };


        public abstract String apply(String var1);
    }
}

