/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import icons.SpringBootApiIcons;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefineLocalMetaConfigKeyFix
implements LocalQuickFix,
HighPriorityAction,
Iconable {
    private final String myKeyName;

    public DefineLocalMetaConfigKeyFix(String keyName) {
        this.myKeyName = keyName;
    }

    public Icon getIcon(int flags) {
        return SpringBootApiIcons.SpringBoot;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = "Define configuration key '" + this.myKeyName + "'";
        if (string == null) {
            DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Define configuration key" == null) {
            DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(1);
        }
        return "Define configuration key";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        Module module;
        if (project == null) {
            DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(element = descriptor.getPsiElement()))) == null) {
            return;
        }
        String moduleName = module.getName();
        SpringBootAdditionalConfigUtils additionalConfigUtils = new SpringBootAdditionalConfigUtils(module);
        if (!additionalConfigUtils.hasResourceRoots()) {
            Messages.showWarningDialog((Project)project, (String)("No resources roots found in module '" + moduleName + "'"), (String)"Spring Boot");
            return;
        }
        Processor addKeyToExistingProcessor = jsonFile -> {
            if (project == null) {
                DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(8);
            }
            this.addKey(project, (JsonFile)jsonFile);
            return false;
        };
        if (!additionalConfigUtils.processAdditionalMetadataFiles((Processor<JsonFile>)addKeyToExistingProcessor)) {
            return;
        }
        int createNewFile = Messages.showYesNoDialog((Project)project, (String)("Could not locate META-INF/additional-spring-configuration-metadata.json in any of resources roots in module '" + module.getName() + "'.\n\nDo you want to create new file for storing additional meta-data?"), (String)"Spring Boot", null);
        if (createNewFile == 1) {
            return;
        }
        JBList list = new JBList(additionalConfigUtils.getResourceRoots());
        list.setCellRenderer((ListCellRenderer)new ListCellRendererWrapper<VirtualFile>(){

            public void customize(JList list, VirtualFile value, int index, boolean selected, boolean hasFocus) {
                this.setText(ProjectUtil.calcRelativeToProjectPath((VirtualFile)value, (Project)project));
                this.setIcon(AllIcons.Modules.ResourcesRoot);
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select Resources Root").setItemChoosenCallback(() -> {
            VirtualFile selectedRoot;
            if (project == null) {
                DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(6);
            }
            if ((selectedRoot = (VirtualFile)list.getSelectedValue()) == null) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                if (project == null) {
                    DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(7);
                }
                try {
                    VirtualFile metaInf = VfsUtil.createDirectoryIfMissing((VirtualFile)selectedRoot, (String)"META-INF");
                    VirtualFile addVf = metaInf.createChildData((Object)project, "additional-spring-configuration-metadata.json");
                    VfsUtil.saveText((VirtualFile)addVf, (String)"{ \"properties\": [ ] }");
                    JsonFile jsonFile = (JsonFile)PsiManager.getInstance((Project)project).findFile(addVf);
                    assert (jsonFile != null);
                    this.addKey(project, jsonFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }).createPopup().showCenteredInCurrentWindow(project);
    }

    private void addKey(@NotNull Project project, JsonFile additionalJson) {
        if (project == null) {
            DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(4);
        }
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{additionalJson.getVirtualFile()})) {
            return;
        }
        JsonElementGenerator generator = new JsonElementGenerator(project);
        JsonArray propertiesArray = DefineLocalMetaConfigKeyFix.findOrCreatePropertiesArray(generator, additionalJson);
        if (propertiesArray == null) {
            Messages.showWarningDialog((Project)project, (String)("Invalid JSON structure in " + additionalJson.getVirtualFile().getPath()), (String)"Spring Boot");
            return;
        }
        WriteAction.run(() -> {
            boolean hasValues;
            if (project == null) {
                DefineLocalMetaConfigKeyFix.$$$reportNull$$$0(5);
            }
            JsonObject value = (JsonObject)generator.createValue("{\n  \"name\": \"" + this.myKeyName + "\",\n  \"" + "type" + "\": \"java.lang.String\",\n  \"" + "description" + "\": \"Description for " + this.myKeyName + ".\"}");
            boolean bl = hasValues = !propertiesArray.getValueList().isEmpty();
            if (hasValues) {
                propertiesArray.addBefore(generator.createComma(), propertiesArray.getLastChild());
            }
            JsonObject added = (JsonObject)propertiesArray.addBefore((PsiElement)value, propertiesArray.getLastChild());
            CodeStyleManager.getInstance((Project)project).reformatText((PsiFile)additionalJson, 0, additionalJson.getTextLength());
            added.navigate(true);
        });
    }

    @Nullable
    private static JsonArray findOrCreatePropertiesArray(JsonElementGenerator generator, JsonFile additionalJson) {
        JsonObject rootObject = (JsonObject)ObjectUtils.tryCast((Object)additionalJson.getTopLevelValue(), JsonObject.class);
        if (rootObject == null) {
            return null;
        }
        JsonProperty propertiesRoot = rootObject.findProperty("properties");
        if (propertiesRoot == null) {
            return (JsonArray)WriteAction.compute(() -> {
                JsonProperty propertiesProperty = generator.createProperty("properties", "[]");
                if (!rootObject.getPropertyList().isEmpty()) {
                    rootObject.addBefore(generator.createComma(), rootObject.getLastChild());
                }
                JsonProperty propertiesAdded = (JsonProperty)rootObject.addBefore((PsiElement)propertiesProperty, rootObject.getLastChild());
                return (JsonArray)propertiesAdded.getValue();
            });
        }
        return (JsonArray)ObjectUtils.tryCast((Object)propertiesRoot.getValue(), JsonArray.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addKey$3";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

