/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.banner.AnsiColor;
import com.intellij.spring.boot.banner.AnsiStyle;
import com.intellij.spring.boot.banner.BuiltinProperty;
import com.intellij.spring.boot.banner.SpringBootBannerPropertyReference;
import com.intellij.spring.boot.banner.SpringBootBannerReferenceContributor;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.ColorIconCache;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootBannerCompletionContributor
extends CompletionContributor {
    static final String ANSI_STYLE_PREFIX = "AnsiStyle.";
    static final String ANSI_COLOR_PREFIX = "AnsiColor.";
    static final String ANSI_BACKGROUND_PREFIX = "AnsiBackground.";
    private static final String PROPERTY_REFERENCE_PLACEHOLDER = "${}";
    private static final InsertHandler<LookupElement> PROPERTY_REFERENCE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            Editor editor = context.getEditor();
            editor.getCaretModel().moveCaretRelatively(-"}".length(), 0, false, false, false);
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/banner/SpringBootBannerCompletionContributor$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            SpringBootBannerCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            SpringBootBannerCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!SpringBootBannerReferenceContributor.PATTERN.accepts((Object)parameters.getOriginalFile())) {
            return;
        }
        PsiReference reference = parameters.getOriginalFile().findReferenceAt(parameters.getOffset());
        if (reference instanceof SpringBootBannerPropertyReference) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)parameters.getOriginalFile());
            SpringBootBannerCompletionContributor.addReferenceCompletionVariants(module, result2);
        } else {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)PROPERTY_REFERENCE_PLACEHOLDER).bold().withTailText(" Insert new property reference", true).withInsertHandler(PROPERTY_REFERENCE_INSERT_HANDLER));
        }
        result2.stopHere();
    }

    private static void addReferenceCompletionVariants(@Nullable Module module, @NotNull CompletionResultSet result2) {
        if (result2 == null) {
            SpringBootBannerCompletionContributor.$$$reportNull$$$0(2);
        }
        if (module == null) {
            return;
        }
        for (BuiltinProperty builtinProperty : BuiltinProperty.values()) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)builtinProperty.getPropertyName()).bold().withIcon(AllIcons.Nodes.Property).withTailText(" " + builtinProperty.getTailText(module), true));
        }
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            return;
        }
        for (Enum enum_ : AnsiStyle.values()) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)(ANSI_STYLE_PREFIX + enum_.name())));
        }
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        int colorPreviewSize = UIUtil.getListFont().getSize();
        Icon backGroundColorOverlayIcon = IconUtil.toSize((Icon)AllIcons.Graph.Grid, (int)colorPreviewSize, (int)colorPreviewSize);
        for (AnsiColor ansiColor : AnsiColor.values()) {
            Color color = colorsScheme.getAttributes(ansiColor.getTextAttributesKey()).getForegroundColor();
            Icon colorIcon = ColorIconCache.getIconCache().getIcon(color, colorPreviewSize);
            result2.addElement((LookupElement)LookupElementBuilder.create((String)(ANSI_COLOR_PREFIX + ansiColor.name())).withIcon(colorIcon));
            result2.addElement((LookupElement)LookupElementBuilder.create((String)(ANSI_BACKGROUND_PREFIX + ansiColor.name())).withIcon((Icon)new LayeredIcon(new Icon[]{colorIcon, backGroundColorOverlayIcon})));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/banner/SpringBootBannerCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addReferenceCompletionVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

