/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.jam.SpringBootApplication;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScanArchetype;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScans;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContext;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/model/SpringBootApplicationSetupInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkComponentScan", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "packageName", "", "componentScan", "Lcom/intellij/spring/model/jam/stereotype/SpringJamComponentScan;", "isRedundantDeclaration", "intellij.spring.boot.core"})
public final class SpringBootApplicationSetupInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        UAnnotation enableAutoConfigurationAnno;
        Intrinsics.checkParameterIsNotNull((Object)uClass, (String)"uClass");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass));
        if (module == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026(psiClass) ?: return null");
        Module module2 = module;
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module2)) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return null;
        }
        if ((SpringBootApplication)SpringBootApplication.META.getJamElement((PsiModifierListOwner)psiClass) == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        String string = psiClass.getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiClass.qualifiedName!!");
        String qualifiedName = string;
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)psiClass.getName())) {
            holder.registerProblem(nameIdentifier, "Spring Boot Application in default package", new LocalQuickFix[0]);
            return holder.getResultsArray();
        }
        String string2 = StringUtil.getPackageName((String)qualifiedName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.getPackageName(qualifiedName)");
        String packageName = string2;
        SpringJamComponentScan componentScan = (SpringJamComponentScan)SpringJamComponentScan.META.getJamElement((PsiModifierListOwner)psiClass);
        this.checkComponentScan(holder, packageName, componentScan);
        SpringJamComponentScans componentScans = (SpringJamComponentScans)SpringJamComponentScans.META.getJamElement((PsiModifierListOwner)psiClass);
        if (componentScans != null) {
            for (SpringJamComponentScan jamComponentScan : componentScans.getComponentScans()) {
                this.checkComponentScan(holder, packageName, jamComponentScan);
            }
        }
        if ((enableAutoConfigurationAnno = uClass.findAnnotation("org.springframework.boot.autoconfigure.EnableAutoConfiguration")) != null) {
            Object object = enableAutoConfigurationAnno.getAttributeValues();
            if (!object.isEmpty()) {
                PsiElement psiElement2 = UAnnotationKt.getNamePsiElement((UAnnotation)enableAutoConfigurationAnno);
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                holder.registerProblem(psiElement2, "Attributes should be specified via" + " @" + StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.SpringBootApplication"), new LocalQuickFix[0]);
            } else {
                LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
                ProblemsHolder problemsHolder = holder;
                PsiElement psiElement3 = UAnnotationKt.getNamePsiElement((UAnnotation)enableAutoConfigurationAnno);
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = "Redundant declaration: " + '@' + StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.SpringBootApplication") + " already applies " + '@' + StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration");
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                LocalQuickFix[] localQuickFixArray2 = localQuickFixArray;
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray;
                int n = 0;
                PsiElement psiElement4 = enableAutoConfigurationAnno.getSourcePsi();
                if (psiElement4 != null) {
                    object = psiElement4;
                    int n2 = n;
                    LocalQuickFix[] localQuickFixArray4 = localQuickFixArray2;
                    LocalQuickFix[] localQuickFixArray5 = localQuickFixArray3;
                    String string4 = string3;
                    PsiElement psiElement5 = psiElement3;
                    ProblemsHolder problemsHolder2 = problemsHolder;
                    Object it = object;
                    LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement2 = QuickFixFactory.getInstance().createDeleteFix((PsiElement)it);
                    problemsHolder = problemsHolder2;
                    psiElement3 = psiElement5;
                    string3 = string4;
                    localQuickFixArray3 = localQuickFixArray5;
                    localQuickFixArray2 = localQuickFixArray4;
                    n = n2;
                    localQuickFixAndIntentionActionOnPsiElement = localQuickFixAndIntentionActionOnPsiElement2;
                } else {
                    localQuickFixAndIntentionActionOnPsiElement = null;
                }
                localQuickFixArray2[n] = (LocalQuickFix)localQuickFixAndIntentionActionOnPsiElement;
                problemsHolder.registerProblem(psiElement3, string3, localQuickFixArray3);
            }
        }
        return holder.getResultsArray();
    }

    private final void checkComponentScan(ProblemsHolder holder, String packageName, SpringJamComponentScan componentScan) {
        block8: {
            LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
            PsiAnnotation psiAnnotation;
            block10: {
                block9: {
                    UAnnotation uAnnotation;
                    PsiElement $receiver$iv;
                    if (componentScan == null || !this.isRedundantDeclaration(componentScan, packageName)) break block8;
                    psiAnnotation = componentScan.getAnnotation();
                    if (psiAnnotation == null) break block9;
                    PsiElement psiElement = $receiver$iv = (PsiElement)psiAnnotation;
                    if (psiElement != null) {
                        PsiElement psiElement2;
                        PsiElement it$iv = psiElement2 = psiElement;
                        uAnnotation = (UAnnotation)((UastContext)ServiceManager.getService((Project)$receiver$iv.getProject(), UastContext.class)).convertElementWithParent($receiver$iv, UAnnotation.class);
                    } else {
                        uAnnotation = psiAnnotation = null;
                    }
                    if (uAnnotation != null) break block10;
                }
                return;
            }
            PsiAnnotation annotationElement = psiAnnotation;
            ProblemsHolder problemsHolder = holder;
            PsiElement psiElement = UAnnotationKt.getNamePsiElement((UAnnotation)annotationElement);
            if (psiElement == null) {
                return;
            }
            String string = "Redundant declaration: " + '@' + StringUtil.getShortName((String)"org.springframework.boot.autoconfigure.SpringBootApplication") + " already applies given " + '@' + StringUtil.getShortName((String)"org.springframework.context.annotation.ComponentScan");
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            LocalQuickFix[] localQuickFixArray2 = localQuickFixArray;
            LocalQuickFix[] localQuickFixArray3 = localQuickFixArray;
            int n = 0;
            PsiElement psiElement3 = annotationElement.getSourcePsi();
            if (psiElement3 != null) {
                PsiElement psiElement4 = psiElement3;
                int n2 = n;
                LocalQuickFix[] localQuickFixArray4 = localQuickFixArray2;
                LocalQuickFix[] localQuickFixArray5 = localQuickFixArray3;
                String string2 = string;
                PsiElement psiElement5 = psiElement;
                ProblemsHolder problemsHolder2 = problemsHolder;
                PsiElement it = psiElement4;
                LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement2 = QuickFixFactory.getInstance().createDeleteFix(it);
                problemsHolder = problemsHolder2;
                psiElement = psiElement5;
                string = string2;
                localQuickFixArray3 = localQuickFixArray5;
                localQuickFixArray2 = localQuickFixArray4;
                n = n2;
                localQuickFixAndIntentionActionOnPsiElement = localQuickFixAndIntentionActionOnPsiElement2;
            } else {
                localQuickFixAndIntentionActionOnPsiElement = null;
            }
            localQuickFixArray2[n] = (LocalQuickFix)localQuickFixAndIntentionActionOnPsiElement;
            problemsHolder.registerProblem(psiElement, string, localQuickFixArray3);
        }
    }

    private final boolean isRedundantDeclaration(SpringJamComponentScan componentScan, String packageName) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        Iterator iterator = componentScan.getPsiPackages().iterator();
                        while (iterator.hasNext()) {
                            PsiPackage psiPackage;
                            PsiPackage psiPackage2 = psiPackage = (PsiPackage)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiPackage2, (String)"psiPackage");
                            if (!(Intrinsics.areEqual((Object)psiPackage2.getQualifiedName(), (Object)packageName) ^ true)) continue;
                            return false;
                        }
                        if (!componentScan.useDefaultFilters() || componentScan.isLazyInit() || componentScan.getResourcePattern() != null && Intrinsics.areEqual((Object)componentScan.getResourcePattern(), (Object)"**/*.class") ^ true || componentScan.getScopedProxy() != null && componentScan.getScopedProxy() != SpringJamComponentScanArchetype.ScopedProxyMode.DEFAULT) break block6;
                        if (componentScan.getNameGenerator() == null) break block7;
                        PsiClass psiClass = componentScan.getNameGenerator();
                        if (psiClass == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"componentScan.nameGenerator!!");
                        if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"org.springframework.beans.factory.support.BeanNameGenerator") ^ true) break block6;
                    }
                    if (componentScan.getScopeResolver() == null) break block8;
                    PsiClass psiClass = componentScan.getScopeResolver();
                    if (psiClass == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"componentScan.scopeResolver!!");
                    if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"org.springframework.context.annotation.AnnotationScopeMetadataResolver") ^ true) break block6;
                }
                Set set = componentScan.getIncludeContextFilters();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"componentScan.includeContextFilters");
                Collection collection = set;
                if (!collection.isEmpty()) break block6;
                Set set2 = componentScan.getExcludeContextFilters();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"componentScan.excludeContextFilters");
                collection = set2;
                if (!(!collection.isEmpty())) break block9;
            }
            return false;
        }
        return true;
    }
}

