/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.model.autoconfigure.ConditionalCollector;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import java.util.Collection;

class AutoConfigClassConditionEvaluator {
    private final boolean myNonStrictEvaluation;
    private final PsiClass myAutoConfigClass;
    private final ConditionalOnEvaluationContext myConditionalOnEvaluationContext;

    AutoConfigClassConditionEvaluator(PsiClass autoConfigClass, boolean nonStrictEvaluation, ConditionalOnEvaluationContext conditionalOnEvaluationContext) {
        this.myNonStrictEvaluation = nonStrictEvaluation;
        this.myAutoConfigClass = autoConfigClass;
        this.myConditionalOnEvaluationContext = conditionalOnEvaluationContext;
    }

    boolean isActive() {
        Collection<ConditionalOnJamElement> allConditions = ConditionalCollector.forClass(this.myAutoConfigClass).getConditionals();
        if (allConditions.isEmpty()) {
            return true;
        }
        for (ConditionalOnJamElement condition : allConditions) {
            ConditionOutcome outcome;
            if (this.myNonStrictEvaluation && condition instanceof ConditionalOnJamElement.NonStrict || (outcome = condition.matches(this.myConditionalOnEvaluationContext)).isMatch()) continue;
            return false;
        }
        return true;
    }
}

