/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiFieldPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.Conditional;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnBean;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnClass;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnEnabledHealthIndicator;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnEnabledInfoContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnEnabledResourceChain;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnExpression;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnInitializedRestarter;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnManagementPort;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnMissingBean;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnMissingClass;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnNotWebApplication;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnProperty;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnRepositoryType;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnResource;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnSingleCandidate;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnWebApplication;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureAfter;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureBefore;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureOrder;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.boot.model.autoconfigure.jam.SpringBootApplication;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.EnableConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.spring.boot.model.testing.jam.SpringBootstrapWithTest;
import com.intellij.spring.boot.model.testing.jam.custom.SpringApplicationConfiguration;
import com.intellij.spring.boot.model.testing.jam.mock.CustomJamMockBean;
import com.intellij.spring.boot.model.testing.jam.mock.SpringJamMockBean;
import com.intellij.spring.boot.model.testing.jam.mock.SpringJamMockBeans;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;

public class SpringBootAutoconfigureSemContributor
extends SemContributor {
    private final SemService mySemService;

    public SpringBootAutoconfigureSemContributor(SemService semService) {
        this.mySemService = semService;
    }

    public void registerSemProviders(SemRegistrar registrar) {
        SpringBootApplication.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.SpringBootApplication"));
        this.registerTesting(registrar);
        ConfigurationProperties.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.context.properties.ConfigurationProperties"));
        ConfigurationProperties.Method.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.boot.context.properties.ConfigurationProperties"));
        NestedConfigurationProperty.FIELD_META.register(registrar, (ElementPattern)((PsiFieldPattern)PsiJavaPatterns.psiField().withoutModifiers(new String[]{"static"})).withAnnotation("org.springframework.boot.context.properties.NestedConfigurationProperty"));
        EnableConfigurationProperties.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.context.properties.EnableConfigurationProperties"));
        this.registerEnableAutoConfiguration(registrar);
        AutoConfigureOrder.CLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureOrder"));
        AutoConfigureOrder.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureOrder"));
        AutoConfigureOrder.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureOrder"));
        AutoConfigureAfter.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureAfter"));
        AutoConfigureBefore.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.AutoConfigureBefore"));
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.context.annotation.Conditional", Conditional.CLASS_META, Conditional.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnBean", ConditionalOnBean.CLASS_META, ConditionalOnBean.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean", ConditionalOnMissingBean.CLASS_META, ConditionalOnMissingBean.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnClass", ConditionalOnClass.CLASS_META, ConditionalOnClass.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass", ConditionalOnMissingClass.CLASS_META, ConditionalOnMissingClass.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnExpression", ConditionalOnExpression.CLASS_META, ConditionalOnExpression.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnProperty", ConditionalOnProperty.CLASS_META, ConditionalOnProperty.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnResource", ConditionalOnResource.CLASS_META, ConditionalOnResource.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate", ConditionalOnSingleCandidate.CLASS_META, ConditionalOnSingleCandidate.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication", ConditionalOnWebApplication.CLASS_META, ConditionalOnWebApplication.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication", ConditionalOnNotWebApplication.CLASS_META, ConditionalOnNotWebApplication.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.devtools.restart.ConditionalOnInitializedRestarter", ConditionalOnInitializedRestarter.CLASS_META, ConditionalOnInitializedRestarter.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain", ConditionalOnEnabledResourceChain.CLASS_META, ConditionalOnEnabledResourceChain.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.autoconfigure.data.ConditionalOnRepositoryType", ConditionalOnRepositoryType.CLASS_META, ConditionalOnRepositoryType.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator", ConditionalOnEnabledHealthIndicator.CLASS_META, ConditionalOnEnabledHealthIndicator.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator", ConditionalOnEnabledHealthIndicator.CLASS_META, ConditionalOnEnabledHealthIndicator.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledInfoContributor", ConditionalOnEnabledInfoContributor.CLASS_META, ConditionalOnEnabledInfoContributor.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor", ConditionalOnEnabledInfoContributor.CLASS_META, ConditionalOnEnabledInfoContributor.METHOD_META);
        SpringBootAutoconfigureSemContributor.registerConditionalOn(registrar, "org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort", ConditionalOnManagementPort.CLASS_META, ConditionalOnManagementPort.METHOD_META);
    }

    protected void registerTesting(SemRegistrar registrar) {
        this.registerSpringApplicationConfiguration(registrar);
        this.registerBootstrapWithTests(registrar);
        this.registerMockBeans(registrar);
    }

    private void registerSpringApplicationConfiguration(SemRegistrar registrar) {
        SpringApplicationConfiguration.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.SpringApplicationConfiguration"));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass(), SpringApplicationConfiguration.META_KEY, SpringApplicationConfiguration.SPRING_APP_JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringApplicationConfiguration.SPRING_APP_JAM_KEY, SpringApplicationConfiguration.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.boot.test.SpringApplicationConfiguration", (boolean)true, (boolean)false), pair -> new SpringApplicationConfiguration((String)pair.first, (PsiClass)pair.second), null));
    }

    private void registerBootstrapWithTests(SemRegistrar registrar) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass(), SpringBootstrapWithTest.META_KEY, SpringBootstrapWithTest.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringBootstrapWithTest.JAM_KEY, SpringBootstrapWithTest.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.test.context.BootstrapWith", (boolean)true, (boolean)false), pair -> new SpringBootstrapWithTest((String)pair.first, (PsiClass)pair.second), null));
    }

    private void registerMockBeans(SemRegistrar registrar) {
        registrar.registerSemElementProvider(SpringJamMockBean.JAM_KEY, (ElementPattern)PsiJavaPatterns.psiAnnotation().qName("org.springframework.boot.test.mock.mockito.MockBean"), annotation -> new SpringJamMockBean((PsiAnnotation)annotation));
        SpringJamMockBeans.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.test.mock.mockito.MockBeans"));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass(), CustomJamMockBean.META_KEY, CustomJamMockBean.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(CustomJamMockBean.JAM_KEY, CustomJamMockBean.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.boot.test.mock.mockito.MockBean", (boolean)true, (boolean)false), pair -> new CustomJamMockBean((String)pair.first, (PsiClass)pair.second), null));
    }

    private void registerEnableAutoConfiguration(SemRegistrar registrar) {
        EnableAutoConfiguration.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.boot.autoconfigure.EnableAutoConfiguration"));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)PsiJavaPatterns.psiClass(), EnableAutoConfiguration.META_KEY, EnableAutoConfiguration.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(EnableAutoConfiguration.JAM_KEY, EnableAutoConfiguration.class, EnableAutoConfiguration.getAnnotations(), pair -> new EnableAutoConfiguration((String)pair.first, (PsiClass)pair.getSecond()), null));
    }

    private static <T extends JamElement> void registerConditionalOn(SemRegistrar registrar, String annotationFQN, JamClassMeta<T> classMeta, JamMethodMeta<T> methodMeta) {
        classMeta.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation(annotationFQN));
        methodMeta.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation(annotationFQN));
    }
}

