/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.OldXmlCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.config.WebServersAuthStorage;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebServersConfigManagerBaseImpl<T extends State>
implements PersistentStateComponent<T> {
    private final List<WebServerConfig> myFlattenedServers = new ArrayList<WebServerConfig>();
    private final List<WebServerGroupingWrap> myGroupedServers = new ArrayList<WebServerGroupingWrap>();
    private final boolean isProjectLevel;
    private final List<Listener> myListeners = new SmartList();

    public WebServersConfigManagerBaseImpl(boolean level) {
        this.isProjectLevel = level;
    }

    protected abstract T createState();

    @Deprecated
    @NotNull
    public T getState() {
        T state = this.createState();
        for (WebServerGroupingWrap group : this.myGroupedServers) {
            if (group.isSingleServer()) {
                WebServerConfig server = group.getAsSingleServer();
                server = server.clone();
                server.setIsProjectLevel(false);
                ((State)state).servers.add(server);
                continue;
            }
            GroupingInfo info = new GroupingInfo();
            info.myGroupName = group.getName();
            for (WebServerConfig server : group.getServers()) {
                info.myServerNames.add(server.getName());
                server = server.clone();
                server.setIsProjectLevel(false);
                ((State)state).servers.add(server);
            }
            ((State)state).groups.add(info);
        }
        T t = state;
        if (t == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(0);
        }
        return t;
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(1);
        }
        this.myFlattenedServers.clear();
        this.myGroupedServers.clear();
        ArrayList<Pair> namedServers = new ArrayList<Pair>();
        for (WebServerConfig webServerConfig : ((State)state).servers) {
            if (StringUtil.isEmpty((String)webServerConfig.getId())) {
                webServerConfig.setId(WebServerConfig.getNextId());
            }
            webServerConfig.setIsProjectLevel(this.isProjectLevel);
            namedServers.add(Pair.create((Object)webServerConfig.getName(), (Object)webServerConfig));
            if (webServerConfig.getAccessType() == AccessType.SFTP && webServerConfig.getFileTransferConfig().isAnonymous()) {
                webServerConfig.getFileTransferConfig().setAnonymous(false);
                WebDeploymentCredentialHelper.saveCredentials(webServerConfig, "anonymous", "user@example.com", false);
            }
            this.myFlattenedServers.add(webServerConfig);
        }
        this.getAuthStorage().initServerAuthIfNeeded(this.myFlattenedServers);
        WebDeploymentCredentialHelper.syncWithPasswordSafe(this.myFlattenedServers, new OldXmlCredentialProvider());
        if (((State)state).groups != null) {
            for (GroupingInfo groupingInfo : ((State)state).groups) {
                List<String> serverNames = groupingInfo.myServerNames;
                if (serverNames.isEmpty()) {
                    this.myGroupedServers.add(WebServerGroupingWrap.create(groupingInfo.myGroupName, (List<WebServerConfig>)new SmartList(), this.isProjectLevel));
                    continue;
                }
                String firstName = groupingInfo.myServerNames.get(0);
                while (!namedServers.isEmpty() && !firstName.equals(((Pair)namedServers.get((int)0)).first)) {
                    Pair pair = (Pair)namedServers.remove(0);
                    this.myGroupedServers.add(WebServerGroupingWrap.wrap((WebServerConfig)pair.second));
                }
                ArrayList<WebServerConfig> servers = new ArrayList<WebServerConfig>();
                for (String serverName : serverNames) {
                    if (namedServers.isEmpty() || !serverName.equals(((Pair)namedServers.get((int)0)).first)) break;
                    Pair remove = (Pair)namedServers.remove(0);
                    servers.add((WebServerConfig)remove.second);
                }
                this.myGroupedServers.add(WebServerGroupingWrap.create(groupingInfo.myGroupName, servers, this.isProjectLevel));
            }
        }
        for (Pair pair : namedServers) {
            this.myGroupedServers.add(WebServerGroupingWrap.wrap((WebServerConfig)pair.second));
        }
        this.fireServersLoaded();
    }

    protected abstract WebServersAuthStorage getAuthStorage();

    private void fireServersLoaded() {
        for (Listener listener : this.myListeners) {
            listener.serversLoaded();
        }
    }

    void addListener(Listener listener, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener, this.myListeners, (Disposable)parentDisposable);
    }

    @NotNull
    List<WebServerConfig> getServers() {
        List<WebServerConfig> list = Collections.unmodifiableList(this.myFlattenedServers);
        if (list == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    List<WebServerGroupingWrap> getGroupedServers() {
        List<WebServerGroupingWrap> list = Collections.unmodifiableList(this.myGroupedServers);
        if (list == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    void addServer(@NotNull WebServerConfig serverConfig) {
        if (serverConfig == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(4);
        }
        this.myFlattenedServers.add(serverConfig);
        this.myGroupedServers.add(WebServerGroupingWrap.wrap(serverConfig));
    }

    void addGroup(@NotNull WebServerGroupingWrap wrap) {
        if (wrap == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(5);
        }
        this.myFlattenedServers.addAll(wrap.getServers());
        this.myGroupedServers.add(wrap);
    }

    boolean removeServer(@NotNull WebServerConfig serverConfig) {
        if (serverConfig == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(6);
        }
        if (this.myFlattenedServers.remove(serverConfig)) {
            for (WebServerGroupingWrap group : this.myGroupedServers) {
                if (group.isSingleServer()) {
                    if (!serverConfig.equals(group.getAsSingleServer())) continue;
                    this.myGroupedServers.remove(group);
                    return true;
                }
                if (!group.removeServer(serverConfig)) continue;
                return true;
            }
        }
        return false;
    }

    void clearServersAndGroups() {
        this.myFlattenedServers.clear();
        this.myGroupedServers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupedServers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addServer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeServer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface Listener {
        public void serversLoaded();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class App
    extends WebServersConfigManagerBaseImpl<AppState> {
        private final Collection<Deployable> myServerIdsToReauth = Collections.synchronizedSet(new SmartHashSet());
        @NotNull
        private SftpAdvancedOptions mySftpAdvancedOptions = new SftpAdvancedOptions();

        public static App getInstance() {
            return (App)ServiceManager.getService(App.class);
        }

        public App() {
            super(false);
        }

        @Override
        protected AppState createState() {
            return new AppState();
        }

        @Override
        @NotNull
        public AppState getState() {
            AppState state = (AppState)super.getState();
            state.mySftpAdvancedOptions = this.mySftpAdvancedOptions.clone();
            AppState appState = state;
            if (appState == null) {
                App.$$$reportNull$$$0(0);
            }
            return appState;
        }

        @Override
        public void loadState(@NotNull AppState state) {
            if (state == null) {
                App.$$$reportNull$$$0(1);
            }
            super.loadState(state);
            this.mySftpAdvancedOptions = state.mySftpAdvancedOptions.clone();
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.AppInstance.getInstance();
        }

        @NotNull
        public SftpAdvancedOptions getSftpAdvancedOptions() {
            SftpAdvancedOptions sftpAdvancedOptions = this.mySftpAdvancedOptions.clone();
            if (sftpAdvancedOptions == null) {
                App.$$$reportNull$$$0(2);
            }
            return sftpAdvancedOptions;
        }

        public void setSftpAdvancedOptions(@NotNull SftpAdvancedOptions options) {
            if (options == null) {
                App.$$$reportNull$$$0(3);
            }
            this.mySftpAdvancedOptions = options.clone();
        }

        public void setDeployableToReauth(Deployable deployable) {
            this.myServerIdsToReauth.add(deployable);
        }

        public boolean shouldReauth(Deployable deployable) {
            return this.myServerIdsToReauth.contains(deployable);
        }

        public void noMoreReauth(Deployable deployable) {
            this.myServerIdsToReauth.remove(deployable);
        }

        void resetReauthCache() {
            this.myServerIdsToReauth.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSftpAdvancedOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSftpAdvancedOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AppState
    extends State {
        @Tag(value="sftpAdvancedGlobalOptions")
        public SftpAdvancedOptions mySftpAdvancedOptions = new SftpAdvancedOptions();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class Project
    extends WebServersConfigManagerBaseImpl<State> {
        @NotNull
        private final com.intellij.openapi.project.Project myProject;

        public static Project getInstance(@NotNull com.intellij.openapi.project.Project project) {
            if (project == null) {
                Project.$$$reportNull$$$0(0);
            }
            return (Project)ServiceManager.getService((com.intellij.openapi.project.Project)project, Project.class);
        }

        public Project(@NotNull com.intellij.openapi.project.Project project) {
            if (project == null) {
                Project.$$$reportNull$$$0(1);
            }
            super(true);
            this.myProject = project;
        }

        @Override
        protected State createState() {
            return new State();
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.ProjectInstance.getInstance(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$Project";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        @XCollection
        public List<WebServerConfig> servers = new ArrayList<WebServerConfig>();
        @XCollection(style=XCollection.Style.v2, propertyElementName="groups")
        public List<GroupingInfo> groups = new ArrayList<GroupingInfo>();
    }

    @Tag(value="group")
    private static class GroupingInfo {
        @Tag(value="name")
        public String myGroupName;
        @XCollection(style=XCollection.Style.v2, propertyElementName="servers", elementName="name")
        public List<String> myServerNames = new SmartList();

        private GroupingInfo() {
        }
    }
}

