/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.CommonBundle;
import com.intellij.facet.Facet;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class GwtCreateActionBase
extends CreateElementActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.actions.GwtCreateActionBase");
    @NonNls
    private static final String NAME_TEMPLATE_PROPERTY = "NAME";

    protected GwtCreateActionBase(String text, String description) {
        super(text, description, null);
    }

    @NotNull
    protected final PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        GwtModule gwtModule;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
        if (module == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GwtCreateActionBase.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        GwtFacet facet = GwtFacet.getInstance(module);
        if (facet == null) {
            int answer = Messages.showYesNoDialog((Project)project, (String)GwtBundle.message("question.text.gwt.facet.is.not.configured.for.module.0.do.you.want.to.create.it", module.getName()), (String)GwtBundle.message("dialog.title.google.web.toolkit", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (answer != 0) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    GwtCreateActionBase.$$$reportNull$$$0(1);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            facet = GwtFacet.createNewFacet(module, null);
            ModulesConfigurator.showFacetSettingsDialog((Facet)facet, null);
            facet = GwtFacet.getInstance(module);
            if (facet == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    GwtCreateActionBase.$$$reportNull$$$0(2);
                }
                return PsiElement.EMPTY_ARRAY;
            }
        }
        if (this.requireGwtModule() && (gwtModule = GwtCreateActionBase.findGwtModule(project, directory)) == null) {
            String message = GwtBundle.message("error.message.this.action.is.allowed.only.for.client.side.packages.of.a.gwt.module", new Object[0]);
            Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
            if (PsiElement.EMPTY_ARRAY == null) {
                GwtCreateActionBase.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        this.showDialog(facet, directory, validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            GwtCreateActionBase.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    protected void showDialog(@NotNull GwtFacet facet, @NotNull PsiDirectory directory, @NotNull CreateElementActionBase.MyInputValidator validator) {
        if (facet == null) {
            GwtCreateActionBase.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            GwtCreateActionBase.$$$reportNull$$$0(6);
        }
        if (validator == null) {
            GwtCreateActionBase.$$$reportNull$$$0(7);
        }
        Messages.showInputDialog((Project)facet.getModule().getProject(), (String)this.getDialogPrompt(), (String)this.getDialogTitle(), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
    }

    protected PsiFile[] getAffectedFiles(GwtModule gwtModule) {
        return PsiFile.EMPTY_ARRAY;
    }

    protected abstract boolean requireGwtModule();

    protected abstract String getDialogPrompt();

    protected abstract String getDialogTitle();

    @Nullable
    private static GwtModule findGwtModule(Project project, PsiDirectory directory) {
        return GwtModulesManager.getInstance(project).findGwtModuleByClientSourceFile(directory.getVirtualFile());
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GwtCreateActionBase.$$$reportNull$$$0(8);
        }
        Presentation presentation = e.getPresentation();
        super.update(e);
        if (presentation.isEnabled() && !GwtCreateActionBase.isUnderSourceRootsOfModuleWithGwtFacet(e)) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }

    public static boolean isUnderSourceRootsOfModuleWithGwtFacet(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            return false;
        }
        if (GwtFacet.getInstance(module) == null) {
            return false;
        }
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (view != null && project != null) {
            PsiDirectory[] dirs;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (PsiDirectory dir : dirs = view.getDirectories()) {
                if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        this.doCheckBeforeCreate(newName, directory);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (PsiFile psiFile : this.getAffectedFiles(GwtCreateActionBase.findGwtModule(directory.getProject(), directory))) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) continue;
            files.add(virtualFile);
        }
        ReadonlyStatusHandler.getInstance((Project)directory.getProject()).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(files));
        GwtModule gwtModule = this.requireGwtModule() ? GwtCreateActionBase.findGwtModule(directory.getProject(), directory) : null;
        PsiElement[] psiElementArray = (PsiElement[])WriteAction.compute(() -> this.doCreate(newName, directory, gwtModule));
        if (psiElementArray == null) {
            GwtCreateActionBase.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    @NotNull
    protected abstract PsiElement[] doCreate(String var1, PsiDirectory var2, GwtModule var3) throws Exception;

    protected static PsiClass createClassFromTemplate(PsiDirectory directory, String className, FileType fileType, String templateName, Object ... parameters) throws IncorrectOperationException {
        PsiFile file = GwtCreateActionBase.createFromTemplateInternal(directory, className, className + "." + StdFileTypes.JAVA.getDefaultExtension(), fileType, templateName, parameters);
        return ((PsiJavaFile)file).getClasses()[0];
    }

    protected static PsiFile createFromTemplate(PsiDirectory directory, @NonNls String fileName, FileType fileType, @NonNls String templateName, Object ... parameters) throws IncorrectOperationException {
        return GwtCreateActionBase.createFromTemplateInternal(directory, FileUtil.getNameWithoutExtension((String)fileName), fileName, fileType, templateName, parameters);
    }

    protected static PsiFile createFromTemplateInternal(PsiDirectory directory, String name, String fileName, FileType fileType, String templateName, Object ... parameters) throws IncorrectOperationException {
        String text = GwtCreateActionBase.getTextByTemplate(directory, name, templateName, parameters);
        PsiManager psiManager = directory.getManager();
        PsiFile file = PsiFileFactory.getInstance((Project)directory.getProject()).createFileFromText(fileName, fileType, (CharSequence)text);
        CodeStyleManager.getInstance((PsiManager)psiManager).reformat((PsiElement)file);
        return (PsiFile)directory.add((PsiElement)file);
    }

    @NotNull
    protected static String getTextByTemplate(PsiDirectory directory, String name, String templateName, Object ... parameters) {
        String string;
        FileTemplate template = FileTemplateManager.getInstance((Project)directory.getProject()).getJ2eeTemplate(templateName);
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties());
        JavaTemplateUtil.setPackageNameAttribute((Properties)properties, (PsiDirectory)directory);
        properties.setProperty(NAME_TEMPLATE_PROPERTY, name);
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String propertyName = (String)names.nextElement();
            parametersMap.put(propertyName, properties.getProperty(propertyName));
        }
        LOG.assertTrue(parameters.length % 2 == 0);
        for (int i = 0; i < parameters.length; i += 2) {
            parametersMap.put((String)parameters[i], parameters[i + 1]);
        }
        try {
            string = template.getText(parametersMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load template for " + FileTemplateManager.getInstance((Project)directory.getProject()).internalTemplateToSubject(templateName), e);
        }
        if (string == null) {
            GwtCreateActionBase.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    protected void doCheckBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        JavaDirectoryService.getInstance().checkCreateClass(directory, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/actions/GwtCreateActionBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/actions/GwtCreateActionBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextByTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

