/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.i18n.PropertiesFilesListCellRenderer;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFixOnPsiElement;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.DataManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtInconsistentLocalizableInterfaceInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtInconsistentLocalizableInterfaceInspection");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.inconsistent.gwt.localizable.interface", new Object[0]);
        if (string == null) {
            GwtInconsistentLocalizableInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GwtInconsistentI18nInterface" == null) {
            GwtInconsistentLocalizableInterfaceInspection.$$$reportNull$$$0(1);
        }
        return "GwtInconsistentI18nInterface";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        GwtFacet gwtFacet;
        if (file == null) {
            GwtInconsistentLocalizableInterfaceInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            GwtInconsistentLocalizableInterfaceInspection.$$$reportNull$$$0(3);
        }
        if ((gwtFacet = GwtInconsistentLocalizableInterfaceInspection.getFacet((PsiElement)file)) == null) {
            return null;
        }
        if (file instanceof PropertiesFile) {
            PropertiesFile propertiesFile = (PropertiesFile)file;
            return GwtInconsistentLocalizableInterfaceInspection.checkPropertiesFile(manager, propertiesFile, gwtFacet, isOnTheFly);
        }
        if (file instanceof PsiJavaFile) {
            PsiClass[] psiClasses;
            for (PsiClass psiClass : psiClasses = ((PsiJavaFile)file).getClasses()) {
                ProblemDescriptor[] descriptors = GwtInconsistentLocalizableInterfaceInspection.checkPsiClass(manager, psiClass, isOnTheFly);
                if (descriptors == null) continue;
                return descriptors;
            }
        }
        return null;
    }

    @Nullable
    private static ProblemDescriptor[] checkPsiClass(InspectionManager manager, PsiClass psiClass, boolean onTheFly) {
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PropertiesFile[] files = i18nManager.getPropertiesFiles(psiClass);
        if (files.length == 0) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            IProperty[] properties;
            if (GwtInconsistentLocalizableInterfaceInspection.hasDefaultValue(psiMethod) || (properties = i18nManager.getProperties(psiMethod)).length != 0) continue;
            String description = GwtBundle.message("problem.description.method.0.does.not.have.corresponding.property", psiMethod.getName());
            DefinePropertyQuickfix quickFix = new DefinePropertyQuickfix(GwtI18nUtil.getPropertyName(psiMethod), files);
            descriptors.add(manager.createProblemDescriptor(GwtInconsistentLocalizableInterfaceInspection.getElementToHighlight(psiMethod), description, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean hasDefaultValue(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            GwtInconsistentLocalizableInterfaceInspection.$$$reportNull$$$0(4);
        }
        for (PsiAnnotation annotation : psiMethod.getModifierList().getAnnotations()) {
            String name = annotation.getQualifiedName();
            if (name == null || !name.startsWith("com.google.gwt.i18n.client.Constants.Default") && !name.equals("com.google.gwt.i18n.client.Messages.DefaultMessage")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static ProblemDescriptor[] checkPropertiesFile(InspectionManager manager, PropertiesFile propertiesFile, GwtFacet gwtFacet, boolean onTheFly) {
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PsiClass anInterface = i18nManager.getPropertiesInterface(propertiesFile);
        if (anInterface == null) {
            return null;
        }
        ArrayList<IProperty> propertiesWithoutMethods = new ArrayList<IProperty>();
        List properties = propertiesFile.getProperties();
        for (IProperty property : properties) {
            PsiMethod method = i18nManager.getMethod(property);
            if (method != null || property.getUnescapedKey() == null) continue;
            propertiesWithoutMethods.add(property);
        }
        if (propertiesWithoutMethods.isEmpty()) {
            return null;
        }
        SynchronizeInterfaceQuickFix syncAllQuickfix = propertiesWithoutMethods.size() > 1 ? new SynchronizeInterfaceQuickFix(anInterface, propertiesWithoutMethods, gwtFacet.getSdkVersion()) : null;
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (IProperty property : propertiesWithoutMethods) {
            LocalQuickFix[] localQuickFixArray;
            String key = property.getUnescapedKey();
            AddMethodToInterfaceQuickFix quickFix = new AddMethodToInterfaceQuickFix(anInterface, key, property.getValue(), gwtFacet.getSdkVersion());
            if (syncAllQuickfix == null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = quickFix;
            } else {
                LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
                localQuickFixArray3[0] = syncAllQuickfix;
                localQuickFixArray = localQuickFixArray3;
                localQuickFixArray3[1] = quickFix;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            String description = GwtBundle.message("problem.description.property.0.does.not.have.corresponding.method.in.1", key, anInterface.getName());
            problems.add(manager.createProblemDescriptor(property.getPsiElement(), description, onTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void defineProperty(PropertiesFile propertiesFile, String propertyName) {
        Computable computeProperty = () -> GwtInconsistentLocalizableInterfaceInspection.definePropertyImpl(propertiesFile, propertyName);
        IProperty property = (IProperty)WriteCommandAction.runWriteCommandAction((Project)propertiesFile.getProject(), (Computable)computeProperty);
        if (property != null) {
            GwtI18nUtil.navigateToProperty(property);
        }
    }

    @Nullable
    private static IProperty definePropertyImpl(PropertiesFile propertiesFile, String propertyName) {
        try {
            return propertiesFile.addProperty(propertyName, "");
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static boolean ensureWritable(PsiElement element) {
        return !ReadonlyStatusHandler.getInstance((Project)element.getProject()).ensureFilesWritable(new VirtualFile[]{element.getContainingFile().getVirtualFile()}).hasReadonlyFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefinePropertyQuickfix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.property", new Object[0]);
        private final String myPropertyName;
        private final PropertiesFile[] myPropertiesFiles;

        DefinePropertyQuickfix(String propertyName, PropertiesFile[] propertiesFiles) {
            super(GwtBundle.message("quickfix.name.create.property.0", propertyName));
            this.myPropertyName = propertyName;
            this.myPropertiesFiles = propertiesFiles;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                DefinePropertyQuickfix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DefinePropertyQuickfix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DefinePropertyQuickfix.$$$reportNull$$$0(2);
            }
            if (this.myPropertiesFiles.length == 1) {
                IProperty property;
                PropertiesFile file = this.myPropertiesFiles[0];
                if (GwtInconsistentLocalizableInterfaceInspection.ensureWritable((PsiElement)file.getContainingFile()) && (property = GwtInconsistentLocalizableInterfaceInspection.definePropertyImpl(file, this.myPropertyName)) != null) {
                    GwtI18nUtil.navigateToProperty(property);
                }
                return;
            }
            JBList list = new JBList((Object[])this.myPropertiesFiles);
            PropertiesFilesListCellRenderer renderer = new PropertiesFilesListCellRenderer();
            list.setCellRenderer(renderer);
            list.setSelectionMode(0);
            PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list);
            renderer.installSpeedSearch(builder);
            builder.setTitle(GwtBundle.message("quickfix.popup.title.choose.properties.file", new Object[0])).setItemChoosenCallback(() -> this.lambda$applyFix$0((JList)list)).createPopup().showInBestPositionFor(DataManager.getInstance().getDataContext());
        }

        private /* synthetic */ void lambda$applyFix$0(JList list) {
            int index = list.getSelectedIndex();
            if (index != -1) {
                GwtInconsistentLocalizableInterfaceInspection.defineProperty(this.myPropertiesFiles[index], this.myPropertyName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$DefinePropertyQuickfix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$DefinePropertyQuickfix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SynchronizeInterfaceQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final GwtVersion myGwtVersion;
        private final List<IProperty> myProperties;

        SynchronizeInterfaceQuickFix(PsiClass anInterface, List<IProperty> properties, GwtVersion gwtVersion) {
            super(FAMILY_NAME, GwtBundle.message("quickfix.name.synchronize.all.methods.in.0", anInterface.getName()), (PsiElement)anInterface);
            this.myProperties = properties;
            this.myGwtVersion = gwtVersion;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                SynchronizeInterfaceQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                SynchronizeInterfaceQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                SynchronizeInterfaceQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                SynchronizeInterfaceQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiClass)) {
                return;
            }
            PsiClass anInterface = (PsiClass)startElement;
            if (!GwtInconsistentLocalizableInterfaceInspection.ensureWritable((PsiElement)anInterface)) {
                return;
            }
            for (IProperty property : this.myProperties) {
                GwtI18nUtil.addMethod(anInterface, property.getUnescapedKey(), property.getValue(), this.myGwtVersion);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$SynchronizeInterfaceQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddMethodToInterfaceQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final String myPropertyName;
        private final String myPropertyValue;
        private final GwtVersion myGwtVersion;

        AddMethodToInterfaceQuickFix(PsiClass anInterface, String propertyName, String value, GwtVersion gwtVersion) {
            super(FAMILY_NAME, GwtBundle.message("quickfix.name.create.method.for.property.0.in.1", propertyName, anInterface.getName()), (PsiElement)anInterface);
            this.myPropertyName = propertyName;
            this.myPropertyValue = value;
            this.myGwtVersion = gwtVersion;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddMethodToInterfaceQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                AddMethodToInterfaceQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                AddMethodToInterfaceQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                AddMethodToInterfaceQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiClass)) {
                return;
            }
            PsiClass anInterface = (PsiClass)startElement;
            if (!GwtInconsistentLocalizableInterfaceInspection.ensureWritable((PsiElement)anInterface)) {
                return;
            }
            GwtI18nUtil.addMethod(anInterface, this.myPropertyName, this.myPropertyValue, this.myGwtVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/inspections/GwtInconsistentLocalizableInterfaceInspection$AddMethodToInterfaceQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

