/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFixOnPsiElement;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.rpc.GwtServletUtil;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.gwt.web.GwtWebUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtServiceNotRegisteredInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtServiceNotRegisteredInspection");
    private static final ExtensionPointName<Condition<PsiClass>> UNREGISTERED_SERVLET_FILTERS = ExtensionPointName.create((String)"com.intellij.gwt.unregisteredServletFilter");

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.gwt.remote.service.is.not.registered.in.web.xml", new Object[0]);
        if (string == null) {
            GwtServiceNotRegisteredInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("GwtServiceNotRegistered" == null) {
            GwtServiceNotRegisteredInspection.$$$reportNull$$$0(1);
        }
        return "GwtServiceNotRegistered";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            GwtServiceNotRegisteredInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            GwtServiceNotRegisteredInspection.$$$reportNull$$$0(3);
        }
        if (!DeploymentDescriptorsConstants.WEB_XML_META_DATA.getFileName().equals(file.getName())) {
            return null;
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)file);
        if (webFacet == null) {
            return null;
        }
        GwtFacet gwtFacet = GwtFacet.getInstance(webFacet.getModule());
        if (gwtFacet == null) {
            return null;
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp == null || !file.equals(webApp.getContainingFile())) {
            return null;
        }
        HashMap<Object, Pair> expectedUrlPatterns = new HashMap<Object, Pair>();
        HashMap<Object, String> serviceNames = new HashMap<Object, String>();
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(manager.getProject());
        for (Object servlet : webApp.getServlets()) {
            GwtModule gwtModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            PsiClass serviceInterface;
            PsiClass servletClass = (PsiClass)servlet.getServletClass().getValue();
            if (servletClass == null || !RemoteServiceUtil.isRemoteServiceImplementation(servletClass) || (serviceInterface = RemoteServiceUtil.findRemoteServiceInterface(servletClass)) == null || (psiFile = serviceInterface.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null || (gwtModule = gwtModulesManager.findGwtModuleByClientSourceFile(virtualFile)) == null) continue;
            String serviceName = serviceInterface.getName();
            expectedUrlPatterns.put(servlet, Pair.create((Object)gwtModule, (Object)GwtServletUtil.getServletPath(gwtModule, serviceName, servletClass)));
            serviceNames.put(servlet, serviceName);
        }
        HashMap<CommonServlet, ServletMapping> singleMappings = new HashMap<CommonServlet, ServletMapping>();
        for (ServletMapping mapping : webApp.getServletMappings()) {
            CommonServlet servlet = (CommonServlet)mapping.getServletName().getValue();
            if (servlet == null) continue;
            Pair urlPattern = (Pair)expectedUrlPatterns.get(servlet);
            if (singleMappings.containsKey(servlet)) {
                singleMappings.remove(servlet);
            } else {
                singleMappings.put(servlet, mapping);
            }
            if (urlPattern == null || !GwtServiceNotRegisteredInspection.containsServletPath(mapping, (GwtModule)urlPattern.getFirst(), (String)urlPattern.getSecond(), gwtFacet.getModule())) continue;
            expectedUrlPatterns.remove(servlet);
        }
        if (expectedUrlPatterns.isEmpty()) {
            return null;
        }
        SmartList problems = new SmartList();
        for (CommonServlet servlet : expectedUrlPatterns.keySet()) {
            List urlPatterns;
            ServletMapping mapping = (ServletMapping)singleMappings.get(servlet);
            String serviceName = (String)serviceNames.get(servlet);
            Pair pair = (Pair)expectedUrlPatterns.get(servlet);
            String urlPattern = GwtServletUtil.getServletUrlPattern(gwtFacet, (GwtModule)pair.getFirst(), (String)pair.getSecond());
            AddServletMappingFix quickfix = new AddServletMappingFix(webApp, servlet, serviceName, urlPattern, mapping);
            List list = urlPatterns = mapping != null ? mapping.getUrlPatterns() : Collections.emptyList();
            if (urlPatterns.size() != 1) {
                String message = GwtBundle.message("problem.description.correct.servlet.mapping.is.not.specified.for.remote.service.0", serviceName);
                XmlToken token = (XmlToken)ObjectUtils.assertNotNull((Object)XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)ObjectUtils.assertNotNull((Object)servlet.getXmlTag()))));
                problems.add(manager.createProblemDescriptor((PsiElement)token, message, (LocalQuickFix)quickfix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                continue;
            }
            XmlTag tag = (XmlTag)ObjectUtils.assertNotNull((Object)((GenericDomValue)urlPatterns.get(0)).getXmlTag());
            String message = GwtBundle.message("problem.description.incorrect.servlet.mapping.for.remote.service.0", serviceName);
            problems.add(manager.createProblemDescriptor((PsiElement)tag, XmlTagUtil.getTrimmedValueRange((XmlTag)tag), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{quickfix}));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean containsServletPath(ServletMapping mapping, GwtModule serviceModule, String relativePath, Module module) {
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(module.getProject());
        for (GenericDomValue pattern : mapping.getUrlPatterns()) {
            String urlPattern = (String)pattern.getValue();
            if (urlPattern == null || !urlPattern.endsWith(relativePath)) continue;
            String modulePath = StringUtil.trimEnd((String)StringUtil.trimStart((String)urlPattern.substring(0, urlPattern.length() - relativePath.length()), (String)"/"), (String)"/");
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            Collection<GwtModule> gwtModules = gwtModulesManager.findGwtModulesByOutputName(modulePath, scope);
            for (GwtModule gwtModule : gwtModules) {
                if (!gwtModulesManager.isInheritedOrSelf(gwtModule, serviceModule)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            GwtServiceNotRegisteredInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            GwtServiceNotRegisteredInspection.$$$reportNull$$$0(5);
        }
        if (!GwtServiceNotRegisteredInspection.shouldCheck((PsiElement)aClass)) {
            return null;
        }
        Project project = manager.getProject();
        if (!RemoteServiceUtil.isRemoteServiceImplementation(aClass)) {
            return null;
        }
        PsiClass service = RemoteServiceUtil.findRemoteServiceInterface(aClass);
        if (service == null) {
            return null;
        }
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
        VirtualFile virtualFile = service.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        GwtModule gwtModule = gwtModulesManager.findGwtModuleByClientSourceFile(virtualFile);
        if (gwtModule == null) {
            return null;
        }
        Module module = gwtModule.getModule();
        if (module == null) {
            return null;
        }
        GwtFacet facet = GwtFacet.findFacetBySourceFile(project, gwtModule.getModuleFile());
        if (facet == null) {
            return null;
        }
        for (Condition condition : (Condition[])UNREGISTERED_SERVLET_FILTERS.getExtensions()) {
            if (!condition.value((Object)aClass)) continue;
            return null;
        }
        String serviceName = service.getName();
        WebFacet webFacet = facet.getWebFacet();
        if (webFacet == null) {
            LocalQuickFix[] quickFixes;
            if (!facet.getSdkVersion().isHostedModeRequiresWebXml()) {
                return null;
            }
            String message = GwtBundle.message("problem.description.remote.service.is.not.registered.as.a.servlet.in.web.xml", serviceName);
            Collection webFacets = WebFacet.getInstances((Module)module);
            if (webFacets.isEmpty()) {
                quickFixes = new LocalQuickFix[]{new CreateWebFacetAndRegisterQuickFix(facet, gwtModule, aClass, serviceName)};
            } else {
                ArrayList<RegisterServiceQuickFix> fixes = new ArrayList<RegisterServiceQuickFix>();
                for (WebFacet web : webFacets) {
                    WebApp webApp = web.getRoot();
                    if (webApp == null) continue;
                    fixes.add(new RegisterServiceQuickFix(facet, gwtModule, webApp, aClass, serviceName, web));
                }
                quickFixes = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            }
            return new ProblemDescriptor[]{manager.createProblemDescriptor(GwtServiceNotRegisteredInspection.getElementToHighlight(aClass), message, isOnTheFly, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp == null) {
            return null;
        }
        Servlet servlet = GwtServletUtil.findServlet(webApp, aClass);
        if (servlet == null) {
            String message = GwtBundle.message("problem.description.remote.service.is.not.registered.as.a.servlet.in.web.xml", serviceName);
            RegisterServiceQuickFix quickFix = new RegisterServiceQuickFix(facet, gwtModule, webApp, aClass, serviceName, webFacet);
            return new ProblemDescriptor[]{manager.createProblemDescriptor(GwtServiceNotRegisteredInspection.getElementToHighlight(aClass), message, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddServletMappingFix
    implements LocalQuickFix {
        private static final String FAMILY_NAME_ADD_MAPPING = GwtBundle.message("quickfix.family.name.add.servlet.mapping.for.remote.service", new Object[0]);
        private static final String FAMILY_NAME_SET_MAPPING = GwtBundle.message("quickfix.family.name.set.servlet.mapping.for.remote.service", new Object[0]);
        private final WebApp myRoot;
        private final CommonServlet myServlet;
        private final String myServiceName;
        private final String myUrlPattern;
        private final ServletMapping myExistingMapping;

        AddServletMappingFix(WebApp root, CommonServlet servlet, String serviceName, String urlPattern, ServletMapping existentMapping) {
            this.myRoot = root;
            this.myServlet = servlet;
            this.myServiceName = serviceName;
            this.myUrlPattern = urlPattern;
            this.myExistingMapping = existentMapping;
        }

        @NotNull
        public String getName() {
            String string = this.myExistingMapping == null || this.myExistingMapping.getUrlPatterns().size() > 1 ? GwtBundle.message("quickfix.name.add.servlet.mapping.for.remote.service.0", this.myServiceName) : GwtBundle.message("quickfix.name.set.correct.servlet.mapping.for.remote.service.0", this.myServiceName);
            if (string == null) {
                AddServletMappingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myExistingMapping == null || this.myExistingMapping.getUrlPatterns().size() > 1 ? FAMILY_NAME_ADD_MAPPING : FAMILY_NAME_SET_MAPPING;
            if (string == null) {
                AddServletMappingFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddServletMappingFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddServletMappingFix.$$$reportNull$$$0(3);
            }
            if (this.myExistingMapping == null) {
                GwtServletUtil.addServletMapping(this.myRoot, this.myServlet, this.myUrlPattern);
            } else {
                List urlPatterns = this.myExistingMapping.getUrlPatterns();
                if (urlPatterns.size() == 1) {
                    ((GenericDomValue)urlPatterns.get(0)).setValue((Object)this.myUrlPattern);
                } else {
                    this.myExistingMapping.addUrlPattern().setValue((Object)this.myUrlPattern);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$AddServletMappingFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$AddServletMappingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RegisterServiceQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String FAMILY_NAME_REGISTER = GwtBundle.message("quickfix.family.name.register.remote.service.in.web.xml", new Object[0]);
        private static final String FAMILY_NAME_CONNECT_AND_REGISTER = GwtBundle.message("quickfix.family.name.connect.gwt.facet.and.register.remote.service.in.web.xml", new Object[0]);
        protected final GwtFacet myFacet;
        private final GwtModule myGwtModule;
        private final WebApp myWebApp;
        private final String myServiceName;
        private final WebFacet myWebFacet;

        RegisterServiceQuickFix(GwtFacet facet, GwtModule gwtModule, WebApp webApp, PsiClass serviceImpl, String serviceName, @NotNull WebFacet webFacet) {
            if (webFacet == null) {
                RegisterServiceQuickFix.$$$reportNull$$$0(0);
            }
            super(webFacet.equals((Object)facet.getWebFacet()) ? FAMILY_NAME_REGISTER : FAMILY_NAME_CONNECT_AND_REGISTER, webFacet.equals((Object)facet.getWebFacet()) ? GwtBundle.message("quickfix.name.register.remote.service.0.in.web.xml", serviceName) : GwtBundle.message("quickfix.name.connect.gwt.facet.to.0.facet.and.register.remote.service.1.in.web.xml", webFacet.getName(), serviceName), (PsiElement)serviceImpl);
            this.myFacet = facet;
            this.myGwtModule = gwtModule;
            this.myWebApp = webApp;
            this.myServiceName = serviceName;
            this.myWebFacet = webFacet;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                RegisterServiceQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                RegisterServiceQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                RegisterServiceQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                RegisterServiceQuickFix.$$$reportNull$$$0(4);
            }
            if (!(startElement instanceof PsiClass)) {
                return;
            }
            PsiClass serviceImpl = (PsiClass)startElement;
            if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{DomUtil.getFile((DomElement)this.myWebApp).getVirtualFile()}).hasReadonlyFiles()) {
                if (!this.myWebFacet.equals((Object)this.myFacet.getWebFacet())) {
                    ((GwtFacetConfiguration)this.myFacet.getConfiguration()).setWebFacetName(this.myWebFacet.getName());
                }
                GwtServletUtil.registerServletForService(this.myFacet, this.myGwtModule, this.myWebApp, serviceImpl, this.myServiceName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "webFacet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$RegisterServiceQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CreateWebFacetAndRegisterQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        public static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.web.facet.and.register.remote.service.in.web.xml", new Object[0]);
        private final GwtFacet myFacet;
        private final GwtModule myGwtModule;
        private final String myServiceName;

        private CreateWebFacetAndRegisterQuickFix(GwtFacet facet, GwtModule gwtModule, PsiClass serviceImpl, String serviceName) {
            super(FAMILY_NAME, GwtBundle.message("quickfix.name.create.web.facet.and.register.remote.service.0.in.web.xml", serviceName), (PsiElement)serviceImpl);
            this.myFacet = facet;
            this.myGwtModule = gwtModule;
            this.myServiceName = serviceName;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                CreateWebFacetAndRegisterQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                CreateWebFacetAndRegisterQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CreateWebFacetAndRegisterQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                CreateWebFacetAndRegisterQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiClass)) {
                return;
            }
            PsiClass serviceImpl = (PsiClass)startElement;
            VirtualFile root = this.findContentRoot();
            LOG.assertTrue(root != null, (Object)this.myGwtModule.getModuleFile());
            WebFacet webFacet = GwtWebUtil.createWebFacet(this.myFacet, root);
            WebApp webApp = webFacet.getRoot();
            LOG.assertTrue(webApp != null);
            GwtServletUtil.registerServletForService(this.myFacet, this.myGwtModule, webApp, serviceImpl, this.myServiceName);
        }

        @Nullable
        private VirtualFile findContentRoot() {
            VirtualFile[] contentRoots;
            for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getContentRoots()) {
                if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)this.myGwtModule.getModuleFile(), (boolean)false)) continue;
                return root;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/inspections/GwtServiceNotRegisteredInspection$CreateWebFacetAndRegisterQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

