/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.inspections.AbstractClientCodeReferencesInspection;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonJREEmulationClassesInClientCodeInspection
extends AbstractClientCodeReferencesInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.NonJREEmulationClassesInClientCodeInspection");

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.classes.not.from.jre.emulation.library.in.client.code", new Object[0]);
        if (string == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("NonJREEmulationClassesInClientCode" == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(1);
        }
        return "NonJREEmulationClassesInClientCode";
    }

    @Override
    protected void checkClassReference(@NotNull PsiJavaCodeReferenceElement reference, @NotNull PsiClass referencedClass, @NotNull String className, @NotNull VirtualFile virtualFile, @NotNull GwtFacet gwtFacet, List<GwtModule> gwtModules, @NotNull GwtModulesManager gwtModulesManager, @NotNull InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        if (reference == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(2);
        }
        if (referencedClass == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(3);
        }
        if (className == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(5);
        }
        if (gwtFacet == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(6);
        }
        if (gwtModulesManager == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            NonJREEmulationClassesInClientCodeInspection.$$$reportNull$$$0(8);
        }
        if (!NonJREEmulationClassesInClientCodeInspection.isInJdk(virtualFile, gwtFacet)) {
            return;
        }
        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)referencedClass);
        if (topLevelClass == null) {
            topLevelClass = referencedClass;
        }
        if (!((GwtFacetConfiguration)gwtFacet.getConfiguration()).getSdk().containsJreEmulationClass(gwtModules, topLevelClass.getQualifiedName())) {
            String message = GwtBundle.message("problem.description.class.0.is.not.presented.in.jre.emulation.library", className, gwtModules.get(0).getQualifiedName());
            problems.add(manager.createProblemDescriptor((PsiElement)reference, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    @Override
    protected void checkMethodReference(PsiJavaCodeReferenceElement reference, PsiMethod method, GwtFacet facet, List<GwtModule> gwtModules, GwtModulesManager gwtModulesManager, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !NonJREEmulationClassesInClientCodeInspection.isInJdk(virtualFile, facet)) {
            return;
        }
        PsiClass emulationClass = ((GwtFacetConfiguration)facet.getConfiguration()).getSdk().findJreEmulationClass(gwtModules, psiClass);
        if (emulationClass == null) {
            return;
        }
        if (!NonJREEmulationClassesInClientCodeInspection.containsMethodWithSignature(emulationClass, method)) {
            String message = GwtBundle.message("problem.description.method.0.is.not.presented.in.jre.emulation.library", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2), gwtModules.get(0).getQualifiedName());
            problems.add(manager.createProblemDescriptor((PsiElement)reference, message, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static boolean containsMethodWithSignature(PsiClass emulationClass, PsiMethod method) {
        if (method.isConstructor() && method.getParameterList().getParametersCount() == 0 && emulationClass.getConstructors().length == 0) {
            return true;
        }
        MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)true);
        for (PsiMethod psiMethod : emulationClass.findMethodsByName(method.getName(), true)) {
            if (!signature.equals((Object)MethodSignatureBackedByPsiMethod.create((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)true))) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Method with signature " + signature + " not found in " + emulationClass.getQualifiedName());
            PsiFile file = emulationClass.getContainingFile();
            LOG.debug("File: " + (file != null ? file.getVirtualFile() : "null"));
            LOG.debug("Methods:");
            for (PsiMethod psiMethod : emulationClass.getMethods()) {
                LOG.debug(MethodSignatureBackedByPsiMethod.create((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)true).toString());
            }
        }
        return false;
    }

    private static boolean isInJdk(VirtualFile virtualFile, GwtFacet facet) {
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)facet.getModule()).getFileIndex();
        for (OrderEntry entry : fileIndex.getOrderEntriesForFile(virtualFile)) {
            if (!(entry instanceof JdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtFacet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModulesManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkClassReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

