/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections.eventListeners;

import com.intellij.gwt.inspections.eventListeners.DeprecatedEventListenersRegistry;
import com.intellij.gwt.inspections.eventListeners.DeprecatedListener;
import com.intellij.gwt.inspections.eventListeners.DeprecatedListenerUsages;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.Nullable;

class EventListenersUsagesCollector
extends JavaRecursiveElementWalkingVisitor {
    private final DeprecatedEventListenersRegistry myListenersRegistry = DeprecatedEventListenersRegistry.getInstance();
    private final DeprecatedListenerUsages myUsages = new DeprecatedListenerUsages();

    EventListenersUsagesCollector() {
    }

    public DeprecatedListenerUsages getListenerUsages() {
        return this.myUsages;
    }

    public void visitVariable(PsiVariable variable) {
        if (this.isDeprecatedListenerType(variable.getType(), true)) {
            this.myUsages.findOrRegisterDeclaration(variable);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                this.myUsages.registerAssignment(variable, null, initializer);
            }
        }
        super.visitVariable(variable);
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        PsiVariable variable;
        PsiType type;
        PsiElement resolved;
        PsiExpression left = expression.getLExpression();
        if (left instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)left).resolve()) instanceof PsiVariable && this.isDeprecatedListenerType(type = (variable = (PsiVariable)resolved).getType(), true)) {
            this.myUsages.registerAssignment(variable, left, expression.getRExpression());
        }
        super.visitAssignmentExpression(expression);
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiVariable) {
            PsiMethod method;
            PsiElement declaration;
            PsiVariable variable = (PsiVariable)resolved;
            PsiType type = variable.getType();
            if (this.isDeprecatedListenerType(type, true)) {
                this.myUsages.registerReference(variable, reference);
            } else if (variable instanceof PsiParameter && (declaration = ((PsiParameter)variable).getDeclarationScope()) instanceof PsiMethod && this.myListenersRegistry.isEventMethodName((method = (PsiMethod)declaration).getName())) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = method.findDeepestSuperMethods()) {
                    PsiClass containingClass = superMethod.getContainingClass();
                    if (containingClass == null || !this.myListenersRegistry.isDeprecatedListener(containingClass.getQualifiedName())) continue;
                    this.myUsages.registerParameterReference(method);
                }
            }
        }
        super.visitReferenceElement(reference);
    }

    public void visitNewExpression(PsiNewExpression expression) {
        PsiClass constructorClass;
        PsiMethod constructor = expression.resolveConstructor();
        PsiExpressionList argumentList = expression.getArgumentList();
        if (constructor != null && argumentList != null && (constructorClass = constructor.getContainingClass()) != null) {
            PsiParameter[] parameters = constructor.getParameterList().getParameters();
            PsiExpression[] arguments = argumentList.getExpressions();
            for (int i = 0; i < Math.min(parameters.length, arguments.length); ++i) {
                PsiMethod[] constructors;
                String handlerClass;
                DeprecatedListener listener;
                PsiClass psiClass;
                PsiType type = parameters[i].getType();
                if (!(type instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null || (listener = this.myListenersRegistry.findByListenerClass(psiClass.getQualifiedName())) == null || (handlerClass = listener.getHandlerClassIfSingle()) == null || !EventListenersUsagesCollector.containsConstructorWithHandlerParameter(constructors = constructorClass.findMethodsByName(constructor.getName(), false), parameters, i, handlerClass)) continue;
                this.myUsages.registerNewExpressionWithListenerAsParameter(listener, arguments[i]);
            }
        }
        super.visitNewExpression(expression);
    }

    private static boolean containsConstructorWithHandlerParameter(PsiMethod[] constructors, PsiParameter[] parameters, int index, String handlerClass) {
        for (PsiMethod constructor : constructors) {
            PsiParameter[] constructorParameters = constructor.getParameterList().getParameters();
            if (parameters.length != constructorParameters.length) continue;
            boolean typesMatch = true;
            for (int i = 0; i < parameters.length; ++i) {
                PsiType constructorParameterType = constructorParameters[i].getType();
                if (i != index) {
                    typesMatch &= constructorParameterType.equals(parameters[i].getType());
                    continue;
                }
                typesMatch &= constructorParameterType.equalsToText(handlerClass);
            }
            if (!typesMatch) continue;
            return true;
        }
        return false;
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        PsiMethod method;
        String methodName;
        PsiElement resolved = expression.getMethodExpression().resolve();
        if (resolved instanceof PsiMethod && this.myListenersRegistry.isAddOrRemoveListenerMethodName(methodName = (method = (PsiMethod)resolved).getName())) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = method.findDeepestSuperMethods()) {
                PsiType componentType;
                PsiExpression qualifierExpression;
                DeprecatedListener info;
                PsiClass psiClass = psiMethod.getContainingClass();
                if (psiClass == null || (info = this.myListenersRegistry.findByHolderClass(psiClass.getQualifiedName())) == null || (qualifierExpression = expression.getMethodExpression().getQualifierExpression()) == null || (componentType = qualifierExpression.getType()) == null) continue;
                if (info.getAddListenerMethod().equals(methodName)) {
                    this.myUsages.registerAddOrRemoveListenerCall(info, expression, true);
                    continue;
                }
                if (!info.getRemoveListenerMethod().equals(methodName)) continue;
                this.myUsages.registerAddOrRemoveListenerCall(info, expression, false);
            }
        }
        super.visitMethodCallExpression(expression);
    }

    private boolean isDeprecatedListenerType(@Nullable PsiType type, boolean directImplementationAllowed) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return false;
        }
        if (this.myListenersRegistry.isDeprecatedListener(psiClass.getQualifiedName())) {
            return true;
        }
        if (!directImplementationAllowed) {
            return false;
        }
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null && this.myListenersRegistry.isDeprecatedListener(superClass.getQualifiedName())) {
            return true;
        }
        for (PsiClass anInterface : psiClass.getInterfaces()) {
            if (!this.myListenersRegistry.isDeprecatedListener(anInterface.getQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

