/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class GwtCompilerPaths {
    private GwtCompilerPaths() {
    }

    public static File getTestGenDirectory(@NotNull Module module) {
        if (module == null) {
            GwtCompilerPaths.$$$reportNull$$$0(0);
        }
        return new File(GwtCompilerPaths.getTestOutputRoot(module), "gen");
    }

    public static File getTestOutputDirectory(@NotNull Module module) {
        if (module == null) {
            GwtCompilerPaths.$$$reportNull$$$0(1);
        }
        return new File(GwtCompilerPaths.getTestOutputRoot(module), "www");
    }

    private static File getTestOutputRoot(@NotNull Module module) {
        if (module == null) {
            GwtCompilerPaths.$$$reportNull$$$0(2);
        }
        return new File(GwtCompilerPaths.getOutputRoot(module), "test");
    }

    public static File getOutputRoot(@NotNull Module module) {
        if (module == null) {
            GwtCompilerPaths.$$$reportNull$$$0(3);
        }
        return GwtCompilerPaths.getProjectOutputRoot(module.getProject()).resolve(GwtCompilerPaths.getOutputDirectoryName(module)).toFile();
    }

    @NotNull
    public static Path getProjectOutputRoot(@NotNull Project project) {
        if (project == null) {
            GwtCompilerPaths.$$$reportNull$$$0(4);
        }
        Path path = ProjectUtil.getProjectCachePath((Project)project, (Path)GwtCompilerPaths.getOutputRoot());
        if (path == null) {
            GwtCompilerPaths.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    public static Path getOutputRoot() {
        Path path = PathManagerEx.getAppSystemDir().resolve("gwt");
        if (path == null) {
            GwtCompilerPaths.$$$reportNull$$$0(6);
        }
        return path;
    }

    private static String getOutputDirectoryName(@NotNull Module module) {
        if (module == null) {
            GwtCompilerPaths.$$$reportNull$$$0(7);
        }
        String moduleName = module.getName();
        String modulePath = module.getModuleFilePath();
        return moduleName.replace(' ', '_') + "." + Integer.toHexString(modulePath.hashCode());
    }

    public static File getCompileReportInfo(@NotNull Project project) {
        if (project == null) {
            GwtCompilerPaths.$$$reportNull$$$0(8);
        }
        return GwtCompilerPaths.getProjectOutputRoot(project).resolve("compile-reports-v2.xml").toFile();
    }

    public static File getGwtSourcePaths(@NotNull Project project) {
        if (project == null) {
            GwtCompilerPaths.$$$reportNull$$$0(9);
        }
        return GwtCompilerPaths.getProjectOutputRoot(project).resolve("gwt-source-paths.xml").toFile();
    }

    public static File getGwtDependencies(Project project) {
        return new File(BuildManager.getInstance().getProjectSystemDirectory(project), "gwt-dependencies.xml");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/make/GwtCompilerPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/make/GwtCompilerPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOutputRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestGenDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestOutputDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestOutputRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOutputRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectOutputRoot";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDirectoryName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompileReportInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGwtSourcePaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

