/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.PathUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GeneratedJsReferenceProvider
extends PsiReferenceProvider {
    GeneratedJsReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiFile containingFile;
        if (element == null) {
            GeneratedJsReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GeneratedJsReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((containingFile = element.getContainingFile()) != null) {
            XmlAttributeValue attributeValue;
            String value;
            VirtualFile file = containingFile.getVirtualFile();
            Project project = element.getProject();
            GwtFacet gwtFacet = GwtFacet.findFacetBySourceFile(project, file);
            if (gwtFacet != null && file != null && element instanceof XmlAttributeValue && (value = (attributeValue = (XmlAttributeValue)element).getValue()).endsWith(".nocache.js")) {
                WebDirectoryElement parent;
                WebDirectoryElement webDirectory;
                List<Pair<GwtModule, String>> gwtModulesByPublicFile = GwtModulesManager.getInstance(project).findGwtModulesByPublicFile(file);
                if (!gwtModulesByPublicFile.isEmpty()) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new GwtModuleInHtmlFileUnderPublicRootReference(file, attributeValue)};
                    if (psiReferenceArray == null) {
                        GeneratedJsReferenceProvider.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (gwtFacet.getSdkVersion().isHtmlFilesOutsideSourcesAreAllowed() && (webDirectory = WebUtil.findWebDirectoryByFile((VirtualFile)file, (Project)project)) != null && (parent = webDirectory.getParent()) != null) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new GwtModuleInHtmlFileUnderWebRootReference(parent.getPath(), attributeValue)};
                    if (psiReferenceArray == null) {
                        GeneratedJsReferenceProvider.$$$reportNull$$$0(3);
                    }
                    return psiReferenceArray;
                }
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            GeneratedJsReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/references/GeneratedJsReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/references/GeneratedJsReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class GwtModuleInHtmlFileReferenceBase
    extends PsiPolyVariantReferenceBase<XmlAttributeValue> {
        @NonNls
        private static final String NO_CACHE_JS_SUFFIX = ".nocache.js";
        protected GwtModulesManager myModulesManager;

        GwtModuleInHtmlFileReferenceBase(XmlAttributeValue attributeValue) {
            super((PsiElement)attributeValue, true);
            this.myModulesManager = GwtModulesManager.getInstance(attributeValue.getProject());
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            String path = StringUtil.trimEnd((String)this.getValue(), (String)NO_CACHE_JS_SUFFIX);
            SmartList gwtModules = new SmartList();
            this.collectGwtModuleByPath(path, (List<GwtModule>)gwtModules);
            ResolveResult[] resolveResults = new ResolveResult[gwtModules.size()];
            for (int i = 0; i < gwtModules.size(); ++i) {
                resolveResults[i] = new PsiElementResolveResult((PsiElement)((GwtModule)gwtModules.get(i)).getModuleXmlFile());
            }
            if (resolveResults == null) {
                GwtModuleInHtmlFileReferenceBase.$$$reportNull$$$0(0);
            }
            return resolveResults;
        }

        protected abstract void collectGwtModuleByPath(String var1, List<GwtModule> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GeneratedJsReferenceProvider$GwtModuleInHtmlFileReferenceBase", "multiResolve"));
        }
    }

    private static class GwtModuleInHtmlFileUnderPublicRootReference
    extends GwtModuleInHtmlFileReferenceBase {
        private final VirtualFile myFile;

        private GwtModuleInHtmlFileUnderPublicRootReference(VirtualFile file, XmlAttributeValue attributeValue) {
            super(attributeValue);
            this.myFile = file;
        }

        @Override
        protected void collectGwtModuleByPath(String path, List<GwtModule> result) {
            List<Pair<GwtModule, String>> publicFile = this.myModulesManager.findGwtModulesByPublicFile(this.myFile);
            for (Pair<GwtModule, String> pair : publicFile) {
                GwtModule module = (GwtModule)pair.getFirst();
                if (!PathUtil.getParentPath((String)((String)pair.getSecond())).isEmpty() || !path.equals(module.getOutputName())) continue;
                result.add(module);
            }
        }
    }

    private static class GwtModuleInHtmlFileUnderWebRootReference
    extends GwtModuleInHtmlFileReferenceBase {
        private final String myPathFromWebRoot;

        GwtModuleInHtmlFileUnderWebRootReference(String pathFromWebRoot, XmlAttributeValue attributeValue) {
            super(attributeValue);
            this.myPathFromWebRoot = pathFromWebRoot;
        }

        @Override
        protected void collectGwtModuleByPath(String path, List<GwtModule> modules) {
            String outputName = PathUtil.getFileName((String)path);
            Collection<GwtModule> gwtModules = this.myModulesManager.findGwtModulesByOutputName(outputName, ((XmlAttributeValue)this.getElement()).getContainingFile().getResolveScope());
            if (gwtModules.isEmpty()) {
                return;
            }
            String canonicalPath = PathUtil.getCanonicalPath((String)DeploymentUtil.appendToPath((String)this.myPathFromWebRoot, (String)path));
            if (canonicalPath == null) {
                return;
            }
            if (FileUtil.pathsEqual((String)canonicalPath, (String)("/" + outputName + "/" + outputName))) {
                modules.addAll(gwtModules);
            }
        }
    }
}

