/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;

class GwtFileUrlMapper
extends FileUrlMapper {
    private static final int DEFAULT_PORT_NUMBER = 9876;
    private static final Key<Integer> PORT_KEY = Key.create((String)"gwtCodeServerPort");
    private static final String PATH_PREFIX = "/sourcemaps/";

    GwtFileUrlMapper() {
    }

    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        if (file == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(1);
        }
        if (file.getFileType() != JavaFileType.INSTANCE) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                GwtFileUrlMapper.$$$reportNull$$$0(2);
            }
            return list;
        }
        THashSet ports = new THashSet();
        ports.add(String.valueOf(9876));
        for (ProcessHandler processHandler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            Integer port = (Integer)PORT_KEY.get((UserDataHolder)processHandler);
            if (port == null) continue;
            ports.add(String.valueOf(port));
        }
        List<Url> list = GwtFileUrlMapper.doCreateUrl(file, project, (Collection<String>)ports);
        if (list == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<Url> doCreateUrl(@NotNull VirtualFile file, @NotNull Project project, Collection<String> ports) {
        List urls;
        if (file == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(5);
        }
        List list = (urls = (List)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode(() -> {
            if (project == null) {
                GwtFileUrlMapper.$$$reportNull$$$0(18);
            }
            if (file == null) {
                GwtFileUrlMapper.$$$reportNull$$$0(19);
            }
            GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
            VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file);
            if (sourceRoot == null || sourceRoot.getFileSystem() == StandardFileSystems.jar()) {
                return Collections.emptyList();
            }
            List<GwtModule> gwtModules = gwtModulesManager.findGwtModulesByClientSourceFile(file);
            if (gwtModules.isEmpty()) {
                return Collections.emptyList();
            }
            String relativeUrlPath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
            if (relativeUrlPath == null) {
                return Collections.emptyList();
            }
            Url[] result = new Url[gwtModules.size() * ports.size()];
            for (int i = 0; i < gwtModules.size(); ++i) {
                String path = PATH_PREFIX + gwtModules.get(i).getOutputName() + '/' + relativeUrlPath;
                for (String port : ports) {
                    result[i] = Urls.newHttpUrl((String)("localhost:" + port), (String)path);
                }
            }
            return Arrays.asList(result);
        }, "GWT file mapping is not possible during index update")) == null ? Collections.emptyList() : urls;
        if (list == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public SourceFileResolver createSourceResolver(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(8);
        }
        if (file.getFileType() != JavaFileType.INSTANCE) {
            return null;
        }
        return (SourceFileResolver)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode(() -> {
            VirtualFile sourceRoot;
            if (project == null) {
                GwtFileUrlMapper.$$$reportNull$$$0(16);
            }
            if (file == null) {
                GwtFileUrlMapper.$$$reportNull$$$0(17);
            }
            if ((sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file)) == null) {
                return null;
            }
            GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
            String relativePath = gwtModulesManager.isUnderGwtModule(file) ? VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/') : null;
            return relativePath == null ? null : new MySourceResolver(relativePath);
        }, "GWT file mapping is not possible during index update");
    }

    @Nullable
    private static PsiClass findClass(@NotNull Url url, @NotNull Project project) {
        String path;
        if (url == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(9);
        }
        if (project == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(10);
        }
        if (!(path = url.getPath()).startsWith(PATH_PREFIX) || !path.endsWith(".java")) {
            return null;
        }
        int index = path.indexOf(47, PATH_PREFIX.length() + 1);
        if (index < 0 || path.length() < index + 2 + ".java".length()) {
            return null;
        }
        String moduleName = path.substring(PATH_PREFIX.length(), index);
        String className = path.substring(index + 1, path.length() - ".java".length()).replace('/', '.');
        return (PsiClass)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode(() -> {
            if (project == null) {
                GwtFileUrlMapper.$$$reportNull$$$0(15);
            }
            GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(project);
            for (GwtModule gwtModule : gwtModulesManager.findGwtModulesByOutputName(moduleName, GlobalSearchScope.projectScope((Project)project))) {
                Module module = gwtModule.getModule();
                if (module == null) continue;
                PsiClass[] psiClasses = JavaPsiFacade.getInstance((Project)project).findClasses(className, module.getModuleWithLibrariesScope());
                if (psiClasses.length == 1) {
                    return psiClasses[0];
                }
                if (psiClasses.length <= 1) continue;
                for (PsiClass psiClass : psiClasses) {
                    if (!psiClass.canNavigateToSource() || psiClass.getNavigationElement().getContainingFile().getFileType() != JavaFileType.INSTANCE) continue;
                    return psiClass;
                }
                Arrays.sort(psiClasses, new Comparator<PsiClass>(){

                    private int getWeight(@NotNull PsiClass psiClass) {
                        if (psiClass == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (psiClass.canNavigateToSource()) {
                            return 2;
                        }
                        return psiClass.canNavigate() ? 1 : 0;
                    }

                    @Override
                    public int compare(@NotNull PsiClass c1, @NotNull PsiClass c2) {
                        if (c1 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (c2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return this.getWeight(c1) - this.getWeight(c2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "psiClass";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "c1";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "c2";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/gwt/run/GwtFileUrlMapper$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getWeight";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "compare";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                return psiClasses[psiClasses.length - 1];
            }
            return null;
        }, "GWT file mapping is not possible during index update");
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        if (url == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(11);
        }
        if (project == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(12);
        }
        return GwtFileUrlMapper.findClass(url, project);
    }

    @Nullable
    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        PsiClass psiClass;
        if (url == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GwtFileUrlMapper.$$$reportNull$$$0(14);
        }
        if ((psiClass = GwtFileUrlMapper.findClass(url, project)) == null) {
            return null;
        }
        return (VirtualFile)ReadAction.compute(() -> {
            PsiFile psiFile = psiClass.getNavigationElement().getContainingFile();
            if (psiFile == null) {
                psiFile = psiClass.getContainingFile();
            }
            return psiFile == null ? null : psiFile.getVirtualFile();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/run/GwtFileUrlMapper";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/run/GwtFileUrlMapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateUrl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSourceResolver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClass$2";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSourceResolver$1";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCreateUrl$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySourceResolver
    implements SourceFileResolver {
        private final String relativeUrlPath;

        MySourceResolver(@NotNull String relativeUrlPath) {
            if (relativeUrlPath == null) {
                MySourceResolver.$$$reportNull$$$0(0);
            }
            this.relativeUrlPath = relativeUrlPath;
        }

        public int resolve(@NotNull ObjectIntHashMap<Url> map) {
            if (map == null) {
                MySourceResolver.$$$reportNull$$$0(1);
            }
            final AtomicInteger result = new AtomicInteger(-1);
            map.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<Url>(){

                public boolean execute(Url url, int index) {
                    int postfixLength;
                    String path = url.getPath();
                    int pathLength = path.length();
                    if (pathLength > (postfixLength = relativeUrlPath.length()) && path.charAt(pathLength - postfixLength - 1) == '/' && path.endsWith(relativeUrlPath)) {
                        result.set(index);
                        return false;
                    }
                    return true;
                }
            });
            return result.get();
        }

        public int resolve(@NotNull List<String> rawSources) {
            if (rawSources == null) {
                MySourceResolver.$$$reportNull$$$0(2);
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativeUrlPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawSources";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/gwt/run/GwtFileUrlMapper$MySourceResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

