/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.superSource;

import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.superSource.GwtModuleSuperSourceIndex;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtSuperSourceElementFinder
extends PsiElementFinder {
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final Map<String, List<VirtualFile>> mySuperSourceDirectoriesByPackageName = ContainerUtil.newConcurrentMap();
    private final Set<String> myNonExistentSuperSourcePackages = ContainerUtil.newConcurrentSet();
    private final Map<VirtualFile, Map<String, VirtualFile>> mySuperSourceClassesByDirectory = ContainerUtil.newConcurrentMap();

    public GwtSuperSourceElementFinder(Project project, PsiManager psiManager) {
        this.myProject = project;
        this.myPsiManager = psiManager;
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GwtSuperSourceElementFinder.this.clearCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$1", "rootsChanged"));
            }
        });
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file = vFileEvent.getFile();
                    if (file == null || !file.getFileType().equals(StdFileTypes.JAVA)) continue;
                    GwtSuperSourceElementFinder.this.clearDirectoryCache(file.getParent());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$2", "after"));
            }
        });
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            private void processChange(PsiTreeChangeEvent event) {
                PsiFile file = event.getFile();
                if (file != null) {
                    PsiDirectory psiDirectory;
                    if (file.getName().endsWith(".gwt.xml")) {
                        GwtSuperSourceElementFinder.this.clearCaches();
                    }
                    if ((psiDirectory = file.getContainingDirectory()) != null) {
                        GwtSuperSourceElementFinder.this.clearDirectoryCache(psiDirectory.getVirtualFile());
                    }
                }
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.processChange(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.processChange(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                this.processChange(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                this.processChange(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(4);
                }
                this.processChange(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/gwt/superSource/GwtSuperSourceElementFinder$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LowMemoryWatcher.register(() -> {
            this.myNonExistentSuperSourcePackages.clear();
            this.mySuperSourceClassesByDirectory.clear();
        }, (Disposable)project);
    }

    private void clearCaches() {
        this.myNonExistentSuperSourcePackages.clear();
        this.mySuperSourceDirectoriesByPackageName.clear();
        this.mySuperSourceClassesByDirectory.clear();
    }

    private void clearDirectoryCache(VirtualFile packageDirectory) {
        if (packageDirectory != null) {
            this.mySuperSourceClassesByDirectory.remove(packageDirectory);
        }
    }

    private List<VirtualFile> getDirectoriesByPackageName(String packageName) {
        List<VirtualFile> cached = this.mySuperSourceDirectoriesByPackageName.get(packageName);
        if (cached != null) {
            return cached;
        }
        if (this.myNonExistentSuperSourcePackages.contains(packageName)) {
            return Collections.emptyList();
        }
        List<VirtualFile> result = this.findDirectoriesByPackageName(packageName);
        if (result.isEmpty()) {
            this.myNonExistentSuperSourcePackages.add(packageName);
        } else {
            this.mySuperSourceDirectoriesByPackageName.put(packageName, result);
        }
        return result;
    }

    @NotNull
    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        if (StringUtil.isEmpty((String)packageName)) {
            List<VirtualFile> list = GwtModuleSuperSourceIndex.getSuperSourceRoots(GlobalSearchScope.allScope((Project)this.myProject));
            if (list == null) {
                GwtSuperSourceElementFinder.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<VirtualFile> parentDirectories = this.getDirectoriesByPackageName(StringUtil.getPackageName((String)packageName));
        if (parentDirectories.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GwtSuperSourceElementFinder.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList result = new SmartList();
        String shortName = StringUtil.getShortName((String)packageName);
        for (VirtualFile parentDirectory : parentDirectories) {
            VirtualFile child = parentDirectory.findChild(shortName);
            if (child == null || !child.isDirectory()) continue;
            result.add(child);
        }
        SmartList smartList = result;
        if (smartList == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(3);
        }
        if (!this.hasGwtFacets() || DumbService.isDumb((Project)this.myProject)) {
            return null;
        }
        if (!this.getDirectoriesByPackageName(qualifiedName).isEmpty()) {
            return new PsiPackageImpl(this.myPsiManager, qualifiedName);
        }
        return null;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(5);
        }
        return (PsiClass)ContainerUtil.getFirstItem(this.doFindClasses(qualifiedName, scope));
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(7);
        }
        PsiClass[] psiClassArray = (PsiClass[])ContainerUtil.toArray(this.doFindClasses(qualifiedName, scope), (ArrayFactory)PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(8);
        }
        return psiClassArray;
    }

    @NotNull
    private List<PsiClass> doFindClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        String packageName;
        if (qualifiedName == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(10);
        }
        if (!this.hasGwtFacets()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                GwtSuperSourceElementFinder.$$$reportNull$$$0(11);
            }
            return list;
        }
        SmartList result = new SmartList();
        SmartList innerClassNames = new SmartList();
        GwtSuperSourceClassCache classCache = GwtSuperSourceClassCache.getInstance(this.myProject);
        String currentName = qualifiedName;
        do {
            packageName = StringUtil.getPackageName((String)currentName);
            String className = StringUtil.getShortName((String)currentName);
            if (!className.isEmpty() && Character.isLowerCase(className.charAt(0)) && !innerClassNames.isEmpty()) break;
            block1: for (VirtualFile directory : this.getDirectoriesByPackageName(packageName)) {
                PsiFile psiFile;
                Map cachedMap;
                VirtualFile file;
                if (!directory.isValid() || !scope.contains(directory) || (file = (VirtualFile)(cachedMap = this.mySuperSourceClassesByDirectory.computeIfAbsent(directory, d -> {
                    HashMap classNameToFile = ContainerUtil.newHashMap();
                    for (VirtualFile file : directory.getChildren()) {
                        PsiFile psiFile = classCache.getCachedPsiFile(file);
                        if (!(psiFile instanceof PsiJavaFile)) continue;
                        for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                            classNameToFile.put(aClass.getQualifiedName(), file);
                        }
                    }
                    return classNameToFile.isEmpty() ? Collections.emptyMap() : new THashMap((Map)classNameToFile);
                })).get(currentName)) == null || !scope.contains(file) || !((psiFile = classCache.getCachedPsiFile(file)) instanceof PsiJavaFile)) continue;
                for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                    if (!currentName.equals(aClass.getQualifiedName())) continue;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)GwtSuperSourceClassCache.findInnerClass(aClass, (List<String>)innerClassNames));
                    continue block1;
                }
            }
            innerClassNames.add(className);
        } while ((currentName = packageName).length() > 0);
        SmartList smartList = result;
        if (smartList == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    private boolean hasGwtFacets() {
        return ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(GwtFacetType.ID);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(15);
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.hasGwtFacets()) {
            return true;
        }
        for (VirtualFile directory : this.getDirectoriesByPackageName(psiPackage.getQualifiedName())) {
            PsiDirectory psiDirectory;
            if (!scope.contains(directory) || (psiDirectory = this.myPsiManager.findDirectory(directory)) == null || consumer.process((Object)psiDirectory)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(17);
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.hasGwtFacets()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                GwtSuperSourceElementFinder.$$$reportNull$$$0(18);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList classes = null;
        for (VirtualFile packageDir : this.getDirectoriesByPackageName(psiPackage.getQualifiedName())) {
            if (!scope.contains(packageDir)) continue;
            for (VirtualFile file : packageDir.getChildren()) {
                PsiFile psiFile;
                if (!scope.contains(file) || !file.getFileType().equals(StdFileTypes.JAVA) || !((psiFile = GwtSuperSourceClassCache.getInstance(this.myProject).getCachedPsiFile(file)) instanceof PsiClassOwner)) continue;
                if (classes == null) {
                    classes = new ArrayList();
                }
                Collections.addAll(classes, ((PsiClassOwner)psiFile).getClasses());
            }
        }
        PsiClass[] psiClassArray = classes != null ? classes.toArray(PsiClass.EMPTY_ARRAY) : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            GwtSuperSourceElementFinder.$$$reportNull$$$0(19);
        }
        return psiClassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/superSource/GwtSuperSourceElementFinder";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectoriesByPackageName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/superSource/GwtSuperSourceElementFinder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindClasses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doFindClasses";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

