/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.layout;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.jboss.jbpm.annotation.AnnotationCoordinator;
import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.layout.ChartVirtualLayoutCoordinator;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.model.ChartEdge;
import com.intellij.jboss.jbpm.model.ChartNode;
import com.intellij.jboss.jbpm.render.size.ChartNodeSizeEnhancer;
import com.intellij.jboss.jbpm.render.size.RenderDefaultSize;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.graph.layout.LayoutGraph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChartPersistentLayouter<T>
implements Layouter {
    private static final int elementsSpace = 40;
    @NotNull
    private final ChartVirtualLayoutCoordinator chartVirtualLayoutCoordinator;
    @NotNull
    private final DiagramVfsResolver<T> vfsResolver;
    @NotNull
    private final AnnotationCoordinator<RenderDefaultSize> renderSizeCoordinator;
    private final DiagramBuilder diagramBuilder;
    private final ChartDataModel<T> dataModel;
    private final Graph2D graph;
    private final PsiFile[] psiFiles;

    public ChartPersistentLayouter(@NotNull ChartLayoutCoordinator coordinator, @NotNull DiagramVfsResolver<T> resolver, ChartDataModel<T> model, PsiFile[] psiFiles, DocumentReference[] references) {
        if (coordinator == null) {
            ChartPersistentLayouter.$$$reportNull$$$0(0);
        }
        if (resolver == null) {
            ChartPersistentLayouter.$$$reportNull$$$0(1);
        }
        this.renderSizeCoordinator = new AnnotationCoordinator<RenderDefaultSize>(RenderDefaultSize.class, RenderDefaultSize.class.getAnnotation(RenderDefaultSize.class));
        this.chartVirtualLayoutCoordinator = new ChartVirtualLayoutCoordinator(model.getProject(), references, false, coordinator);
        this.vfsResolver = resolver;
        this.dataModel = model;
        this.diagramBuilder = model.getBuilder();
        this.graph = this.diagramBuilder.getGraph();
        this.psiFiles = psiFiles;
    }

    public boolean canLayout(LayoutGraph graph) {
        return true;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        ArrayList<ChartNode<T>> toLayout = new ArrayList<ChartNode<T>>();
        int maxY = 0;
        for (ChartNode<T> chartNode : this.dataModel.getNodes()) {
            ChartLayoutCoordinator.NodeLayout nodeLayout = this.layoutChartNode(chartNode);
            if (nodeLayout != null) {
                maxY = (int)Math.max((double)maxY, nodeLayout.getBottom());
                continue;
            }
            toLayout.add(chartNode);
        }
        int finalMaxY = maxY;
        if (toLayout.size() > 0) {
            WriteCommandAction.writeCommandAction((Project)this.dataModel.getProject(), (PsiFile[])this.psiFiles).run(() -> {
                int x = 40;
                int y = finalMaxY + 40;
                for (ChartNode node : toLayout) {
                    x = this.layoutDiagramNodeVirtual(node, x, y) + 40;
                }
            });
        }
        for (DiagramEdge diagramEdge : this.dataModel.getEdges()) {
            this.layoutDiagramEdge(diagramEdge);
        }
        this.diagramBuilder.getView().updateView();
    }

    private void layoutDiagramEdge(DiagramEdge<T> diagramEdge) {
        String fqnFrom = this.vfsResolver.getQualifiedName(diagramEdge.getSource().getIdentifyingElement());
        String fqnTo = this.vfsResolver.getQualifiedName(diagramEdge.getTarget().getIdentifyingElement());
        if (StringUtil.isEmpty((String)fqnFrom) || StringUtil.isEmpty((String)fqnTo)) {
            return;
        }
        List<ChartLayoutCoordinator.Point> points = this.chartVirtualLayoutCoordinator.getEdgePoints(fqnFrom, fqnTo);
        if (points == null || points.isEmpty()) {
            return;
        }
        Edge edge = this.diagramBuilder.getEdge(diagramEdge);
        EdgeLayout edgeLayout = this.graph.getLayout(edge);
        edgeLayout.clearPoints();
        for (ChartLayoutCoordinator.Point point : points) {
            edgeLayout.addPoint(point.x, point.y);
        }
    }

    private ChartLayoutCoordinator.NodeLayout layoutChartNode(ChartNode<T> chartNode) {
        String fqn = this.vfsResolver.getQualifiedName(chartNode.getIdentifyingElement());
        if (StringUtil.isEmpty((String)fqn)) {
            return null;
        }
        ChartLayoutCoordinator.NodeLayout nodeLayout = this.chartVirtualLayoutCoordinator.getNodeLayout(fqn, ChartNodeSizeEnhancer.enhancerForNode(chartNode));
        if (nodeLayout == null) {
            return null;
        }
        Node node = this.diagramBuilder.getNode(chartNode);
        this.graph.setCenter(node, nodeLayout.getCenterX(), nodeLayout.getCenterY());
        return nodeLayout;
    }

    private int layoutDiagramNodeVirtual(ChartNode<T> chartNode, int x, int y) {
        RenderDefaultSize size;
        ChartLayoutCoordinator.NodeLayout nodeLayout;
        String fqn = this.vfsResolver.getQualifiedName(chartNode.getIdentifyingElement());
        Runnable action = this.chartVirtualLayoutCoordinator.getCreateNodeLayoutAction(fqn, nodeLayout = ChartLayoutCoordinator.NodeLayout.createByEdges(x, y, (double)x + (size = this.renderSizeCoordinator.getAnnotation(chartNode.getClassesWithAnnotationsForRendering())).width(), (double)y + size.height()), ChartNodeSizeEnhancer.enhancerForNode(chartNode), true);
        if (action != null) {
            action.run();
        }
        Node node = this.diagramBuilder.getNode(chartNode);
        this.graph.setCenter(node, nodeLayout.getCenterX(), nodeLayout.getCenterY());
        return (int)nodeLayout.getRight();
    }

    @Nullable
    public Runnable getDiagramNodeLayoutChangeAction(ChartNode<T> chartNode) {
        String fqn = this.vfsResolver.getQualifiedName(chartNode.getIdentifyingElement());
        if (StringUtil.isEmpty((String)fqn)) {
            return null;
        }
        Node node = this.diagramBuilder.getNode(chartNode);
        return this.chartVirtualLayoutCoordinator.getChangeNodeLayoutAction(fqn, ChartLayoutCoordinator.NodeLayout.createByCenterPoint(this.graph.getCenterX(node), this.graph.getCenterY(node), this.graph.getWidth(node), this.graph.getHeight(node)), ChartNodeSizeEnhancer.enhancerForNode(chartNode));
    }

    @Nullable
    private Runnable getDiagramEdgeLayoutChangeAction(ChartEdge<T> chartEdge) {
        String fqnSource = this.vfsResolver.getQualifiedName(chartEdge.getSource().getIdentifyingElement());
        String fqnTarget = this.vfsResolver.getQualifiedName(chartEdge.getTarget().getIdentifyingElement());
        if (StringUtil.isEmpty((String)fqnSource) || StringUtil.isEmpty((String)fqnTarget)) {
            return null;
        }
        Edge edge = this.diagramBuilder.getEdge(chartEdge);
        EdgeLayout edgeLayout = this.graph.getLayout(edge);
        ArrayList<ChartLayoutCoordinator.Point> points = new ArrayList<ChartLayoutCoordinator.Point>();
        for (int i = 0; i < edgeLayout.pointCount(); ++i) {
            YPoint point = edgeLayout.getPoint(i);
            points.add(new ChartLayoutCoordinator.Point(point.getX(), point.getY()));
        }
        return this.chartVirtualLayoutCoordinator.getChangeEdgePointsAction(fqnSource, fqnTarget, points);
    }

    public void applyLayoutChanges() {
        List actions = JBIterable.from(this.dataModel.getNodes()).transform(node -> this.getDiagramNodeLayoutChangeAction((ChartNode<T>)((Object)node))).append((Iterable)JBIterable.from(this.dataModel.getEdges()).transform(edge -> this.getDiagramEdgeLayoutChangeAction((ChartEdge<T>)((Object)edge)))).filter(runnable -> runnable != null).toList();
        if (!actions.isEmpty()) {
            CommandProcessor.getInstance().executeCommand(this.diagramBuilder.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                for (Runnable action : actions) {
                    action.run();
                }
            }), "Graph layout change", null, UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "coordinator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resolver";
                break;
            }
        }
        objectArray[1] = "com/intellij/jboss/jbpm/layout/ChartPersistentLayouter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

