/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlDateType;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariableType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlBuiltInDescriptor {
    private final String myCamelCaseName;
    private final String mySnakeCaseName;
    private final Function<? super FtlBuiltIn, ? extends FtlType> myType;

    protected FtlBuiltInDescriptor(@NonNls String camelCaseName, Function<? super FtlBuiltIn, ? extends FtlType> type) {
        String lower = FtlPsiUtil.camelToSnakeCase(camelCaseName);
        this.mySnakeCaseName = lower != null ? lower : camelCaseName;
        this.myCamelCaseName = camelCaseName;
        this.myType = type;
    }

    public FtlBuiltInDescriptor(String snakeCaseName, String camelCaseName, Function<? super FtlBuiltIn, ? extends FtlType> type) {
        if (snakeCaseName.contains("_") && !StringUtil.hasUpperCaseChar((String)camelCaseName)) {
            throw new IllegalArgumentException("camelCase name not supplied for " + snakeCaseName + " built-in");
        }
        this.mySnakeCaseName = snakeCaseName;
        this.myCamelCaseName = camelCaseName;
        this.myType = type;
    }

    public FtlBuiltInDescriptor(@NonNls String name, PsiType psiType) {
        this(name, (Function<? super FtlBuiltIn, ? extends FtlType>)new NullableConstantFunction((Object)FtlPsiType.wrap(psiType)));
    }

    public String getCamelCaseName() {
        return this.myCamelCaseName;
    }

    public String getSnakeCaseName() {
        return this.mySnakeCaseName;
    }

    public abstract boolean acceptsQualifier(@NotNull FtlType var1, @NotNull PsiElement var2);

    @Nullable
    public FtlType getType(FtlBuiltIn builtIn) {
        return (FtlType)this.myType.fun((Object)builtIn);
    }

    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    @NonNls
    public String getQuickFixReplacement(FtlBuiltIn builtIn) {
        return null;
    }

    public static class BooleanBuiltIn
    extends FtlBuiltInDescriptor {
        public BooleanBuiltIn(@NonNls String name, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            FtlPsiType type;
            if (qualifierType == null) {
                BooleanBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BooleanBuiltIn.$$$reportNull$$$0(1);
            }
            return (type = qualifierType.asInstanceOf(FtlPsiType.class)) != null && (PsiType.BOOLEAN.equals((Object)type.getPsiType()) || type.getPsiType().equalsToText("java.lang.Boolean"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$BooleanBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HashBuiltIn
    extends FtlBuiltInDescriptor {
        public HashBuiltIn(@NonNls String name, int typeParam) {
            super(name, (Function<? super FtlBuiltIn, ? extends FtlType>)((Function)builtIn -> new FtlCollectionType(HashBuiltIn.getHashComponentType(builtIn.getQualifierType(), typeParam))));
        }

        @Nullable
        public static FtlPsiType getHashComponentType(FtlType type, int typeParam) {
            PsiType psiType = FtlPsiUtil.extractPsiType(type);
            return FtlPsiType.wrap(PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Map", (int)typeParam, (boolean)true));
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                HashBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                HashBuiltIn.$$$reportNull$$$0(1);
            }
            return HashBuiltIn.isHash(qualifierType);
        }

        public static boolean isHash(FtlType qualifierType) {
            return FtlPsiUtil.isAssignableToClass(qualifierType, "java.util.Map");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$HashBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SequenceBuiltIn
    extends FtlBuiltInDescriptor {
        public SequenceBuiltIn(@NonNls String name, NullableFunction<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, (Function<? super FtlBuiltIn, ? extends FtlType>)type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                SequenceBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SequenceBuiltIn.$$$reportNull$$$0(1);
            }
            return FtlListDirective.isCollectionType(qualifierType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$SequenceBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateBuiltIn
    extends FtlBuiltInDescriptor {
        public DateBuiltIn(@NonNls String name, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, type);
        }

        public DateBuiltIn(String name, String camelCaseName, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, camelCaseName, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                DateBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DateBuiltIn.$$$reportNull$$$0(1);
            }
            return qualifierType.asInstanceOf(FtlDateType.class) != null || FtlPsiUtil.isAssignableToClass(qualifierType, "java.util.Date");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$DateBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class LoopVariableBuiltIn
    extends FtlBuiltInDescriptor {
        public LoopVariableBuiltIn(@NonNls String name, FtlType psiType) {
            super(name, (Function<? super FtlBuiltIn, ? extends FtlType>)new NullableConstantFunction((Object)psiType));
        }

        public LoopVariableBuiltIn(@NonNls String name, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                LoopVariableBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                LoopVariableBuiltIn.$$$reportNull$$$0(1);
            }
            return qualifierType.asInstanceOf(FtlLoopVariableType.class) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$LoopVariableBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NodeBuiltIn
    extends FtlBuiltInDescriptor {
        public NodeBuiltIn(@NonNls String name, FtlType psiType) {
            super(name, (Function<? super FtlBuiltIn, ? extends FtlType>)new NullableConstantFunction((Object)psiType));
        }

        public NodeBuiltIn(@NonNls String name, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                NodeBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NodeBuiltIn.$$$reportNull$$$0(1);
            }
            return qualifierType.asInstanceOf(FtlNodeType.class) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$NodeBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class StringBuiltIn
    extends FtlBuiltInDescriptor {
        public StringBuiltIn(@NonNls String name, PsiType psiType) {
            super(name, psiType);
        }

        public StringBuiltIn(@NonNls String name, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                StringBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                StringBuiltIn.$$$reportNull$$$0(1);
            }
            if (!"string".equals(this.getCamelCaseName()) && FtlPsiUtil.isNumeric(qualifierType, context)) {
                return true;
            }
            return FtlPsiUtil.isAssignableToClass(qualifierType, "java.lang.String") || FtlPsiUtil.isAssignableToClass(qualifierType, "java.lang.Enum");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$StringBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ObjectBuiltIn
    extends FtlBuiltInDescriptor {
        public ObjectBuiltIn(@NonNls String name, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, type);
        }

        public ObjectBuiltIn(@NonNls String name, PsiType psiType) {
            super(name, psiType);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                ObjectBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ObjectBuiltIn.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$ObjectBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NumberBuiltIn
    extends FtlBuiltInDescriptor {
        public NumberBuiltIn(@NonNls String name, PsiType psiType) {
            super(name, psiType);
        }

        public NumberBuiltIn(@NonNls String name, Function<? super FtlBuiltIn, ? extends FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                NumberBuiltIn.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NumberBuiltIn.$$$reportNull$$$0(1);
            }
            return FtlPsiUtil.isNumeric(qualifierType, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/FtlBuiltInDescriptor$NumberBuiltIn";
            objectArray[2] = "acceptsQualifier";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

