/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlBinaryExpression;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeMacroCallStyle
implements IntentionAction {
    private volatile Boolean myToNamed;

    @NotNull
    public String getText() {
        Boolean toNamed = this.myToNamed;
        if (toNamed == null) {
            if ("Change macro call style" == null) {
                ChangeMacroCallStyle.$$$reportNull$$$0(0);
            }
            return "Change macro call style";
        }
        String string = toNamed != false ? FreeMarkerBundle.message("change.macro.call.style.to.named", new Object[0]) : FreeMarkerBundle.message("change.macro.call.style.to.positinal", new Object[0]);
        if (string == null) {
            ChangeMacroCallStyle.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = FreeMarkerBundle.message("change.macro.call.style.family", new Object[0]);
        if (string == null) {
            ChangeMacroCallStyle.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeMacroCallStyle.$$$reportNull$$$0(3);
        }
        this.myToNamed = null;
        if (!(file instanceof FtlFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        FtlMacro macro = (FtlMacro)PsiTreeUtil.getParentOfType((PsiElement)element, FtlMacro.class, (boolean)false, (Class[])new Class[]{FtlDirective.class, FtlInterpolation.class});
        if (macro == null) {
            return false;
        }
        FtlArgumentList argumentList = macro.getArgumentList();
        int posCount = argumentList.getPositionalArguments().length;
        FtlNameValuePair[] namedArguments = argumentList.getNamedArguments();
        if (posCount == 0 && namedArguments.length == 0) {
            return false;
        }
        FtlSignatureDirective target = macro.resolveMacro();
        if (target == null) {
            return false;
        }
        int formalCount = target.getParameters().length;
        if (formalCount == 0) {
            return false;
        }
        if (argumentList.isPositional()) {
            if (posCount > formalCount) {
                return false;
            }
            this.myToNamed = true;
        } else {
            if (ChangeMacroCallStyle.rearrange(target.getParameters(), namedArguments) == null) {
                return false;
            }
            this.myToNamed = false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String newArgListText;
        if (project == null) {
            ChangeMacroCallStyle.$$$reportNull$$$0(4);
        }
        assert (this.myToNamed != null);
        FtlMacro macroCall = (FtlMacro)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), FtlMacro.class, (boolean)false);
        assert (macroCall != null);
        FtlArgumentList argumentList = macroCall.getArgumentList();
        FtlSignatureDirective macro = macroCall.resolveMacro();
        assert (macro != null);
        FtlParameterDeclaration[] formalParameters = macro.getParameters();
        if (this.myToNamed.booleanValue()) {
            FtlExpression[] positionalArguments = argumentList.getPositionalArguments();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < positionalArguments.length; ++i) {
                FtlExpression argument = positionalArguments[i];
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(formalParameters[i].getName()).append("=").append(argument.getText());
            }
            newArgListText = sb.toString();
        } else {
            FtlNameValuePair[] namedArgs = argumentList.getNamedArguments();
            Object[] rearranged = ChangeMacroCallStyle.rearrange(formalParameters, namedArgs);
            assert (rearranged != null);
            newArgListText = StringUtil.join((Object[])rearranged, arg -> {
                String text = arg.getText();
                return ChangeMacroCallStyle.shouldParenthesize(arg) ? "(" + text + ")" : text;
            }, (String)", ");
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        assert (document != null);
        TextRange range = argumentList.getTextRange();
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newArgListText);
    }

    private static boolean shouldParenthesize(PsiElement arg) {
        return arg instanceof FtlBinaryExpression && ((FtlBinaryExpression)arg).getOperationSign() == FtlElementTypes.EQ && ((FtlBinaryExpression)arg).getLeftOperand() instanceof FtlReferenceExpression;
    }

    @Nullable
    private static PsiElement[] rearrange(FtlParameterDeclaration[] formalParameters, FtlNameValuePair[] namedArgs) {
        PsiElement[] rearranged = new FtlExpression[formalParameters.length];
        for (FtlNameValuePair ftlNameValuePair : namedArgs) {
            String argName = ftlNameValuePair.getName();
            if (argName == null) {
                return null;
            }
            PsiElement valueElement = ftlNameValuePair.getValueElement();
            if (!(valueElement instanceof FtlExpression)) {
                return null;
            }
            for (int i = 0; i < formalParameters.length; ++i) {
                FtlParameterDeclaration parameter = formalParameters[i];
                if (!argName.equals(parameter.getName())) continue;
                if (rearranged[i] != null) {
                    return null;
                }
                rearranged[i] = (FtlExpression)valueElement;
            }
        }
        for (PsiElement psiElement : rearranged) {
            if (psiElement != null) continue;
            return null;
        }
        return rearranged;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/ChangeMacroCallStyle";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/ChangeMacroCallStyle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

