/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlCompletionContributor;
import com.intellij.freemarker.FtlIndexInfo;
import com.intellij.freemarker.FtlPathGenerator;
import com.intellij.freemarker.inspections.CreateFromUsageIntentionBase;
import com.intellij.freemarker.inspections.FtlDeclarationType;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlImportCallInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            FtlImportCallInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!isOnTheFly) {
                    return;
                }
                if (element instanceof FtlReferenceExpression) {
                    FtlImportCallInspection.this.checkCall(((FtlReferenceExpression)element).getReference(), holder);
                } else if (element instanceof FtlIndexExpression) {
                    FtlImportCallInspection.this.checkCall(((FtlIndexExpression)element).getQualifiedReference(), holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            FtlImportCallInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private void checkCall(@Nullable FtlQualifiedReference reference, ProblemsHolder holder) {
        String namespace;
        boolean macro;
        if (reference == null || reference.getAssignDeclaration() != null || reference.resolve() != null) {
            return;
        }
        if (reference.getValidExpression().getParent() instanceof FtlMacro) {
            macro = true;
        } else if (reference.isCall()) {
            macro = false;
        } else {
            return;
        }
        FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
        if (qualifier == null) {
            namespace = null;
        } else {
            if (qualifier.getType() != null) {
                return;
            }
            namespace = qualifier.getText();
        }
        String name = reference.getReferenceName();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)reference.getElement());
        if (module == null) {
            return;
        }
        SmartList fixes = new SmartList();
        FtlCompletionContributor.processAllFtlFiles(module, (FileBasedIndex.ValueProcessor<? super FtlIndexInfo>)((FileBasedIndex.ValueProcessor)(arg_0, arg_1) -> this.lambda$checkCall$0(macro, name, (List)fixes, namespace, module, arg_0, arg_1)));
        if (fixes.isEmpty()) {
            return;
        }
        holder.registerProblem(InspectionManager.getInstance((Project)reference.getElement().getProject()).createProblemDescriptor((PsiElement)reference.getElement(), reference.getRangeInElement(), "", ProblemHighlightType.WEAK_WARNING, holder.isOnTheFly(), fixes.toArray(LocalQuickFix.EMPTY_ARRAY)));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlImportCallInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            FtlImportCallInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.import.calls.inspection", new Object[0]);
        if (string == null) {
            FtlImportCallInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlImportCallInspection" == null) {
            FtlImportCallInspection.$$$reportNull$$$0(5);
        }
        return "FtlImportCallInspection";
    }

    @Nullable
    protected FtlDeclarationType getDeclarationType(Project project) {
        String explicit = FreeMarkerBundle.message("explicit", new Object[0]);
        int i = Messages.showYesNoCancelDialog((Project)project, (String)FreeMarkerBundle.message("choose.declaration.type.implicit.or.explicit", new Object[0]), (String)FreeMarkerBundle.message("choose.declaration.type", new Object[0]), (String)explicit, (String)FreeMarkerBundle.message("implicit", new Object[0]), (String)CommonBundle.getCancelButtonText(), null);
        if (i == 0) {
            return FtlDeclarationType.EXPLICIT;
        }
        if (i == 1) {
            return FtlDeclarationType.IMPLICIT;
        }
        return null;
    }

    private /* synthetic */ boolean lambda$checkCall$0(boolean macro, String name, List fixes, String namespace, Module module, VirtualFile file, FtlIndexInfo value) {
        Set<String> list;
        Set<String> set = list = macro ? value.macros : value.functions;
        if (list.contains(name)) {
            fixes.add(new FtlImportCallQuickFix(namespace, file, module));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlImportCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlImportCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FtlImportCallQuickFix
    extends CreateFromUsageIntentionBase
    implements LocalQuickFix,
    IntentionAction {
        private final String myNamespace;
        private final VirtualFile myFile;
        private final Module myModule;

        FtlImportCallQuickFix(String namespace, VirtualFile file, Module module) {
            this.myNamespace = namespace;
            this.myFile = file;
            this.myModule = module;
        }

        @NotNull
        public String getName() {
            String string = this.myNamespace == null ? FreeMarkerBundle.message("fix.include.file", this.myFile.getName()) : FreeMarkerBundle.message("fix.import.file", this.myFile.getName());
            if (string == null) {
                FtlImportCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                FtlImportCallQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                FtlImportCallQuickFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        @NotNull
        public String getFamilyName() {
            String string = FreeMarkerBundle.message("fix.import.or.include.file", new Object[0]);
            if (string == null) {
                FtlImportCallQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                FtlImportCallQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                FtlImportCallQuickFix.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException("Method applyFix is not yet implemented in " + this.getClass().getName());
        }

        @Override
        protected void addDeclaration(PsiFile sourceFile, Editor sourceEditor, PsiFile targetFile, Editor editor) throws IncorrectOperationException {
            String relativePath = new FtlPathGenerator(targetFile, this.myModule).generatePath(this.myFile);
            if (relativePath == null) {
                relativePath = this.myFile.getName();
            }
            FtlImportCallQuickFix.prepareInsertionPlace(sourceFile, targetFile, editor);
            FtlDirectiveStyle style = FtlLexer.guessDirectiveStyle(editor.getDocument().getCharsSequence());
            StringBuilder sb = new StringBuilder();
            String directiveName = "#" + (this.myNamespace == null ? "include" : "import");
            sb.append(style.getDirectiveStartChar()).append(directiveName).append(" '").append(relativePath).append("'");
            if (this.myNamespace != null) {
                sb.append(" as ").append(this.myNamespace);
            }
            sb.append(style.getDirectiveEndChar());
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)sb.toString());
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            FtlDeclarationType type;
            if (project == null) {
                FtlImportCallQuickFix.$$$reportNull$$$0(6);
            }
            if ((type = FtlImportCallInspection.this.getDeclarationType(project)) == null) {
                return;
            }
            if (type == FtlDeclarationType.EXPLICIT) {
                this.addDeclaration(file, editor, file);
                return;
            }
            this.chooseTargetFile(file, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/freemarker/inspections/FtlImportCallInspection$FtlImportCallQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

