/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlPsiUtil {
    @NotNull
    public static PsiElement parseFtlExpression(@NonNls String text, Project project) {
        FtlXmlRootTag rootTag = FtlPsiUtil.parseFtlFile("${" + text + "}", project);
        PsiElement interpolation = rootTag.getFirstChild();
        PsiElement elStart = interpolation.getFirstChild();
        PsiElement psiElement = (PsiElement)ObjectUtils.assertNotNull((Object)elStart.getNextSibling());
        if (psiElement == null) {
            FtlPsiUtil.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    public static FtlXmlRootTag parseFtlFile(@NonNls String text, Project project) {
        FtlFile file = (FtlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.ftl", (FileType)FtlFileType.INSTANCE, (CharSequence)text);
        return file.getRootTag();
    }

    public static FtlType getFtlTypeByPsiElement(PsiElement element, PsiSubstitutor substitutor) {
        if (element instanceof FtlVariable) {
            return ((FtlVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return new FtlMethodType((PsiMethod)element, substitutor);
        }
        if (element instanceof PsiField) {
            return FtlPsiType.wrap(GenericsUtil.eliminateWildcards((PsiType)substitutor.substitute(((PsiField)element).getType())));
        }
        if (element instanceof BeanProperty) {
            return FtlPsiType.wrap(GenericsUtil.eliminateWildcards((PsiType)substitutor.substitute(((BeanProperty)element).getPropertyType())));
        }
        return null;
    }

    @Nullable
    public static PsiClass resolveClassInType(@Nullable FtlType type) {
        PsiType psiType = FtlPsiUtil.extractPsiType(type);
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    @Nullable
    public static PsiType extractPsiType(@Nullable FtlType type) {
        FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(type, FtlPsiType.class);
        if (ftlPsiType == null) {
            return null;
        }
        return ftlPsiType.getPsiType();
    }

    @Nullable
    public static <T extends FtlType> T asInstanceOf(@Nullable FtlType type, Class<T> aClass) {
        return type == null ? null : (T)type.asInstanceOf(aClass);
    }

    @Nullable
    public static FtlType mergeTypes(@Nullable FtlType type1, @Nullable FtlType type2) {
        THashSet set = new THashSet();
        FtlPsiUtil.addAllTypeComponents(type1, (Collection<? super FtlType>)set);
        FtlPsiUtil.addAllTypeComponents(type2, (Collection<? super FtlType>)set);
        if (set.isEmpty()) {
            return null;
        }
        return set.size() == 1 ? (FtlType)set.iterator().next() : new FtlCompositeType(set.toArray(new FtlType[0]));
    }

    public static void addAllTypeComponents(FtlType type, Collection<? super FtlType> set) {
        if (type instanceof FtlCompositeType) {
            ContainerUtil.addAll(set, (Object[])((FtlCompositeType)type).getComponents());
        } else {
            ContainerUtil.addIfNotNull(set, (Object)type);
        }
    }

    public static <T extends FtlType> List<T> getAllTypeComponents(@Nullable FtlType type, Class<T> aClass) {
        SmartList set = new SmartList();
        FtlPsiUtil.addAllTypeComponents(type, (Collection<? super FtlType>)set);
        return ContainerUtil.findAll((Collection)set, aClass);
    }

    public static boolean isNumeric(@Nullable FtlType qualifierType, @NotNull PsiElement context) {
        if (context == null) {
            FtlPsiUtil.$$$reportNull$$$0(1);
        }
        if (qualifierType == null) {
            return false;
        }
        FtlPsiType type = qualifierType.asInstanceOf(FtlPsiType.class);
        if (type == null) {
            return false;
        }
        PsiType psiType = type.getPsiType();
        if (PsiType.DOUBLE.isConvertibleFrom(psiType)) {
            return true;
        }
        return JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText("java.lang.Number", context).isAssignableFrom(psiType);
    }

    public static boolean isAssignableToClass(@Nullable FtlType type, @NonNls String qName) {
        return FtlPsiUtil.getAllTypeComponents(type, FtlPsiType.class).stream().anyMatch(it -> InheritanceUtil.isInheritor((PsiType)it.getPsiType(), (String)qName));
    }

    @Nullable
    public static String[] splitVarNames(String ref, Project project) {
        if (StringUtil.isEmpty((String)ref)) {
            return new String[]{""};
        }
        return FtlPsiUtil.splitVarNames(FtlPsiUtil.parseQualifiedReference(ref, project));
    }

    @Nullable
    public static FtlQualifiedReference parseQualifiedReference(String ref, Project project) {
        FtlXmlRootTag rootTag = FtlPsiUtil.parseFtlFile("${" + ref + "}", project);
        PsiElement interpolation = rootTag.getFirstChild();
        if (interpolation == null) {
            return null;
        }
        PsiElement elStart = interpolation.getFirstChild();
        if (elStart == null) {
            return null;
        }
        return FtlPsiUtil.getReference(elStart.getNextSibling());
    }

    @Nullable
    public static FtlQualifiedReference getReference(PsiElement expression) {
        if (expression instanceof FtlReferenceExpression) {
            return ((FtlReferenceExpression)expression).getReference();
        }
        if (expression instanceof FtlIndexExpression) {
            return ((FtlIndexExpression)expression).getQualifiedReference();
        }
        return null;
    }

    @Nullable
    public static String[] splitVarNames(@Nullable FtlQualifiedReference reference) {
        if (reference == null) {
            return null;
        }
        LinkedList<String> names = new LinkedList<String>();
        while (reference != null) {
            String referenceName = reference.getReferenceName();
            if (referenceName == null) {
                return null;
            }
            names.addFirst(referenceName);
            FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
            if (qualifier == null || FtlPsiUtil.isSpecialVarHash(qualifier)) {
                return ArrayUtil.toStringArray(names);
            }
            reference = FtlPsiUtil.getReference(qualifier);
        }
        return null;
    }

    private static boolean isSpecialVarHash(FtlReferenceQualifier qualifier) {
        String text = qualifier.getText();
        return ".vars".equals(text) || ".data_model".equals(text) || ".main".equals(text);
    }

    public static boolean isValidVariableName(String name) {
        if ("*".equals(name) || "**".equals(name) || "@@".equals(name)) {
            return true;
        }
        if (name.startsWith("@@")) {
            return StringUtil.isJavaIdentifier((String)name.substring(2));
        }
        if (name.startsWith("@")) {
            return StringUtil.isJavaIdentifier((String)name.substring(1));
        }
        return StringUtil.isJavaIdentifier((String)name) || name.length() > 1 && name.charAt(0) == '.' && StringUtil.isJavaIdentifier((String)name.substring(1));
    }

    public static boolean isUsingCamelCase(@NotNull FtlFile _file) {
        if (_file == null) {
            FtlPsiUtil.$$$reportNull$$$0(2);
        }
        final PsiFile file = _file.getOriginalFile();
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            private String getFtlName(PsiElement element) {
                if (element instanceof FtlBuiltIn) {
                    return ((FtlBuiltIn)element).getBuiltInName();
                }
                if (element instanceof FtlReferenceExpression) {
                    String name = ((FtlReferenceExpression)element).getReference().getReferenceName();
                    return name != null && name.startsWith(".") ? name : null;
                }
                if (element instanceof FtlDirective) {
                    PsiElement name = ((FtlDirective)element).getStartTagNameElement();
                    return name != null && ((FtlDirective)element).getDirectiveName() != null ? name.getText() : null;
                }
                if (element instanceof FtlNameValuePair && element.getParent() instanceof FtlDirective && Arrays.asList("ftl", "setting").contains(((FtlDirective)element.getParent()).getDirectiveName())) {
                    return ((FtlNameValuePair)element).getName();
                }
                return null;
            }

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                for (PsiElement element : SyntaxTraverser.psiTraverser((PsiElement)file)) {
                    String name = this.getFtlName(element);
                    if (name == null || !StringUtil.hasUpperCaseChar((String)name)) continue;
                    return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{file});
                }
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{file});
            }
        });
    }

    @Nullable
    public static String camelToSnakeCase(@Nullable String name) {
        if (name != null && StringUtil.hasUpperCaseChar((String)name)) {
            int prefixLength = name.startsWith(".") ? 1 : 0;
            return name.substring(0, prefixLength) + StringUtil.join((Collection)NameUtil.nameToWordsLowerCase((String)name.substring(prefixLength)), (String)"_");
        }
        return null;
    }

    public static boolean hasFtlViewProvider(@NotNull PsiFile file) {
        if (file == null) {
            FtlPsiUtil.$$$reportNull$$$0(3);
        }
        return file.getViewProvider().getBaseLanguage().isKindOf((Language)FtlLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/FtlPsiUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFtlExpression";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/FtlPsiUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isNumeric";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUsingCamelCase";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasFtlViewProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

